/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.util;

import com.atlassian.plugin.spring.scanner.ProductFilter;
import com.atlassian.plugin.spring.scanner.util.ProductFilterUtil;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class AnnotationIndexReader {
    private static final Log log = LogFactory.getLog(AnnotationIndexReader.class);

    public static List<String> readIndexFile(String string, Bundle bundle) {
        URL uRL = bundle.getResource(string);
        return AnnotationIndexReader.readIndexFile(uRL);
    }

    public static List<String> readIndexFile(String string, ClassLoader classLoader) {
        URL uRL = classLoader.getResource(string);
        List<String> list = AnnotationIndexReader.readIndexFile(uRL);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Read annotation index file: " + string));
            log.debug((Object)"Printing out found annotated beans: ");
            log.debug(list);
        }
        return list;
    }

    public static List<String> readAllIndexFilesForProduct(String string, Bundle bundle) {
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL = bundle.getResource(string);
        arrayList.addAll(AnnotationIndexReader.readIndexFile(uRL));
        ProductFilter productFilter = ProductFilterUtil.getFilterForCurrentProduct(bundle.getBundleContext());
        if (null != productFilter) {
            arrayList.addAll(AnnotationIndexReader.readIndexFile(productFilter.getPerProductFile(string), bundle));
        }
        return arrayList;
    }

    public static List<String> readAllIndexFilesForProduct(String string, ClassLoader classLoader, @Nullable BundleContext bundleContext) {
        ArrayList<String> arrayList = new ArrayList<String>();
        URL uRL = classLoader.getResource(string);
        arrayList.addAll(AnnotationIndexReader.readIndexFile(uRL));
        ProductFilter productFilter = ProductFilterUtil.getFilterForCurrentProduct(bundleContext);
        if (null != productFilter) {
            arrayList.addAll(AnnotationIndexReader.readIndexFile(productFilter.getPerProductFile(string), classLoader));
        }
        return arrayList;
    }

    public static List<String> readIndexFile(URL uRL) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader;
            if (null == uRL) {
                return arrayList;
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return arrayList;
            }
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read index file [" + uRL.toString() + "]", iOException);
        }
        return arrayList;
    }

    public static Properties readPropertiesFile(URL uRL) {
        Properties properties = new Properties();
        try {
            BufferedReader bufferedReader;
            if (null == uRL) {
                return properties;
            }
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), Charsets.UTF_8));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return properties;
            }
            properties.load(bufferedReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot read properties file [" + uRL.toString() + "]", iOException);
        }
        return properties;
    }

    public static String[] splitProfiles(String string) {
        return StringUtils.isNotBlank((String)string) ? StringUtils.split((String)string, (char)',') : new String[]{};
    }

    public static Iterable<String> getIndexFilesForProfiles(String[] stringArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray.length > 0) {
            for (String string2 : stringArray) {
                if (!StringUtils.isNotBlank((String)(string2 = StringUtils.defaultIfBlank((String)string2, (String)"").trim()))) continue;
                String string3 = "META-INF/plugin-components/profile-" + string2 + "/" + string;
                arrayList.add(string3);
            }
        } else {
            String string4 = "META-INF/plugin-components/" + string;
            arrayList.add(string4);
        }
        return arrayList;
    }
}

