/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.export.ModuleType;
import com.atlassian.plugin.spring.scanner.extension.ExportedSeviceManager;
import com.atlassian.plugin.spring.scanner.util.AnnotationIndexReader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;

public class ServiceExporterBeanPostProcessor
implements InitializingBean,
DestructionAwareBeanPostProcessor {
    public static final String OSGI_SERVICE_SUFFIX = "_osgiService";
    static final String ATLASSIAN_DEV_MODE_PROP = "atlassian.dev.mode";
    private final Log log = LogFactory.getLog(this.getClass());
    private final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private final BundleContext bundleContext;
    private ConfigurableListableBeanFactory beanFactory;
    private String profileName;
    private final ExportedSeviceManager serviceManager;
    private ImmutableMap<String, String[]> exports;

    public ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory configurableListableBeanFactory) {
        this(bundleContext, configurableListableBeanFactory, new ExportedSeviceManager());
    }

    ServiceExporterBeanPostProcessor(BundleContext bundleContext, ConfigurableListableBeanFactory configurableListableBeanFactory, ExportedSeviceManager exportedSeviceManager) {
        this.bundleContext = bundleContext;
        this.beanFactory = configurableListableBeanFactory;
        this.profileName = null;
        this.serviceManager = exportedSeviceManager;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public void afterPropertiesSet() throws Exception {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String[] stringArray = AnnotationIndexReader.splitProfiles(this.profileName);
        this.parseExportsForExportFile((ImmutableMap.Builder<String, String[]>)builder, "exports", stringArray);
        if (this.isDevMode) {
            this.parseExportsForExportFile((ImmutableMap.Builder<String, String[]>)builder, "dev-exports", stringArray);
        }
        this.exports = builder.build();
    }

    private void parseExportsForExportFile(ImmutableMap.Builder<String, String[]> builder, String string, String[] stringArray) {
        String[] stringArray2 = new String[]{};
        for (String string2 : AnnotationIndexReader.getIndexFilesForProfiles(stringArray, string)) {
            List<String> list = AnnotationIndexReader.readAllIndexFilesForProduct(string2, this.bundleContext.getBundle());
            for (String string3 : list) {
                String[] stringArray3 = StringUtils.split((String)string3, (char)'#');
                String string4 = stringArray3[0];
                String[] stringArray4 = stringArray3.length > 1 ? StringUtils.split((String)stringArray3[1], (char)',') : stringArray2;
                builder.put((Object)string4, (Object)stringArray4);
            }
        }
    }

    public void postProcessBeforeDestruction(Object object, String string) throws BeansException {
        if (this.serviceManager.hasService(object)) {
            Object object2;
            this.serviceManager.unregisterService(this.bundleContext, object);
            String string2 = this.getServiceName(string);
            if (this.beanFactory.containsBean(string2) && null != (object2 = this.beanFactory.getBean(string2))) {
                this.beanFactory.destroyBean(string2, object2);
            }
        }
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        Class[] classArray = new Class[]{};
        Class clazz = AopUtils.getTargetClass((Object)object);
        String string2 = clazz.getName();
        if (this.exports.containsKey((Object)string2) || this.isPublicComponent(clazz)) {
            Object object2;
            ImmutableList.Builder builder;
            if (this.exports.containsKey((Object)string2)) {
                String[] stringArray;
                builder = ImmutableList.builder();
                object2 = object.getClass().getClassLoader();
                for (String string3 : stringArray = (String[])this.exports.get((Object)string2)) {
                    try {
                        Class<?> clazz2 = ((ClassLoader)object2).loadClass(string3);
                        builder.add(clazz2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        this.log.warn((Object)("Cannot find class for export '" + string3 + "' of bean '" + string + "': " + classNotFoundException));
                    }
                }
                classArray = (Class[])Iterables.toArray((Iterable)builder.build(), Class.class);
            } else if (this.hasAnnotation(clazz, ModuleType.class)) {
                classArray = clazz.getAnnotation(ModuleType.class).value();
            } else if (this.hasAnnotation(clazz, ExportAsService.class)) {
                classArray = clazz.getAnnotation(ExportAsService.class).value();
            } else if (this.hasAnnotation(clazz, ExportAsDevService.class)) {
                classArray = clazz.getAnnotation(ExportAsDevService.class).value();
            }
            if (classArray.length < 1 && (classArray = clazz.getInterfaces()).length < 1) {
                classArray = new Class[]{clazz};
            }
            try {
                builder = this.serviceManager.registerService(this.bundleContext, object, string, new Hashtable<String, Object>(), classArray);
                object2 = this.getServiceName(string);
                this.beanFactory.initializeBean((Object)builder, (String)object2);
            }
            catch (Exception exception) {
                this.log.error((Object)("Unable to register bean '" + string + "' as an OSGi exported service"), (Throwable)exception);
            }
        }
        return object;
    }

    private boolean isPublicComponent(Class clazz) {
        return this.hasAnnotation(clazz, ModuleType.class) || this.hasAnnotation(clazz, ExportAsService.class) || this.hasAnnotation(clazz, ExportAsDevService.class) && this.isDevMode;
    }

    private boolean hasAnnotation(Class clazz, Class<? extends Annotation> clazz2) {
        return clazz.isAnnotationPresent(clazz2);
    }

    private String getServiceName(String string) {
        return string + OSGI_SERVICE_SUFFIX;
    }
}

