/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class DevModeBeanInitialisationLoggerBeanPostProcessor
implements DisposableBean,
InitializingBean,
DestructionAwareBeanPostProcessor,
InstantiationAwareBeanPostProcessor {
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private volatile Log log;
    private final BundleContext bundleContext;

    public DevModeBeanInitialisationLoggerBeanPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object postProcessBeforeInitialization(Object object, String string) throws BeansException {
        return object;
    }

    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        this.logBeanDetail("AfterInitialisation", object.getClass(), string);
        return object;
    }

    public Object postProcessBeforeInstantiation(Class clazz, String string) throws BeansException {
        this.logBeanDetail("BeforeInstantiation", clazz, string);
        return null;
    }

    public boolean postProcessAfterInstantiation(Object object, String string) throws BeansException {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues propertyValues, PropertyDescriptor[] propertyDescriptorArray, Object object, String string) throws BeansException {
        return propertyValues;
    }

    public void postProcessBeforeDestruction(Object object, String string) throws BeansException {
        this.logBeanDetail("BeforeDestruction", object.getClass(), string);
    }

    private void logBeanDetail(String string, Class clazz, String string2) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("%s [bean=%s, type=%s]", string, string2, clazz.getName()));
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.log = LogFactory.getLog((String)this.getLoggerName());
        Bundle bundle = this.bundle();
        if (isDevMode) {
            String string = this.getLoggerName();
            String string2 = String.format("\nSpring context started for bundle : %s id(%d) v(%s) %s\n\nIf you want to debug the Spring wiring of your code then set a DEBUG level log level as follows.  [ This is a dev.mode only message. ]\n\tlog4j.logger.%s  = DEBUG, console, filelog\n", bundle.getSymbolicName(), bundle.getBundleId(), bundle.getVersion(), bundle.getLocation(), string);
            this.log.warn((Object)string2);
        }
        this.printBundleDebugInfo(bundle);
    }

    public void destroy() throws Exception {
        if (isDevMode) {
            Bundle bundle = this.bundle();
            this.log.warn((Object)String.format("\n\n\tSpring context destroyed : %s id(%d) v(%s) \n", bundle.getSymbolicName(), bundle.getBundleId(), bundle.getVersion()));
        }
    }

    private void printBundleDebugInfo(Bundle bundle) {
        if (this.log.isDebugEnabled()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println();
            printWriter.format("\tBundle Id : %d\n", bundle.getBundleId());
            printWriter.format("\tBundle Name : %s\n", bundle.getSymbolicName());
            printWriter.format("\tBundle Location : %s\n", bundle.getLocation());
            printWriter.format("\tBundle Version : %s\n", bundle.getVersion());
            printWriter.format("\tBundle Headers :\n", new Object[0]);
            Dictionary dictionary = bundle.getHeaders();
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                printWriter.format("\t\t%s: %s\n", k, v);
            }
            printWriter.println();
            this.log.debug((Object)stringWriter.toString());
        }
    }

    private Bundle bundle() {
        return this.bundleContext.getBundle();
    }

    private String getLoggerName() {
        return String.format("%s.spring", this.bundle().getSymbolicName());
    }
}

