/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.extension.ClassIndexBeanDefinitionScanner;
import com.atlassian.plugin.spring.scanner.extension.ComponentImportBeanFactoryPostProcessor;
import com.atlassian.plugin.spring.scanner.extension.DevModeBeanInitialisationLoggerBeanPostProcessor;
import com.atlassian.plugin.spring.scanner.extension.ServiceExporterBeanPostProcessor;
import com.atlassian.plugin.spring.scanner.util.SpringDMUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class AtlassianScannerBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String AUTO_IMPORTS_ATTRIBUTE = "auto-imports";
    private static final String PROFILE_ATTRIBUTE = "profile";
    public static final String JAVAX_INJECT_CLASSNAME = "javax.inject.Inject";
    private final Log log = LogFactory.getLog(this.getClass());

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean bl = false;
        String string = null;
        Integer n = null;
        if (element.hasAttribute(AUTO_IMPORTS_ATTRIBUTE)) {
            bl = Boolean.parseBoolean(element.getAttribute(AUTO_IMPORTS_ATTRIBUTE));
        }
        if (element.hasAttribute(PROFILE_ATTRIBUTE)) {
            string = element.getAttribute(PROFILE_ATTRIBUTE);
        }
        if (element.hasAttribute("autowire")) {
            n = parserContext.getDelegate().getAutowireMode(element.getAttribute("autowire"));
        }
        BundleContext bundleContext = this.getBundleContext(parserContext);
        ClassIndexBeanDefinitionScanner classIndexBeanDefinitionScanner = new ClassIndexBeanDefinitionScanner(parserContext.getReaderContext().getRegistry(), string, n, bundleContext);
        Set<BeanDefinitionHolder> set = classIndexBeanDefinitionScanner.doScan();
        this.registerComponents(parserContext.getReaderContext(), set, element, bl, string);
        return null;
    }

    protected void registerComponents(XmlReaderContext xmlReaderContext, Set<BeanDefinitionHolder> set, Element element, boolean bl, String string) {
        BeanDefinitionHolder beanDefinitionHolder2;
        Object object = xmlReaderContext.extractSource((Object)element);
        CompositeComponentDefinition compositeComponentDefinition = new CompositeComponentDefinition(element.getTagName(), object);
        for (BeanDefinitionHolder beanDefinitionHolder2 : set) {
            compositeComponentDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefinitionHolder2));
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)xmlReaderContext.getRegistry(), (Object)object));
        beanDefinitionHolder2 = this.getJavaxInjectPostProcessor(xmlReaderContext.getRegistry(), object);
        if (null != beanDefinitionHolder2) {
            linkedHashSet.add(beanDefinitionHolder2);
        }
        linkedHashSet.add(this.getComponentImportPostProcessor(xmlReaderContext.getRegistry(), object, bl, string));
        linkedHashSet.add(this.getServiceExportPostProcessor(xmlReaderContext.getRegistry(), object, string));
        linkedHashSet.add(this.getDevModeBeanInitialisationLoggerPostProcessor(xmlReaderContext.getRegistry(), object));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            BeanDefinitionHolder beanDefinitionHolder3 = (BeanDefinitionHolder)iterator.next();
            compositeComponentDefinition.addNestedComponent((ComponentDefinition)new BeanComponentDefinition(beanDefinitionHolder3));
        }
        xmlReaderContext.fireComponentRegistered((ComponentDefinition)compositeComponentDefinition);
    }

    @Nullable
    private BundleContext getBundleContext(ParserContext parserContext) {
        return SpringDMUtil.getInstance().getOsgiBundleContextAccessor().getBundleContext(parserContext.getReaderContext().getResourceLoader());
    }

    private BeanDefinitionHolder getJavaxInjectPostProcessor(BeanDefinitionRegistry beanDefinitionRegistry, Object object) {
        if (ClassUtils.isPresent((String)JAVAX_INJECT_CLASSNAME, (ClassLoader)this.getClass().getClassLoader())) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(JAVAX_INJECT_CLASSNAME);
                HashMap hashMap = new HashMap();
                hashMap.put("autowiredAnnotationType", clazz);
                RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(AutowiredAnnotationBeanPostProcessor.class);
                rootBeanDefinition.setSource(object);
                rootBeanDefinition.setRole(2);
                rootBeanDefinition.setPropertyValues(new MutablePropertyValues(hashMap));
                return this.registerBeanPostProcessor(beanDefinitionRegistry, rootBeanDefinition, "javaxInjectBeanPostProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.log.error((Object)"Unable to load class 'javax.inject.Inject' for javax component purposes.  Not sure how this is possible.  Skipping...");
            }
        }
        return null;
    }

    private BeanDefinitionHolder registerBeanPostProcessor(BeanDefinitionRegistry beanDefinitionRegistry, RootBeanDefinition rootBeanDefinition, String string) {
        rootBeanDefinition.setRole(2);
        beanDefinitionRegistry.registerBeanDefinition(string, (BeanDefinition)rootBeanDefinition);
        return new BeanDefinitionHolder((BeanDefinition)rootBeanDefinition, string);
    }

    private BeanDefinitionHolder getComponentImportPostProcessor(BeanDefinitionRegistry beanDefinitionRegistry, Object object, boolean bl, String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("autoImports", bl);
        hashMap.put("profileName", string);
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(ComponentImportBeanFactoryPostProcessor.class);
        rootBeanDefinition.setAutowireMode(3);
        rootBeanDefinition.setSource(object);
        rootBeanDefinition.setPropertyValues(new MutablePropertyValues(hashMap));
        return this.registerBeanPostProcessor(beanDefinitionRegistry, rootBeanDefinition, "componentImportBeanFactoryPostProcessor");
    }

    private BeanDefinitionHolder getServiceExportPostProcessor(BeanDefinitionRegistry beanDefinitionRegistry, Object object, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("profileName", string);
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(ServiceExporterBeanPostProcessor.class);
        rootBeanDefinition.setSource(object);
        rootBeanDefinition.setAutowireMode(3);
        rootBeanDefinition.setPropertyValues(new MutablePropertyValues(hashMap));
        return this.registerBeanPostProcessor(beanDefinitionRegistry, rootBeanDefinition, "serviceExportBeanPostProcessor");
    }

    private BeanDefinitionHolder getDevModeBeanInitialisationLoggerPostProcessor(BeanDefinitionRegistry beanDefinitionRegistry, Object object) {
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(DevModeBeanInitialisationLoggerBeanPostProcessor.class);
        rootBeanDefinition.setSource(object);
        rootBeanDefinition.setAutowireMode(3);
        return this.registerBeanPostProcessor(beanDefinitionRegistry, rootBeanDefinition, "devModeBeanInitialisationLoggerBeanPostProcessor");
    }
}

