/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.joda.time.Years;

@Scanned
public class CountdownMacro
implements Macro {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.countdown.CountdownMacro");
    private static final String b = "/templates/countdown-macro.vm";
    private static final String c = "/templates/countdown-macro-error.vm";
    private static final String d = "/templates/unlicensed.vm";
    private static final String e = "errorMessage";
    private static final String f = "title";
    private static final String g = "countdowndate";
    private static final String h = "centered";
    private static final String i = "format";
    private static final String j = "size";
    private static final String k = "style";
    private final ConfluenceWebResourceManager l;
    private final I18nResolver m;
    private final PluginSettingsFactory n;

    public CountdownMacro(@ComponentImport ConfluenceWebResourceManager confluenceWebResourceManager, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport I18nResolver i18nResolver) {
        this.l = confluenceWebResourceManager;
        this.n = pluginSettingsFactory;
        this.m = i18nResolver;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> map, String string, ConversionContext conversionContext) {
        Map map2 = MacroUtils.defaultVelocityContext();
        boolean bl = this.a();
        if (!bl) {
            a.debug((Object)"License is invalid");
            return VelocityUtils.getRenderedTemplate((String)d, (Map)map2);
        }
        String string2 = map.get(g);
        a.debug((Object)("Countdown date [" + string2 + "]"));
        if (string2 == null) {
            a.debug((Object)"Countdown date is null");
            map2.put(e, this.m.getText("com.akelesconsulting.confluence.plugins.countdown.error.date"));
            return VelocityUtils.getRenderedTemplate((String)c, (Map)map2);
        }
        String string3 = StringEscapeUtils.escapeHtml4((String)string2);
        if (!string2.equalsIgnoreCase(string3)) {
            a.debug((Object)("Countdown date contains invalid characters, [" + string2 + "] != [" + string3 + "]"));
            map2.put(e, this.m.getText("com.akelesconsulting.confluence.plugins.countdown.error.invalidChars"));
            return VelocityUtils.getRenderedTemplate((String)c, (Map)map2);
        }
        try {
            ContentEntityObject contentEntityObject = conversionContext.getEntity();
            if (contentEntityObject != null) {
                map2.put("contentUrlPath", contentEntityObject.getUrlPath());
            }
            this.a(map, map2, string2);
            this.l.requireResourcesForContext("akeles.countdown.resource.context");
            return VelocityUtils.getRenderedTemplate((String)b, (Map)map2);
        }
        catch (ParseException parseException) {
            map2.put(e, this.m.getText("com.akelesconsulting.confluence.plugins.countdown.error.format", new Serializable[]{string2}));
            return VelocityUtils.getRenderedTemplate((String)c, (Map)map2);
        }
    }

    private void a(Map<String, String> map, @NotNull Map<String, Object> map2, String string) throws ParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.a(string));
        DateTime dateTime = new DateTime();
        DateTime dateTime2 = CountdownMacro.a(string, gregorianCalendar);
        int n = Years.yearsBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getYears();
        int n2 = Months.monthsBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getMonths();
        int n3 = Weeks.weeksBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getWeeks();
        int n4 = Days.daysBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getDays();
        int n5 = Hours.hoursBetween((ReadableInstant)dateTime, (ReadableInstant)dateTime2).getHours();
        map2.put("isPastDate", n4 <= 0 && dateTime2.isBeforeNow());
        map2.put("countdownDate", dateTime2.toString());
        a.debug((Object)("Countdown from [" + dateTime + "] to [" + dateTime2 + "]"));
        String string2 = this.d(map);
        String string3 = string2.split(":")[0];
        boolean bl = string3.contains("years");
        boolean bl2 = string3.contains("months");
        boolean bl3 = string3.contains("weeks");
        boolean bl4 = string3.contains("days");
        boolean bl5 = string3.contains("hours");
        map2.put("isExceedMaxHours", bl5 && n5 > 9999);
        map2.put("displayFormat", string2);
        map2.put("yearFormat", bl);
        map2.put("monthFormat", bl2);
        map2.put("weekFormat", bl3);
        map2.put("dayFormat", bl4);
        map2.put("hourFormat", bl5);
        n4 = CountdownMacro.a(n, n2, n3, n4, bl, bl2, bl3);
        boolean bl6 = map.get(f) == null;
        boolean bl7 = !string2.contains("years");
        boolean bl8 = !string2.contains("months");
        boolean bl9 = !string2.contains("weeks");
        boolean bl10 = !string2.contains("days");
        boolean bl11 = !string2.contains("hours");
        boolean bl12 = !string2.contains("mins");
        boolean bl13 = !string2.contains("secs");
        String string4 = this.a(map);
        if (bl6) {
            if (!bl7) {
                map2.put("yearsWidth", this.a(n, string4));
            }
            if (!bl8) {
                map2.put("monthsWidth", this.a(n2, string4));
            }
            if (!bl9) {
                map2.put("weeksWidth", this.a(n3, string4));
            }
            if (!bl10) {
                map2.put("daysWidth", this.a(n4, string4));
            }
            if (!bl11) {
                map2.put("hoursWidth", this.a(n5, string4, bl10));
            }
        }
        map2.put(j, string4);
        map2.put("filename", this.b(map));
        map2.put("hideYears", bl7);
        map2.put("hideMonths", bl8);
        map2.put("hideWeeks", bl9);
        map2.put("hideDays", bl10);
        map2.put("hideHours", bl11);
        map2.put("hideMinutes", bl12);
        map2.put("hideSeconds", bl13);
        map2.put("showTitle", bl6);
        map2.put("isCenterAlign", map.get(h) != null);
        map2.put("isMobileAppRequest", this.c(map2));
    }

    private static int a(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            n4 -= n * 365;
        } else if (bl2) {
            n4 -= n2 * 30;
        } else if (bl3) {
            n4 -= n3 * 7;
        }
        return n4;
    }

    @NotNull
    private static DateTime a(String string, Calendar calendar) {
        DateTime dateTime = new DateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), 0, 0, 0, 0);
        int n = string.length();
        if (n == 14 || n == 20) {
            dateTime = new DateTime(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), 0, 0);
        }
        return dateTime;
    }

    private boolean a() {
        PluginSettings pluginSettings = this.n.createGlobalSettings();
        String string = (String)pluginSettings.get("com.akelesconsulting.confluence.plugins.CountdownConfigResource$Config.key");
        return string != null && string.equalsIgnoreCase("419aa355d57ed1ab72cdb15f4cfa9dd688");
    }

    private boolean c(@NotNull Map<String, Object> map) {
        Object object = map.get("req");
        if (object instanceof HttpServletRequest) {
            return "true".equals(((HttpServletRequest)object).getHeader("mobile-app-request"));
        }
        return false;
    }

    public String a(@NotNull Map<String, String> map) {
        String string = map.get(j);
        string = string == null || string.equalsIgnoreCase("Medium") ? "md" : (string.equalsIgnoreCase("Extra Small") ? "xs" : (string.equalsIgnoreCase("Small") ? "sm" : "lg"));
        return string;
    }

    public String b(@NotNull Map<String, String> map) {
        String string = map.get(k);
        String string2 = string == null || string.equalsIgnoreCase("digits") ? "digits.png" : (string.equalsIgnoreCase("white") ? "digits_inverted.png" : (string.equalsIgnoreCase("digital") ? "digits2.png" : "circle"));
        return string2;
    }

    @NotNull
    private String d(@NotNull Map<String, String> map) {
        String string = map.get(i);
        if (string == null) {
            string = "days:hours:mins:secs";
        }
        return string;
    }

    private Date a(@NotNull String string) throws ParseException {
        int n = string.length();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM-yy HH:mm X");
        if (n == 8) {
            simpleDateFormat = new SimpleDateFormat("dd-MM-yy");
        } else if (n == 10) {
            simpleDateFormat = new SimpleDateFormat("dd-MM-yyyy");
        } else if (n == 14) {
            simpleDateFormat = new SimpleDateFormat("dd-MM-yy HH:mm");
        }
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(string);
    }

    private int a(int n, String string) {
        int n2 = 0;
        if (n > 999) {
            n2 = this.b(string);
        } else if (n > 99) {
            n2 = this.c(string);
        }
        return n2;
    }

    private int a(int n, String string, boolean bl) {
        int n2 = 0;
        if (n > 999 && bl) {
            n2 = this.b(string);
        } else if (n > 99 && bl) {
            n2 = this.c(string);
        }
        return n2;
    }

    private int b(@NotNull String string) {
        int n;
        switch (string) {
            case "md": {
                n = 144;
                break;
            }
            case "sm": {
                n = 96;
                break;
            }
            case "xs": {
                n = 64;
                break;
            }
            default: {
                n = 212;
            }
        }
        return n;
    }

    private int c(@NotNull String string) {
        int n;
        switch (string) {
            case "md": {
                n = 108;
                break;
            }
            case "sm": {
                n = 72;
                break;
            }
            case "xs": {
                n = 48;
                break;
            }
            default: {
                n = 159;
            }
        }
        return n;
    }
}

