//min height id: macro-param-height
//width id: macro-param-width

var hinchMacroEditor = function() {};

// A function to run before the form fields are converted into a macro parameter string
hinchMacroEditor.prototype.beforeParamsRetrieved = function(params)
{
    var width = 100;

    AJS.$('#macro-param-width').on('input', function() {
    	var input = $(this);
    	width = parseInt(input.val()) || 100;
    	if (!(width >=0 && width <= 100))
        {
    		width = 100;
        }
    });

    AJS.$('#macro-param-width').change(function(){
    	document.getElementById('macro-param-width').value = width;
    	console.log("Panel Width is: " + width);
    });

    var height = 0;

    AJS.$('#macro-param-height').on('input', function() {
        var input = $(this);
        height = parseInt(input.val()) || 0;
        if (!(height >=0))
        {
            height = 0;
        }
    });

    AJS.$('#macro-param-height').change(function(){
        document.getElementById('macro-param-height').value = height;
        console.log("Panel height is: " + height);
    });

    return params;           // Return the edited Parameter settings
}

// Replace the newly created macro with javascript embedded into the macro named 'hinchpanel'
AJS.MacroBrowser.Macros['hinchpanel'] = new hinchMacroEditor();
