
AJS.bind("init.rte", function() {
var updateMacro = function(macroNode, param) {
    var $macroDiv = AJS.$(macroNode);
    AJS.Rte.getEditor().selection.select($macroDiv[0]);
    AJS.Rte.BookmarkManager.storeBookmark();

    var currentParams = {};
    if ($macroDiv.attr("data-macro-parameters")) {
        AJS.$.each($macroDiv.attr("data-macro-parameters").split("|"), function(idx, item) {
            var param = item.split("=");
            currentParams[param[0]] = param[1];
        });
    }

    var macrobody = AJS.$("td.wysiwyg-macro-body", macroNode);
    var macroDOM =  AJS.$("td.wysiwyg-macro-body", macroNode).get(0);
    macrohtml = macrobody.html()
    macrohtml = macrohtml.ReplaceAll("&lt;","<");
    macrohtml = macrohtml.ReplaceAll("&gt;",">");
    macrohtml = htmlTree(macroDOM);

    currentParams["color"] = param;
    var macroRenderRequest = {
        contentId: Confluence.Editor.getContentId(),
        macro: {
            name: "hinchpanel",
            params: currentParams,
            defaultParameterValue: "",
            body : macrohtml
        }
    };

    tinymce.confluence.MacroUtils.insertMacro(macroRenderRequest);
};

function htmlTree(obj)
{
    var xhtmlString = '';
    if (obj.hasChildNodes())
    {
        var child = obj.firstChild;
        while (child)
		{
			if (child.nodeType == 1) //elements
			{
				//iterate through the attributes
				xhtmlString = xhtmlString + '<' + child.nodeName;
				for (var i=0; i < child.attributes.length; i++)
				{
					var attrib = child.attributes[i];
					var attribValue = attrib.value
                    attribValue= attribValue.replace(/\&/g,'&amp;');

					xhtmlString = xhtmlString + ' ' + attrib.name + '="' + attribValue + '"';
				}
				xhtmlString = xhtmlString + '>' + htmlTree(child) + '</' + child.nodeName + '>';
			}
			else if (child.nodeType == 3)  //text nodes
			{
				if (xhtmlString)
					xhtmlString = xhtmlString + child.nodeValue;
				else
					xhtmlString = child.nodeValue ;
			}
			child = child.nextSibling;
		}
    }
    return xhtmlString;
}

String.prototype.ReplaceAll = function(stringToFind, stringToReplace)
{
	var temp = this;
	var index = temp.indexOf(stringToFind);
	while (index != -1)
	{
		temp = temp.replace(stringToFind,stringToReplace);
		index = temp.indexOf(stringToFind);
	}
	return temp;
}



AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("blue", function(e, macroNode) {
    updateMacro(macroNode, "blue");
});


AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("red", function(e, macroNode) {
    updateMacro(macroNode, "red");
});

AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("green", function(e, macroNode) {
    updateMacro(macroNode, "green");
});

AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("orange", function(e, macroNode) {
    updateMacro(macroNode, "orange");
});

AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("yellow", function(e, macroNode) {
    updateMacro(macroNode, "yellow");
});

AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("gray", function(e, macroNode) {
    updateMacro(macroNode, "gray");
});

AJS.Confluence.PropertyPanel.Macro.registerButtonHandler("purple", function(e, macroNode) {
    updateMacro(macroNode, "purple");
});
});
