/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="/")
public class HinchPanelsConfigResource {
    private final UserManager userManager;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final TransactionTemplate transactionTemplate;

    public HinchPanelsConfigResource(UserManager userManager, PluginSettingsFactory pluginSettingsFactory, TransactionTemplate transactionTemplate) {
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json"})
    public Response get(@Context HttpServletRequest httpServletRequest) {
        String string = this.userManager.getRemoteUsername(httpServletRequest);
        if (string != null && !this.userManager.isSystemAdmin(string)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        return Response.ok((Object)this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = HinchPanelsConfigResource.this.pluginSettingsFactory.createGlobalSettings();
                Config config = new Config();
                config.setName((String)pluginSettings.get(Config.class.getName() + ".name"));
                config.setType((String)pluginSettings.get(Config.class.getName() + ".type"));
                config.setKey((String)pluginSettings.get(Config.class.getName() + ".key"));
                String string = (String)pluginSettings.get(Config.class.getName() + ".count");
                if (string != null) {
                    config.setCount(Integer.parseInt(string));
                }
                return config;
            }
        })).build();
    }

    @PUT
    @ReadOnlyAccessBlocked
    @Consumes(value={"application/json"})
    public Response put(final Config config, @Context HttpServletRequest httpServletRequest) {
        String string = this.userManager.getRemoteUsername(httpServletRequest);
        if (string != null && !this.userManager.isSystemAdmin(string)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                PluginSettings pluginSettings = HinchPanelsConfigResource.this.pluginSettingsFactory.createGlobalSettings();
                pluginSettings.put(Config.class.getName() + ".name", (Object)config.getName());
                pluginSettings.put(Config.class.getName() + ".type", (Object)config.getType());
                pluginSettings.put(Config.class.getName() + ".key", (Object)config.getKey());
                pluginSettings.put(Config.class.getName() + ".count", (Object)Integer.toString(config.getCount()));
                return null;
            }
        });
        return Response.noContent().build();
    }

    @XmlRootElement
    public static final class Config {
        @XmlElement
        private String name;
        @XmlElement
        private String type;
        @XmlElement
        private String key;
        @XmlElement
        private int count;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setType(String string) {
            this.type = string;
        }

        public String getType() {
            return this.type;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public String getKey() {
            return this.key;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int n) {
            this.count = n;
        }
    }
}

