/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HinchPanelsAdminServlet
extends HttpServlet {
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer templateRenderer;

    public HinchPanelsAdminServlet(UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer templateRenderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.templateRenderer = templateRenderer;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = this.userManager.getRemoteUsername(httpServletRequest);
        if (string == null || !this.userManager.isSystemAdmin(string)) {
            this.redirectToLogin(httpServletRequest, httpServletResponse);
            return;
        }
        httpServletResponse.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("admin.vm", (Writer)httpServletResponse.getWriter());
    }

    private void redirectToLogin(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(httpServletRequest)).toString());
    }

    private URI getUri(HttpServletRequest httpServletRequest) {
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        if (httpServletRequest.getQueryString() != null) {
            stringBuffer.append("?");
            stringBuffer.append(httpServletRequest.getQueryString());
        }
        return URI.create(stringBuffer.toString());
    }
}

