/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.components.HtmlEscaper;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.log4j.Logger;

public class HinchMacro
extends BaseMacro
implements Macro {
    private final PageBuilderService pageBuilderService;
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final String COLOR_PARAM_NAME = "color";
    private static final String MIN_HEIGHT_PARAM_NAME = "height";
    private static final String WIDTH_PARAM_NAME = "width";
    private static final String TITLE_PARAM_NAME = "title";
    private static final String NO_BODY_IMG_PARAM_NAME = "no_body_img";
    private static final Logger logger = Logger.getLogger(HinchMacro.class);
    private static final Set<String> VALID_COLORS = new HashSet<String>(Arrays.asList("black", "blue", "gray", "green", "orange", "purple", "red", "yellow"));

    private HinchMacro(PageBuilderService pageBuilderService, PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pageBuilderService = pageBuilderService;
    }

    private boolean hasValidLicense() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String string = (String)pluginSettings.get("com.akelesconsulting.confluence.plugins.HinchPanelsConfigResource$Config.key");
        logger.debug((Object)("key = [" + string + "]"));
        return string != null && string.equalsIgnoreCase("419aa355d57ed1ab72cdb15f4cfa9d9988");
    }

    public boolean hasBody() {
        return true;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.INLINE;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map map, String string, RenderContext renderContext) throws MacroException {
        try {
            return this.execute((Map<String, String>)map, string, (ConversionContext)null);
        }
        catch (MacroExecutionException macroExecutionException) {
            throw new MacroException((Throwable)macroExecutionException);
        }
    }

    public String execute(Map<String, String> map, String string, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.hasValidLicense()) {
            return "<p>A license key is required for this plugin to work. You can register it <a href=\"https://akeles.jira.com/servicedesk/customer/portal/2/create/7/\">here</a></p>";
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.akelesconsulting.confluence.plugins.HinchPanels:css");
        this.pageBuilderService.assembler().resources().requireWebResource("com.akelesconsulting.confluence.plugins.HinchPanels:hinch-macro-resources");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.validateColor(map.get(COLOR_PARAM_NAME));
        String string3 = map.get(MIN_HEIGHT_PARAM_NAME);
        String string4 = map.get(WIDTH_PARAM_NAME);
        String string5 = map.get(TITLE_PARAM_NAME);
        String string6 = map.get(NO_BODY_IMG_PARAM_NAME);
        int n = 0;
        int n2 = 100;
        if (string3 != null) {
            try {
                n = NumberUtils.max((int[])new int[]{NumberUtils.toInt((String)string3, (int)0), 0});
                if (string5 != null && n > 34) {
                    n -= 34;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        if (string4 != null) {
            try {
                n2 = NumberUtils.min((int[])new int[]{NumberUtils.max((int[])new int[]{NumberUtils.toInt((String)string4, (int)100), 0}), 100});
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 0;
            }
        }
        if (string5 == null) {
            if (string6 == null) {
                stringBuilder.append("<div class=\"hinch_panel_plain ").append(string2).append("\" style=\"min-height:").append(n).append("px;max-width:").append(n2).append("%;\">");
            } else {
                stringBuilder.append("<div class=\"hinch_panel_plain_nobody ").append(string2).append("\" style=\"min-height:").append(n).append("px;max-width:").append(n2).append("%;\">");
            }
            stringBuilder.append(string);
            stringBuilder.append("</div>");
        } else {
            string5 = HtmlEscaper.escapeAll((String)string5, (boolean)true);
            if (string2 == null) {
                string2 = "";
            }
            stringBuilder.append("<div class=\"hinch_panel_title ").append(string2).append("\" style=\"max-width:").append(n2).append("%;\">").append(string5).append("</div>");
            if (string6 == null) {
                stringBuilder.append("<div class=\"hinch_panel_body ").append(string2).append("\" style=\"min-height:").append(n).append("px;max-width:").append(n2).append("%;\">");
            } else {
                stringBuilder.append("<div class=\"hinch_panel_nobody ").append(string2).append("\" style=\"min-height:").append(n).append("px;max-width:").append(n2).append("%;\">");
            }
            stringBuilder.append(string);
            stringBuilder.append("</div>");
        }
        return stringBuilder.toString();
    }

    private String validateColor(String string) {
        String string2 = HtmlEscaper.escapeAll((String)string, (boolean)true);
        if (VALID_COLORS.contains(string2)) {
            return string2;
        }
        return "black";
    }
}

