/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LicenseHelper {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.utils.LicenseHelper");
    private final GlobalSettingsManager b;
    private final PluginLicenseManager c;

    @Autowired
    public LicenseHelper(@ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport PluginLicenseManager pluginLicenseManager) {
        this.b = globalSettingsManager;
        this.c = pluginLicenseManager;
    }

    public boolean a() {
        boolean bl = false;
        if (this.c.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.c.getLicense().get();
            bl = pluginLicense.isEvaluation();
        }
        a.debug("Is evaluation license? [" + bl + "]");
        return bl;
    }

    public boolean b() {
        boolean bl = false;
        String string = this.b.getGlobalSettings().getBaseUrl();
        if (string != null && string.contains("akeles")) {
            bl = true;
        } else {
            Option option = this.c.getLicense();
            if (option.isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)option.get();
                boolean bl2 = bl = !pluginLicense.getError().isDefined();
                if (bl && pluginLicense.isEvaluation()) {
                    ZonedDateTime zonedDateTime = pluginLicense.getCreationZonedDate();
                    a.debug("Evaluation license creation date [" + String.valueOf(zonedDateTime) + "]");
                    Optional optional = pluginLicense.getExpiryZonedDate();
                    if (optional.isPresent()) {
                        ZonedDateTime zonedDateTime2 = (ZonedDateTime)optional.get();
                        a.debug("Evaluation license expiry date [" + String.valueOf(zonedDateTime2) + "]");
                        long l = ChronoUnit.DAYS.between(zonedDateTime.toLocalDate(), zonedDateTime2.toLocalDate()) + 1L;
                        a.debug("Evaluation license duration is [" + l + "] days");
                        bl = l <= 31L;
                    } else {
                        a.debug("Evaluation license expiry date is empty");
                        bl = false;
                    }
                }
            }
        }
        a.debug("Is license valid? [" + bl + "]");
        return bl;
    }
}

