/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentHelper {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.utils.AttachmentHelper");
    private final AttachmentManager b;
    private final BootstrapManager c;
    private final ClusterManager d;
    private final PageManager e;
    private final SpaceManager f;
    private final TransactionTemplate g;
    private final UserAccessor h;

    public AttachmentHelper(@ComponentImport AttachmentManager attachmentManager, @ComponentImport BootstrapManager bootstrapManager, @ComponentImport ClusterManager clusterManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport UserAccessor userAccessor) {
        this.b = attachmentManager;
        this.c = bootstrapManager;
        this.d = clusterManager;
        this.e = pageManager;
        this.f = spaceManager;
        this.g = transactionTemplate;
        this.h = userAccessor;
    }

    public Attachment a(long l, int n, Date date) {
        a.debug("Get attachment id [" + l + "] version [" + n + "] creation date [" + String.valueOf(date) + "]");
        Attachment attachment = this.b.getAttachment(l);
        if (attachment == null) {
            a.debug("Attachment is null");
            return null;
        }
        Date date2 = DateHelper.a(attachment.getCreationDate());
        a.debug("Retrieved attachment version [" + attachment.getVersion() + "]");
        a.debug("Retrieved attachment creation date [" + String.valueOf(date2) + "]");
        boolean bl = attachment.getVersion() != n;
        boolean bl2 = date2 != null && date != null && date2.getTime() != date.getTime();
        a.debug("Is version diff? [" + bl + "]");
        a.debug("Is creation date diff? [" + bl2 + "]");
        if (bl || bl2) {
            a.debug("Checking all versions");
            List list = this.b.getAllVersions(attachment);
            attachment = null;
            for (Attachment attachment2 : list) {
                int n2 = attachment2.getVersion();
                Date date3 = DateHelper.a(attachment2.getCreationDate());
                a.debug("Current version [" + n2 + "]");
                a.debug("Current creation date [" + String.valueOf(date3) + "]");
                if (n2 != n || date != null && (date3 == null || date3.getTime() != date.getTime())) continue;
                a.debug("Found attachment!");
                attachment = attachment2;
                break;
            }
        }
        a.debug("Attachment [" + String.valueOf(attachment) + "]");
        return attachment;
    }

    public void b(long l, int n, Date date) {
        a.debug("Delete attachment id [" + l + "]");
        this.g.execute(() -> {
            Attachment attachment = this.a(l, n, date);
            if (attachment != null) {
                try {
                    this.b.removeAttachmentVersionFromServer(attachment);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    a.debug("IllegalArgumentException deleting attachment", (Throwable)illegalArgumentException);
                }
            }
            return null;
        });
    }

    public String a(@NotNull Attachment attachment, long l, int n, long l2) {
        String string;
        long l3 = attachment.getSpace().getId();
        String string2 = (String)this.c.getApplicationConfig().getProperty((Object)"attachments.dir");
        string2 = string2.replace("${confluenceHome}", this.d.isClustered() ? this.c.getSharedHome().getPath() : this.c.getLocalHome().getPath());
        boolean bl = new File(string2 + File.separator + "v4").exists();
        a.debug("Is attachment storage v4? [" + bl + "]");
        if (bl) {
            long l4 = l % 65535L;
            string = string2 + File.separator + "v4" + File.separator + l4 % 256L + File.separator + l4 / 256L + File.separator + l + File.separator + l + "." + n;
        } else {
            string = string2 + File.separator + "ver003" + File.separator + l3 % 250L + File.separator + l3 / 1000L % 250L + File.separator + l3 + File.separator + l2 % 250L + File.separator + l2 / 1000L % 250L + File.separator + l2 + File.separator + l + File.separator + n;
        }
        return string;
    }

    public boolean a(boolean bl, long l, int n, Date date) {
        boolean bl2 = false;
        if (bl) {
            try {
                bl2 = (Boolean)this.g.execute(() -> this.c(l, n, date));
            }
            catch (Exception exception) {
                a.error("Error with addPlaceholderAndDeleteAttachmentVersion transaction", (Throwable)exception);
            }
        }
        return bl2;
    }

    public boolean c(long l, int n, Date date) {
        boolean bl = false;
        try {
            Attachment attachment = this.a(l, n, date);
            if (attachment != null) {
                Attachment attachment2 = this.b.getAttachment(l);
                Attachment attachment3 = attachment2.copy();
                ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
                AuthenticatedUserThreadLocal.set((ConfluenceUser)attachment.getCreator());
                a.debug("Saving placeholder... ");
                attachment2.setFileSize(136628L);
                attachment2.setMediaType("image/png");
                attachment2.setVersionComment("This is a placeholder to replace the infected file");
                InputStream inputStream = this.getClass().getResourceAsStream("/images/imageplaceholder.png");
                this.b.saveAttachment(attachment2, attachment3, inputStream);
                a.debug("Placeholder saved!");
                a.debug("Removing attachment version [" + n + "]");
                this.b.removeAttachmentVersionFromServer(this.a(l, n, date));
                a.debug("Attachment version removed!");
                AuthenticatedUserThreadLocal.set((ConfluenceUser)confluenceUser);
                bl = true;
            }
        }
        catch (Exception exception) {
            a.error("Error adding placeholder version and deleting old version", (Throwable)exception);
        }
        return bl;
    }

    @NotNull
    public SpaceBean a(String string, Space space, String string2, String string3) {
        SpaceBean spaceBean = new SpaceBean(string);
        if (space == null) {
            space = this.f.getSpace(string);
        }
        if (space != null) {
            spaceBean.setName(space.getName());
            spaceBean.setUrl(string3 + space.getUrlPath());
        } else {
            spaceBean.setName(string2);
        }
        return spaceBean;
    }

    @NotNull
    public PageBean a(long l, ContentEntityObject contentEntityObject, String string, String string2) {
        PageBean pageBean = new PageBean();
        if (contentEntityObject == null) {
            contentEntityObject = this.e.getPage(l);
        }
        if (contentEntityObject != null) {
            pageBean.setTitle(contentEntityObject.getTitle());
            pageBean.setUrl(string2 + contentEntityObject.getAttachmentsUrlPath());
        } else {
            pageBean.setTitle(string);
        }
        return pageBean;
    }

    @NotNull
    public UserBean a(String string, String string2, String string3, String string4) {
        UserBean userBean = new UserBean(string);
        ConfluenceUser confluenceUser = this.h.getExistingUserByKey(new UserKey(string));
        if (confluenceUser != null) {
            userBean.setDisplayName(confluenceUser.getFullName());
            userBean.setUsername(confluenceUser.getName());
            userBean.setUrl(string4 + "/display/~" + confluenceUser.getName());
        } else {
            userBean.setDisplayName(string3);
            userBean.setUsername(string2);
        }
        return userBean;
    }
}

