/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.VirusScanError;
import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.ao.service.VirusScanErrorService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.rest.beans.VirusScanErrorBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/report/virus-scan")
public class VirusScanErrorResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.VirusScanErrorResource");
    private static final int b = 50;
    private final AssignedNodeService c;
    private final AttachmentHelper d;
    private final DateHelper e;
    private final GlobalSettingsManager f;
    private final Gson g;
    private final I18nResolver h;
    private final PermissionManager i;
    private final VirusScanErrorService j;

    @Inject
    public VirusScanErrorResource(AssignedNodeService assignedNodeService, AttachmentHelper attachmentHelper, DateHelper dateHelper, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, VirusScanErrorService virusScanErrorService) {
        this.c = assignedNodeService;
        this.d = attachmentHelper;
        this.e = dateHelper;
        this.f = globalSettingsManager;
        this.g = new Gson();
        this.h = i18nResolver;
        this.i = permissionManager;
        this.j = virusScanErrorService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") @DefaultValue(value="0") int n) {
        a.debug("Get list of VirusScanError, start index [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to perform this action");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        List<VirusScanError> list = this.j.a(n, 50);
        List<VirusScanErrorBean> list2 = this.a(list);
        int n2 = this.j.getVirusScanErrorCount();
        resultBean.setPagination(n, n2);
        resultBean.addVirusScanErrorBeanList(list2);
        a.debug(resultBean.toString());
        return Response.ok((Object)this.g.toJson((Object)resultBean)).build();
    }

    @GET
    @Path(value="/error")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="nodeId") String string) {
        a.debug("Get related scans for node ID [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to perform this action");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<Object> list = new ArrayList();
        List<Integer> list2 = this.c.c(string);
        if (list2 != null && !list2.isEmpty()) {
            List<VirusScanError> list3 = this.j.a(list2);
            list = this.a(list3);
        }
        a.debug("Error count [" + list.size() + "]");
        return Response.ok((Object)this.g.toJson(list)).build();
    }

    @NotNull
    private List<VirusScanErrorBean> a(@NotNull List<VirusScanError> list) {
        HashMap<String, SpaceBean> hashMap = new HashMap<String, SpaceBean>();
        HashMap<Long, PageBean> hashMap2 = new HashMap<Long, PageBean>();
        HashMap<String, UserBean> hashMap3 = new HashMap<String, UserBean>();
        String string = this.f.getGlobalSettings().getBaseUrl();
        ArrayList<VirusScanErrorBean> arrayList = new ArrayList<VirusScanErrorBean>();
        for (VirusScanError virusScanError : list) {
            long l2 = virusScanError.getAttachmentId();
            a.debug("Attachment id [" + l2 + "]");
            String string3 = this.e.a(virusScanError.getExecDate(), this.h.getText("com.akeles.acc.unknown"));
            VirusScanErrorBean virusScanErrorBean = new VirusScanErrorBean(virusScanError.getID(), virusScanError.getNodeId(), virusScanError.getExitCode(), virusScanError.getIsInfection(), virusScanError.getOutput(), string3);
            int n = virusScanError.getVersion();
            Date date = virusScanError.getCreationDate();
            String string4 = virusScanError.getFileName();
            String string5 = AttachmentCheckerHelper.a(virusScanError.getFileSize(), 2);
            Space space = null;
            String string6 = null;
            ContentEntityObject contentEntityObject = null;
            Attachment attachment = this.d.a(l2, n, date);
            AttachmentBean attachmentBean = new AttachmentBean(l2, this.e.a(date, this.h.getText("com.akeles.acc.unknown")), n, string4, string5, "");
            long l3 = virusScanError.getAttachedToId();
            if (attachment != null) {
                string6 = attachment.getSpaceKey();
                space = attachment.getSpace();
                contentEntityObject = attachment.getContainer();
                attachmentBean.setFileLocation(this.d.a(attachment, l2, n, l3));
                attachmentBean.setIsInTrash(attachment.isDeleted());
            } else {
                attachmentBean.setIsDeleted(true);
            }
            Space space2 = space;
            SpaceBean spaceBean = hashMap.computeIfAbsent(string6, string2 -> this.d.a((String)string2, space2, "", string));
            hashMap.put(string6, spaceBean);
            attachmentBean.setSpace(spaceBean);
            ContentEntityObject contentEntityObject2 = contentEntityObject;
            PageBean pageBean = hashMap2.computeIfAbsent(l3, l -> this.d.a((long)l, contentEntityObject2, "", string));
            hashMap2.put(l3, pageBean);
            attachmentBean.setPage(pageBean);
            String string7 = virusScanError.getUserKey() == null ? "" : virusScanError.getUserKey();
            UserBean userBean = hashMap3.computeIfAbsent(string7, string2 -> this.d.a((String)string2, "", "", string));
            hashMap3.put(string7, userBean);
            attachmentBean.setCreator(userBean);
            virusScanErrorBean.setAttachment(attachmentBean);
            a.debug("VirusScanError ID [" + virusScanErrorBean.getId() + "] exit code [" + virusScanErrorBean.getExitCode() + "] exec date [" + virusScanErrorBean.getExecDate() + "]");
            arrayList.add(virusScanErrorBean);
        }
        return arrayList;
    }
}

