/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.LargeAttachment;
import com.akelesconsulting.confluence.plugins.ao.service.LargeAttachmentService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.LargeAttachmentTrackerConfigBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/large-attachment")
public class LargeAttachmentTrackerResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.LargeAttachmentTrackerResource");
    private static final int b = 50;
    private final AttachmentCheckerConfig c;
    private final AttachmentHelper d;
    private final DateHelper e;
    private final GlobalSettingsManager f;
    private final Gson g;
    private final I18nResolver h;
    private final LargeAttachmentService i;
    private final PermissionManager j;

    @Inject
    public LargeAttachmentTrackerResource(AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, DateHelper dateHelper, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport I18nResolver i18nResolver, LargeAttachmentService largeAttachmentService, PermissionManager permissionManager) {
        this.c = attachmentCheckerConfig;
        this.d = attachmentHelper;
        this.e = dateHelper;
        this.f = globalSettingsManager;
        this.g = new Gson();
        this.h = i18nResolver;
        this.i = largeAttachmentService;
        this.j = permissionManager;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug("Get list of LargeAttachment, start index [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get large attachment list");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        HashMap<String, SpaceBean> hashMap = new HashMap<String, SpaceBean>();
        HashMap<Long, PageBean> hashMap2 = new HashMap<Long, PageBean>();
        HashMap<String, UserBean> hashMap3 = new HashMap<String, UserBean>();
        ResultBean resultBean = new ResultBean(50);
        List<LargeAttachment> list = this.i.a(n, 50);
        String string = this.f.getGlobalSettings().getBaseUrl();
        for (LargeAttachment largeAttachment : list) {
            int n2;
            Date date = largeAttachment.getCreationDate();
            String string2 = largeAttachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(largeAttachment.getFileSize(), "MB", 2);
            AttachmentBean attachmentBean = new AttachmentBean(largeAttachment.getID(), this.e.a(date, this.h.getText("com.akeles.acc.unknown")), largeAttachment.getVersion(), string2, string3, "");
            Space space = null;
            String string4 = largeAttachment.getSpaceKey();
            ContentEntityObject contentEntityObject = null;
            long l = largeAttachment.getContentId();
            long l2 = largeAttachment.getAttachmentId();
            Attachment attachment = this.d.a(l2, n2 = largeAttachment.getVersion(), date);
            if (attachment != null) {
                string4 = attachment.getSpaceKey();
                space = attachment.getSpace();
                contentEntityObject = attachment.getContainer();
                attachmentBean.setIsInTrash(attachment.isDeleted());
            } else {
                attachmentBean.setIsDeleted(true);
            }
            SpaceBean spaceBean = (SpaceBean)hashMap.get(string4);
            if (spaceBean == null) {
                spaceBean = this.d.a(string4, space, largeAttachment.getSpaceName(), string);
                hashMap.put(string4, spaceBean);
            }
            attachmentBean.setSpace(spaceBean);
            PageBean pageBean = (PageBean)hashMap2.get(l);
            if (pageBean == null) {
                pageBean = this.d.a(l, contentEntityObject, largeAttachment.getPageTitle(), string);
                hashMap2.put(l, pageBean);
            }
            attachmentBean.setPage(pageBean);
            String string5 = largeAttachment.getUserKey();
            UserBean userBean = (UserBean)hashMap3.get(string5);
            if (userBean == null) {
                userBean = this.d.a(string5, largeAttachment.getUsername(), largeAttachment.getUserDisplayName(), string);
                hashMap3.put(string5, userBean);
            }
            attachmentBean.setCreator(userBean);
            a.debug(attachmentBean.toString());
            resultBean.addAttachment(attachmentBean);
        }
        int n3 = this.i.getLargeAttachmentTotalCount();
        resultBean.setPagination(n, n3);
        a.debug(resultBean.toString());
        return Response.ok((Object)this.g.toJson((Object)resultBean)).build();
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        a.debug("Get large attachment tracker config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get large attachment tracker config");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.v();
        long l = this.c.getLargeAttachmentSize();
        String string = AttachmentCheckerHelper.a(l, "MB", 2);
        LargeAttachmentTrackerConfigBean largeAttachmentTrackerConfigBean = new LargeAttachmentTrackerConfigBean(bl, string);
        a.debug("Track large attachment? [" + bl + "]");
        a.debug("Large attachment size (MB) [" + string + "]");
        return Response.ok((Object)this.g.toJson((Object)largeAttachmentTrackerConfigBean)).build();
    }

    @POST
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="track") String string, @QueryParam(value="size") String string2) {
        a.debug("Update large attachment tracker config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to update large attachment tracker config");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        LargeAttachmentTrackerConfigBean largeAttachmentTrackerConfigBean = new LargeAttachmentTrackerConfigBean();
        if (string2 != null) {
            string2 = AttachmentCheckerHelper.c(string2);
            String string3 = AttachmentCheckerHelper.a(string2, "MB");
            a.debug("Large attachment size (bytes) [" + string3 + "]");
            this.c.setLargeAttachmentSize(string3);
            string2 = AttachmentCheckerHelper.a(this.c.getLargeAttachmentSize(), "MB", 2);
            largeAttachmentTrackerConfigBean.setSize(string2);
        } else {
            if (string == null) {
                string = "off";
            }
            a.debug("Track large attachment [" + string + "]");
            this.c.setTrackLargeAttachment(string);
            largeAttachmentTrackerConfigBean.setTrackLargeAttachment(this.c.v());
        }
        return Response.ok((Object)this.g.toJson((Object)largeAttachmentTrackerConfigBean)).build();
    }
}

