/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.FileTypeViolationService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledJobBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledTimeBean;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeViolationHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/file-type-violation")
public class FileTypeViolationReportResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.FileTypeViolationReportResource");
    private static final int b = 50;
    private final AttachmentCheckerConfig c;
    private final DateHelper d;
    private final GlobalSettingsManager e;
    private final Gson f;
    private final I18nResolver g;
    private final JobScheduler h;
    private final LicenseHelper i;
    private final PermissionManager j;
    private final FileTypeViolationHelper k;
    private final FileTypeViolationService l;
    private final SpaceManager m;
    private final SpaceScannedService n;

    @Inject
    public FileTypeViolationReportResource(AttachmentCheckerConfig attachmentCheckerConfig, DateHelper dateHelper, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport I18nResolver i18nResolver, JobScheduler jobScheduler, LicenseHelper licenseHelper, @ComponentImport PermissionManager permissionManager, FileTypeViolationHelper fileTypeViolationHelper, FileTypeViolationService fileTypeViolationService, @ComponentImport SpaceManager spaceManager, SpaceScannedService spaceScannedService) {
        this.c = attachmentCheckerConfig;
        this.d = dateHelper;
        this.e = globalSettingsManager;
        this.f = new Gson();
        this.g = i18nResolver;
        this.h = jobScheduler;
        this.i = licenseHelper;
        this.j = permissionManager;
        this.k = fileTypeViolationHelper;
        this.l = fileTypeViolationService;
        this.m = spaceManager;
        this.n = spaceScannedService;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        boolean bl;
        a.debug("Get file type violation scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get file type violation scanner config");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ScheduledJobBean scheduledJobBean = new ScheduledJobBean();
        String string = this.c.getViolationScannerStartHour();
        String string2 = this.c.getViolationScannerStartMinute();
        String string3 = this.c.getViolationScannerStartAmPm();
        String string4 = this.c.getViolationScannerEndHour();
        String string5 = this.c.getViolationScannerEndMinute();
        String string6 = this.c.getViolationScannerEndAmPm();
        boolean bl2 = bl = !StringUtils.isEmpty((CharSequence)string);
        if (bl) {
            scheduledJobBean.setStartTime(string, string2, string3);
            scheduledJobBean.setEndTime(string4, string5, string6);
        }
        String string7 = this.d.a(string, string2, string3, string4, string5, string6, this.g.getText("com.akeles.acc.untilAllSpacesAreScanned"));
        scheduledJobBean.setScheduledTime(string7);
        int n = this.n.a("violation");
        int n2 = this.m.getSpaces(SpacesQuery.newQuery().build()).getAvailableSize();
        String string8 = this.g.getText("com.akeles.acc.scanStatus.spaceCount", new Serializable[]{Integer.valueOf(n), Integer.valueOf(n2)});
        scheduledJobBean.setStatus(string8, n, n2);
        boolean bl3 = this.c.y();
        boolean bl4 = this.c.z();
        a.debug("Is violation scan completed? [" + bl4 + "]");
        Long l = this.c.getViolationScannerLastRun();
        String string9 = this.d.a(l, this.g.getText("com.akeles.acc.date.never"));
        String string10 = "-";
        boolean bl5 = this.i.a();
        scheduledJobBean.setIsEvaluationLicense(bl5);
        if (bl3) {
            a.debug("Violation scanner is running!");
            string10 = this.g.getText("com.akeles.acc.scanning");
        } else if (bl5 && this.l.getViolatedAttachmentTotalCount() > 0) {
            a.debug("Eval license detected! Purchase to continue scanning!");
            string10 = this.g.getText("com.akeles.acc.fileTypeViolationReport.purchaseLicenseToScan");
            scheduledJobBean.setIsEvaluationMessage(true);
        } else if (!bl4 && bl) {
            string10 = this.d.a(DateHelper.a(string, string2, string3), "");
            a.debug("Violation scanner is scheduled to run at [" + string10 + "]");
        }
        scheduledJobBean.setLastRunDetails(string9, "", "");
        scheduledJobBean.setNextRunDetails(string10, "");
        scheduledJobBean.setJobStatus(bl, bl3);
        a.debug(scheduledJobBean.toString());
        return Response.ok((Object)this.f.toJson((Object)scheduledJobBean)).build();
    }

    @POST
    @Path(value="/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response a(ScheduledJobBean scheduledJobBean) {
        a.debug("Update file type violation scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to update file type violation scanner config");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.y();
        if (bl) {
            a.debug("File type violation scanner is running, config is not updated!");
        } else {
            ScheduledTimeBean scheduledTimeBean = scheduledJobBean.getStartTime();
            ScheduledTimeBean scheduledTimeBean2 = scheduledJobBean.getEndTime();
            this.c.c(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm(), scheduledTimeBean2.getHour(), scheduledTimeBean2.getMinute(), scheduledTimeBean2.getAmPm());
            this.h.c(DateHelper.a(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm()));
        }
        return this.getConfig();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug("Get list of ViolatedAttachment, start index [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get violated attachment list");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        String string = this.e.getGlobalSettings().getBaseUrl();
        resultBean.addAttachments(this.k.a(n, 50, string));
        int n2 = this.l.getViolatedAttachmentTotalCount();
        resultBean.setPagination(n, n2);
        resultBean.setIsEvaluationLicense(this.i.a());
        a.debug(resultBean.toString());
        return Response.ok((Object)this.f.toJson((Object)resultBean)).build();
    }

    @POST
    @Path(value="/rescan")
    @Produces(value={"application/json"})
    public Response a() {
        a.debug("Trigger rescan for file type violation");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.j.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to trigger rescan for file type violation");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.y();
        if (bl) {
            a.debug("File type violation scanner is running, rescan is not triggered!");
        } else {
            this.l.a();
            this.n.c("violation");
            this.c.setIsViolationScanCompleted(false);
        }
        return this.getConfig();
    }
}

