/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentLogs;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentLogsService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceFilterModeService;
import com.akelesconsulting.confluence.plugins.ao.service.SpacePermissionService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.ExtensionBean;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/config")
public class AttachmentCheckerConfigRestResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentCheckerConfigRestResource");
    private final AttachmentCheckerConfig b;
    private final Gson c;
    private final PermissionManager d;
    private final SpaceFilterModeService e;
    private final SpacePermissionService f;
    private final AttachmentLogsService g;
    private final SpacePermissionManager h;
    private final PageManager i;
    private final SpaceManager j;

    @Inject
    public AttachmentCheckerConfigRestResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport PermissionManager permissionManager, SpacePermissionService spacePermissionService, SpaceFilterModeService spaceFilterModeService, AttachmentLogsService attachmentLogsService, PageManager pageManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport SpaceManager spaceManager) {
        this.b = attachmentCheckerConfig;
        this.c = new Gson();
        this.d = permissionManager;
        this.f = spacePermissionService;
        this.e = spaceFilterModeService;
        this.g = attachmentLogsService;
        this.i = pageManager;
        this.h = spacePermissionManager;
        this.j = spaceManager;
    }

    @GET
    @Path(value="/extension")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="extension") String string) {
        a.debug("Get extensions associated with [" + string + "]");
        ExtensionBean extensionBean = new ExtensionBean(string, this.b.d(string));
        return Response.ok((Object)this.c.toJson((Object)extensionBean)).build();
    }

    @GET
    @Path(value="/extensions")
    @Produces(value={"application/json"})
    public Response getExtensions() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug("Get extensions with user [" + String.valueOf(confluenceUser) + "]");
        if (!this.d.isConfluenceAdministrator(confluenceUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You do not have permission to view this.").build();
        }
        List<ExtensionBean> list = this.b.c(this.b.getExtensions());
        a.debug("Extensions count [" + list.size() + "]");
        return Response.ok((Object)this.c.toJson(list)).build();
    }

    @GET
    @Path(value="/scanner")
    @Produces(value={"text/plain"})
    public Response getScannerDetected() {
        String string = this.b.getScannerDetected();
        a.debug("Scanner detected [" + string + "]");
        return Response.ok((Object)string).build();
    }

    @GET
    @Path(value="/attachmentLogs/{spaceKey}")
    public Response b(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.j.getSpace(string);
        if (this.d.isConfluenceAdministrator(confluenceUser) || this.h.hasPermission("SETSPACEPERMISSIONS", space, confluenceUser)) {
            JSONArray jSONArray = new JSONArray();
            AttachmentLogs[] attachmentLogsArray = this.g.a(string);
            try {
                for (AttachmentLogs attachmentLogs : attachmentLogsArray) {
                    JSONObject jSONObject = new JSONObject();
                    String string2 = "Page not found";
                    Page page = this.i.getPage(Long.parseLong(attachmentLogs.getPageId()));
                    if (page != null) {
                        string2 = page.getTitle();
                    }
                    jSONObject.put("Page", (Object)string2);
                    jSONObject.put("Attachment", (Object)attachmentLogs.getAttachmentId());
                    jSONObject.put("User", (Object)this.f.b(attachmentLogs.getUserKey()));
                    jSONObject.put("Date Time", (Object)attachmentLogs.getDownloadTime());
                    jSONArray.put((Object)jSONObject);
                }
            }
            catch (JSONException jSONException) {
                a.error("JSON Error", (Throwable)jSONException);
            }
            return Response.ok((Object)jSONArray.toString()).build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to view this").build();
    }

    @POST
    @Path(value="/attachmentLogs/purge/{spaceKey}")
    public Response c(@PathParam(value="spaceKey") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        Space space = this.j.getSpace(string);
        if (this.d.isConfluenceAdministrator(confluenceUser) || this.h.hasPermission("SETSPACEPERMISSIONS", space, confluenceUser)) {
            this.g.b(string);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"You are not authorised to perform this action").build();
    }

    @GET
    @Path(value="/isValid/{spaceKey}")
    @Produces(value={"application/json"})
    public Response d(@PathParam(value="spaceKey") String string) {
        boolean bl = true;
        JSONObject jSONObject = new JSONObject();
        try {
            String string2 = this.e.a(string);
            if (string2.equals("denylist") && this.f.c(string) || string2.equals("allowlist") && !this.f.c(string)) {
                bl = false;
            }
            jSONObject.put("isValid", bl);
            a.debug("User has permission [" + bl + "]");
        }
        catch (JSONException jSONException) {
            a.error("Error putting values to JSON Object", (Throwable)jSONException);
        }
        return Response.ok((Object)jSONObject.toString()).build();
    }
}

