/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.actions;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTypeAdminHelper
extends ConfluenceActionSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.actions.FileTypeAdminHelper");
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient LicenseHelper licenseHelper;
    private String fileName;
    private String extension;
    private String mimeType;
    private List<String> associatedExtensionList;
    private boolean isExtensionValid;
    private boolean isMimeTypeValid;

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public List<String> getAssociatedExtensionList() {
        return this.associatedExtensionList;
    }

    public boolean getIsExtensionValid() {
        return this.isExtensionValid;
    }

    public boolean getIsMimeTypeValid() {
        return this.isMimeTypeValid;
    }

    public String execute() {
        ConfluenceUser confluenceUser = this.getAuthenticatedUser();
        logger.debug((String)(confluenceUser == null ? "Anonymous" : "User [" + confluenceUser.getName() + "]") + " accessing File Type Helper");
        if (this.licenseHelper.b()) {
            logger.debug("License is valid!");
            return "success";
        }
        logger.debug("License is invalid!");
        return "unlicensed";
    }

    public String detectFileType() {
        logger.debug("Detecting file type...");
        this.extension = null;
        this.mimeType = null;
        this.associatedExtensionList = new ArrayList<String>();
        try {
            List list = this.strutsHelper.getUploadedFiles(this.getActiveRequest(), true);
            if (list.isEmpty()) {
                logger.debug("No file selected");
                this.addFieldError("fileError", this.getText("com.akeles.acc.error.noFileSelected"));
            } else {
                UploadedFile uploadedFile = (UploadedFile)list.getFirst();
                this.fileName = uploadedFile.getFileName();
                logger.debug("File name [" + this.fileName + "]");
                this.extension = FileTypeHelper.d(this.fileName);
                this.extension = FileTypeHelper.e(this.extension);
                if (FileTypeHelper.c(this.fileName)) {
                    this.extension = ".7z";
                }
                File file = uploadedFile.getFile();
                this.mimeType = FileTypeHelper.a(this.fileName, Files.newInputStream(file.toPath(), new OpenOption[0]));
                this.associatedExtensionList = FileTypeHelper.b(this.mimeType);
                logger.debug("Associated extensions [" + String.join((CharSequence)", ", this.associatedExtensionList) + "]");
                this.isExtensionValid = this.attachmentCheckerConfig.a(this.extension, false);
                this.isMimeTypeValid = this.attachmentCheckerConfig.a(this.extension, this.mimeType, Files.newInputStream(file.toPath(), new OpenOption[0]), false);
            }
        }
        catch (FileUploadException fileUploadException) {
            logger.error("Error uploading file: " + fileUploadException.getMessage());
            this.addFieldError("fileError", fileUploadException.getMessage());
        }
        catch (IOException iOException) {
            logger.debug("Error detecting file type", (Throwable)iOException);
        }
        return "success";
    }
}

