/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.ao.entity.ViolatedAttachment;
import com.akelesconsulting.confluence.plugins.ao.service.FileTypeViolationService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FileTypeViolationHelper {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.utils.FileTypeViolationHelper");
    private final AttachmentHelper b;
    private final DateHelper c;
    private final FileTypeViolationService d;
    private final I18nResolver e;

    @Inject
    public FileTypeViolationHelper(AttachmentHelper attachmentHelper, DateHelper dateHelper, FileTypeViolationService fileTypeViolationService, I18nResolver i18nResolver) {
        this.b = attachmentHelper;
        this.c = dateHelper;
        this.d = fileTypeViolationService;
        this.e = i18nResolver;
    }

    public List<AttachmentBean> a(int n, int n2, String string) {
        a.debug("Get violated AttachmentBean list");
        ArrayList<AttachmentBean> arrayList = new ArrayList<AttachmentBean>();
        List<ViolatedAttachment> list = this.d.a(n, n2);
        for (ViolatedAttachment violatedAttachment : list) {
            a.debug("Attachment id [" + violatedAttachment.getAttachmentId() + "]");
            long l = violatedAttachment.getAttachmentId();
            int n3 = violatedAttachment.getVersion();
            Date date = violatedAttachment.getCreationDate();
            Attachment attachment = this.b.a(l, n3, date);
            if (attachment == null) {
                this.d.a(violatedAttachment);
                continue;
            }
            String string2 = attachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(attachment.getFileSize(), 2);
            ContentEntityObject contentEntityObject = attachment.getContainer();
            long l2 = contentEntityObject == null ? 0L : contentEntityObject.getId();
            String string4 = this.b.a(attachment, l, n3, l2);
            AttachmentBean attachmentBean = new AttachmentBean(violatedAttachment.getID(), this.c.a(date, this.e.getText("com.akeles.acc.unknown")), violatedAttachment.getVersion(), string2, string3, string4);
            attachmentBean.setIsInTrash(attachment.isDeleted());
            attachmentBean.setFileType(violatedAttachment.getExtension(), violatedAttachment.getMimeType());
            attachmentBean.setFileTypeViolation(violatedAttachment.getIsExtensionValid(), violatedAttachment.getIsMimeTypeValid());
            Space space = attachment.getSpace();
            SpaceBean spaceBean = new SpaceBean(attachment.getSpaceKey());
            if (space != null) {
                spaceBean.setName(space.getName());
                spaceBean.setUrl(string + space.getUrlPath());
            }
            attachmentBean.setSpace(spaceBean);
            ContentEntityObject contentEntityObject2 = attachment.getContainer();
            PageBean pageBean = new PageBean();
            if (contentEntityObject2 != null) {
                pageBean.setTitle(contentEntityObject2.getTitle());
                pageBean.setUrl(string + contentEntityObject2.getAttachmentsUrlPath());
            }
            attachmentBean.setPage(pageBean);
            ConfluenceUser confluenceUser = attachment.getCreator();
            UserBean userBean = new UserBean("");
            if (confluenceUser != null) {
                userBean = new UserBean(confluenceUser.getKey().getStringValue());
                userBean.setUsername(confluenceUser.getName());
                userBean.setDisplayName(confluenceUser.getFullName());
                userBean.setUrl(string + "/display/~" + confluenceUser.getName());
            }
            attachmentBean.setCreator(userBean);
            arrayList.add(attachmentBean);
        }
        return arrayList;
    }
}

