/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.notification.MailService;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningEmailJobRunner
implements JobRunner {
    private static final Logger e = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.scheduler.VirusScanningEmailJobRunner");
    public static final String a = "com.akeles.plugins.acc.scheduler.job.VirusScanningEmailJobRunner.lock";
    public static final JobRunnerKey b = JobRunnerKey.of((String)VirusScanningEmailJobRunner.class.getName());
    public static final JobId c = JobId.of((String)VirusScanningEmailJobRunner.class.getName());
    public static final String d = "0 0 9 * * ?";
    private final AssignedNodeService f;
    private final AttachmentCheckerConfig g;
    private final ClusterLockService h;
    private final ClusterManager i;
    private final MailService j;

    public VirusScanningEmailJobRunner(AssignedNodeService assignedNodeService, AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport ClusterLockService clusterLockService, @ComponentImport ClusterManager clusterManager, MailService mailService) {
        this.f = assignedNodeService;
        this.g = attachmentCheckerConfig;
        this.h = clusterLockService;
        this.i = clusterManager;
        this.j = mailService;
    }

    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        e.debug("Running scheduled job: VirusScanningEmailJob");
        if (this.g.a()) {
            e.debug("Virus scanning comment is enabled. No email required.");
        } else if (!this.f.a()) {
            e.debug("No errors for all nodes. No email required.");
        } else if (this.a()) {
            try {
                this.j.a();
            }
            finally {
                this.g.setIsVirusScanningEmailJobRunning(false);
                this.g.setVirusScanningEmailJobNodeId("");
            }
        }
        e.debug("End of scheduled job: VirusScanningEmailJob");
        return JobRunnerResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a() {
        boolean bl;
        block11: {
            bl = false;
            if (this.i.isClustered()) {
                e.debug("Instance is clustered!");
                ClusterLock clusterLock = this.h.getLockForName(a);
                try {
                    e.debug("Getting cluster lock...");
                    if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                        e.debug("Cluster lock acquired!");
                        try {
                            String string = null;
                            ClusterNodeInformation clusterNodeInformation = this.i.getThisNodeInformation();
                            if (clusterNodeInformation != null) {
                                string = clusterNodeInformation.getAnonymizedNodeIdentifier();
                            }
                            String string2 = this.g.getVirusScanningEmailJobNodeId();
                            e.debug("Current node ID [" + string + "]");
                            e.debug("VirusScanningEmailJob node ID [" + string2 + "]");
                            if (!this.g.b() || string2.isEmpty() || string2.equals(string) || !this.a(string2)) {
                                this.g.setIsVirusScanningEmailJobRunning(true);
                                this.g.setVirusScanningEmailJobNodeId(string);
                                bl = true;
                            } else {
                                e.debug("VirusScanningEmailJob is running on another node [" + string2 + "]");
                            }
                            break block11;
                        }
                        finally {
                            clusterLock.unlock();
                            e.debug("Cluster lock released!");
                        }
                    }
                    e.debug("Unable to get cluster lock!");
                }
                catch (InterruptedException interruptedException) {
                    e.error("Interrupted when getting cluster lock", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            } else {
                e.debug("Instance is not clustered!");
                bl = true;
            }
        }
        e.debug("Run VirusScanningEmailJob on current node? [" + bl + "]");
        return bl;
    }

    private boolean a(String string) {
        boolean bl = this.i.getAllNodesInformation().stream().anyMatch(clusterNodeInformation -> clusterNodeInformation.getAnonymizedNodeIdentifier().equals(string));
        e.debug("Is node ID [" + string + "] alive? [" + bl + "]");
        return bl;
    }
}

