/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.service.FileTypeViolationService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ViolationScannerJobRunner
implements JobRunner {
    private static final Logger e = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.scheduler.ViolationScannerJobRunner");
    public static final String a = ViolationScannerJobRunner.class.getName() + ".lock";
    public static final JobRunnerKey b = JobRunnerKey.of((String)ViolationScannerJobRunner.class.getName());
    public static final JobId c = JobId.of((String)ViolationScannerJobRunner.class.getName());
    public static final long d = 86400000L;
    private final AccessModeCompatService f;
    private final AttachmentCheckerConfig g;
    private final AttachmentManager h;
    private final ClusterLockService i;
    private final LicenseHelper j;
    private final PageManager k;
    private final FileTypeViolationService l;
    private final SpaceInfoService m;
    private final SpaceScannedService n;
    private final TransactionTemplate o;

    public ViolationScannerJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentManager attachmentManager, @ComponentImport ClusterLockService clusterLockService, LicenseHelper licenseHelper, @ComponentImport PageManager pageManager, FileTypeViolationService fileTypeViolationService, SpaceInfoService spaceInfoService, SpaceScannedService spaceScannedService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.f = accessModeCompatService;
        this.g = attachmentCheckerConfig;
        this.h = attachmentManager;
        this.i = clusterLockService;
        this.j = licenseHelper;
        this.k = pageManager;
        this.l = fileTypeViolationService;
        this.m = spaceInfoService;
        this.n = spaceScannedService;
        this.o = transactionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest jobRunnerRequest) {
        block8: {
            e.debug("RunJob [" + String.valueOf(c) + "]");
            if (this.f.isReadOnlyAccessModeEnabled()) {
                e.info("Read-only access mode enabled, aborting violation scanner job.");
                return JobRunnerResponse.aborted((String)"Violation scanner job aborted because read-only access mode is enabled.");
            }
            ClusterLock clusterLock = this.i.getLockForName(a);
            try {
                if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                    e.debug("ViolationScannerJob lock acquired!");
                    this.g.setIsViolationScanRunning(true);
                    boolean bl = this.j.a();
                    try {
                        e.debug("--- Running ViolationScannerJob...");
                        if (this.a(bl)) {
                            this.b(bl);
                        }
                        e.debug("--- ViolationScannerJob completed!");
                        break block8;
                    }
                    finally {
                        this.g.setIsViolationScanRunning(false);
                        clusterLock.unlock();
                    }
                }
                e.debug("Unable to acquire lock, ViolationScannerJob may be running on another instance!");
            }
            catch (InterruptedException interruptedException) {
                e.error("Interrupted while acquiring ViolationScannerJob lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return JobRunnerResponse.success();
    }

    private boolean a(boolean bl) {
        boolean bl2 = false;
        boolean bl3 = (Boolean)this.o.execute(() -> this.l.getViolatedAttachmentTotalCount() > 0);
        if (this.j.b()) {
            if (bl) {
                e.debug("Evaluation license detected!");
                e.debug("Has record of violated attachment? [" + bl3 + "]");
                bl2 = !bl3;
            } else {
                e.debug("Valid license detected!");
                bl2 = true;
            }
        } else {
            e.debug("Invalid license detected!");
        }
        e.debug("Proceed scanning? [" + bl2 + "]");
        return bl2;
    }

    private void b(boolean bl) {
        try {
            int n = (Integer)this.o.execute(() -> this.m.getSpaceList().size());
            e.debug("Space count [" + n + "]");
            int n2 = (Integer)this.o.execute(() -> this.n.a("violation"));
            e.debug("SpaceScanned count [" + n2 + "]");
            if (n2 > 0) {
                e.info("Deleting SpaceScanned if corresponding Space not found");
                n2 = (Integer)this.o.execute(() -> {
                    this.n.a();
                    return this.n.a("violation");
                });
                e.debug("SpaceScanned count after delete [" + n2 + "]");
            }
            if (!this.g.z()) {
                this.g.setViolationScannerLastRun(new Date().getTime());
                boolean bl2 = !this.g.getViolationScannerEndHour().equals("0");
                e.debug("Job end time set? [" + bl2 + "]");
                Calendar calendar = Calendar.getInstance();
                Date date = DateHelper.a(calendar.getTime(), this.g.getViolationScannerEndHour(), this.g.getViolationScannerEndMinute(), this.g.getViolationScannerEndAmPm());
                List list = (List)this.o.execute(this.m::getSpaceList);
                for (Space space : list) {
                    boolean bl3 = (Boolean)this.o.execute(() -> {
                        e.debug("Space key [" + space.getKey() + "]");
                        return this.n.a(space.getKey(), "violation");
                    });
                    e.debug("Is space scanned? [" + bl3 + "]");
                    boolean bl4 = false;
                    if (!bl3) {
                        bl4 = this.a(space, bl);
                    }
                    Date date2 = new Date();
                    e.debug("Current time [" + String.valueOf(date2) + "]");
                    if (!bl4 && (!bl2 || date2.before(date))) continue;
                    e.debug("Stopping job");
                    break;
                }
                if ((n2 = ((Integer)this.o.execute(() -> this.n.a("violation"))).intValue()) == n) {
                    this.o.execute(() -> {
                        this.g.setIsViolationScanCompleted(true);
                        return null;
                    });
                }
            }
        }
        catch (Exception exception) {
            e.error("Exception scanning for file type violated attachments", (Throwable)exception);
        }
    }

    private boolean a(Space space, boolean bl) {
        return (Boolean)this.o.execute(() -> {
            boolean bl2 = false;
            String string = space.getKey();
            e.debug("Checking space [" + string + "]");
            this.l.a(string);
            Collection collection = this.k.getPageIds(space);
            e.debug("Total page count [" + collection.size() + "]");
            for (Long l : collection) {
                e.debug("Checking page id [" + l + "]");
                ContentEntityObject contentEntityObject = this.k.getById(l.longValue());
                if (contentEntityObject == null) continue;
                e.debug("Page title [" + contentEntityObject.getTitle() + "]");
                List list = contentEntityObject.getAttachments();
                e.debug("Total attachments count [" + list.size() + "]");
                bl2 = this.a(list, bl);
                if (!bl2) continue;
                break;
            }
            if (!bl2) {
                this.n.b(string, "violation");
            }
            return bl2;
        });
    }

    private boolean a(@NotNull List<Attachment> list, boolean bl) {
        boolean bl2 = false;
        for (Attachment attachment : list) {
            InputStream inputStream = this.h.getAttachmentData(attachment);
            if (inputStream == null) continue;
            String string = attachment.getFileName();
            e.debug("File name [" + attachment.getFileName() + "]");
            String string2 = FileTypeHelper.d(string);
            String string3 = FileTypeHelper.a(string, inputStream);
            boolean bl3 = this.g.b(string2, string3, attachment.getVersionComment());
            boolean bl4 = this.g.a(string2, bl3);
            e.debug("Is extension [" + string2 + "] valid? [" + bl4 + "]");
            boolean bl5 = this.g.a(string2, string3, this.h.getAttachmentData(attachment), bl3);
            e.debug("Is MIME type [" + string3 + "] valid? [" + bl5 + "]");
            if (bl4 && bl5) continue;
            e.debug("Found violated attachment id [" + attachment.getId() + "]");
            this.l.a(attachment, string2, string3, bl4, bl5);
            if (!bl) continue;
            e.debug("Evaluation license detected! Stop scanning!");
            bl2 = true;
            break;
        }
        return bl2;
    }
}

