/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceToUpdateService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.AlertBannerBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaSearchBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.QuotaHelper;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/space")
public class SpaceQuotaResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.SpaceQuotaResource");
    private static final String b = "com.akeles.acc.error.spaceNotFound";
    private static final String c = "com.akeles.acc.error.noViewPermission";
    private static final String d = "com.akeles.acc.spaceQuota.noEditPermission";
    private static final String e = "com.akeles.acc.spaceQuota.notViewable";
    private final AttachmentCheckerConfig f;
    private final Gson g;
    private final I18nResolver h;
    private final PermissionManager i;
    private final QuotaHelper j;
    private final SpaceInfoService k;
    private final SpaceManager l;
    private final SpaceToUpdateService m;

    @Inject
    public SpaceQuotaResource(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, QuotaHelper quotaHelper, SpaceInfoService spaceInfoService, @ComponentImport SpaceManager spaceManager, SpaceToUpdateService spaceToUpdateService) {
        this.f = attachmentCheckerConfig;
        this.g = new Gson();
        this.h = i18nResolver;
        this.i = permissionManager;
        this.j = quotaHelper;
        this.k = spaceInfoService;
        this.l = spaceManager;
        this.m = spaceToUpdateService;
    }

    @GET
    @Path(value="/{spaceKey}/status")
    @Produces(value={"application/json"})
    public Response a(@PathParam(value="spaceKey") String string) {
        String string2;
        String string3;
        a.debug("Get quota status for space [" + string + "]");
        if (!this.f.o()) {
            a.debug("Quota check not enabled, no alert required");
            return Response.noContent().build();
        }
        Space space = this.l.getSpace(string);
        if (StringUtils.isEmpty((CharSequence)string) || space == null || !this.f.e(string)) {
            a.debug("Space quota not viewable, no alert required");
            return Response.noContent().build();
        }
        SpaceQuotaBean spaceQuotaBean = this.j.a(space);
        if (spaceQuotaBean.getIsQuotaUnlimited() || spaceQuotaBean.getQuotaUsageColour().equals("green")) {
            a.debug("Space quota threshold not reached, no alert required");
            return Response.noContent().build();
        }
        if (spaceQuotaBean.getQuotaUsageColour().equals("orange")) {
            string3 = "warning";
            string2 = this.f.getQuotaAlertMessage();
        } else {
            string3 = "error";
            string2 = this.f.getQuotaErrorMessage();
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        boolean bl = this.f.a(confluenceUser, this.l.getSpace(string));
        AlertBannerBean alertBannerBean = new AlertBannerBean(string3, string2, bl);
        a.debug("Alert type [" + alertBannerBean.getType() + "]");
        a.debug("Alert message [" + alertBannerBean.getMessage() + "]");
        a.debug("User [" + String.valueOf(confluenceUser) + "] has permission to view space quota? [" + alertBannerBean.hasViewSpaceQuotaPermission() + "]");
        return Response.ok((Object)this.g.toJson((Object)alertBannerBean)).build();
    }

    @GET
    @Path(value="/quota")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="start") int n) {
        a.debug("Get space quota with start index [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get space quota");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(c)).build();
        }
        if (!this.f.q()) {
            a.debug("Space quota not viewable, unable to get space quota");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.h.getText(e)).build();
        }
        List<SpaceQuotaBean> list = new ArrayList<SpaceQuotaBean>();
        int n2 = this.k.getSpaceCount();
        if (n >= 0) {
            list = this.j.a(n);
        }
        SpaceQuotaSearchBean spaceQuotaSearchBean = new SpaceQuotaSearchBean(n2, list);
        a.debug(spaceQuotaSearchBean.toString());
        return Response.ok((Object)this.g.toJson((Object)spaceQuotaSearchBean)).build();
    }

    @GET
    @Path(value="/{spaceKey}/quota")
    @Produces(value={"application/json"})
    public Response b(@PathParam(value="spaceKey") String string) {
        a.debug("Get quota for space [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.f.a(confluenceUser, this.l.getSpace(string))) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have permission to get quota for space [" + string + "]");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(c)).build();
        }
        Space space = this.l.getSpace(string);
        if (StringUtils.isEmpty((CharSequence)string) || space == null) {
            a.debug("Space not found! Unable to get space quota for space key [" + string + "]");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.h.getText(b, new Serializable[]{string})).build();
        }
        if (!this.f.e(string)) {
            a.debug("Space quota not viewable, unable to get space quota");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.h.getText(e)).build();
        }
        SpaceQuotaBean spaceQuotaBean = this.j.a(space);
        return Response.ok((Object)this.g.toJson((Object)spaceQuotaBean)).build();
    }

    @POST
    @Path(value="/{spaceKey}/quota")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response a(@PathParam(value="spaceKey") String string, @QueryParam(value="quotaAllocated") String string2) {
        a.debug("Set quota for space [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to set quota for space [" + string + "]");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(d)).build();
        }
        Space space = this.l.getSpace(string);
        if (StringUtils.isEmpty((CharSequence)string) || space == null) {
            a.debug("Space not found! Unable to set space quota for space key [" + string + "]");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.h.getText(b, new Serializable[]{string})).build();
        }
        if (!this.f.e(string)) {
            a.debug("Space quota not viewable, unable to set space quota");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.h.getText(e)).build();
        }
        a.debug("New quota allocated [" + string2 + "]");
        String string3 = this.f.getUnit();
        long l = -1L;
        string2 = AttachmentCheckerHelper.c(string2);
        if (!StringUtils.isEmpty((CharSequence)string2)) {
            l = Long.parseLong(AttachmentCheckerHelper.a(string2, string3));
        }
        this.k.a(string, l);
        SpaceQuotaBean spaceQuotaBean = this.j.a(space);
        return Response.ok((Object)this.g.toJson((Object)spaceQuotaBean)).build();
    }

    @POST
    @Path(value="/{spaceKey}/queue")
    @Produces(value={"application/json"})
    @ReadOnlyAccessBlocked
    public Response c(@PathParam(value="spaceKey") String string) {
        a.debug("Add space to queue [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser) && !this.i.hasPermission(confluenceUser, Permission.ADMINISTER, (Object)this.l.getSpace(string))) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to add space to queue [" + string + "]");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.h.getText(d)).build();
        }
        Space space = this.l.getSpace(string);
        if (StringUtils.isEmpty((CharSequence)string) || space == null) {
            a.debug("Space not found! Unable to add space to queue for space key [" + string + "]");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.h.getText(b, new Serializable[]{string})).build();
        }
        this.m.b(string);
        SpaceQuotaBean spaceQuotaBean = this.j.a(space);
        return Response.ok((Object)this.g.toJson((Object)spaceQuotaBean)).build();
    }
}

