/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.ErrorCollection;
import com.akelesconsulting.confluence.plugins.rest.FileSizeLimitBean;
import com.akelesconsulting.confluence.plugins.rest.Result;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/config/file-size-limit")
public class FileSizeLimitResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.FileSizeLimitResource");
    private final AttachmentCheckerConfig b;
    private final FileSizeLimitService c;
    private final PermissionManager d;
    private final CacheControl e;

    @Inject
    public FileSizeLimitResource(AttachmentCheckerConfig attachmentCheckerConfig, FileSizeLimitService fileSizeLimitService, @ComponentImport PermissionManager permissionManager) {
        this.b = attachmentCheckerConfig;
        this.c = fileSizeLimitService;
        this.d = permissionManager;
        this.e = new CacheControl();
        this.e.setNoCache(true);
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="fileSizeCheck") String string) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.d.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to update config");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        a.debug("Update fileSizeCheck [" + string + "]");
        this.b.setFileSizeCheck(string);
        return Response.ok((Object)this.b.g()).build();
    }

    @GET
    @Path(value="/{groupId}")
    public Response a(@PathParam(value="groupId") int n) {
        a.debug("Get file size limit for group id [" + n + "]");
        List<FileSizeLimitBean> list = this.c.a(n);
        return Response.ok(list).cacheControl(this.e).build();
    }

    @POST
    @Path(value="/{groupId}")
    public Response a(@PathParam(value="groupId") int n, @Context HttpServletRequest httpServletRequest, FileSizeLimitBean fileSizeLimitBean) {
        a.debug("Add file size limit for group id [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.d.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to add file size limit");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String string = fileSizeLimitBean.getExtension();
        if (string != null && !string.isEmpty() && !string.startsWith(".")) {
            fileSizeLimitBean.setExtension("." + string);
        }
        String string2 = FileTypeHelper.a(fileSizeLimitBean.getExtension());
        a.debug("Extension [" + string + "] mime type [" + string2 + "]");
        a.debug("Size limit [" + fileSizeLimitBean.getSizeLimit() + "]");
        a.debug("Size unit [" + fileSizeLimitBean.getSizeUnit() + "]");
        Result<FileSizeLimitBean> result = this.c.a(n, fileSizeLimitBean, string2);
        if (result.a()) {
            return Response.ok((Object)fileSizeLimitBean).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorCollection(result.getErrors())).cacheControl(this.e).build();
    }

    @PUT
    @Path(value="/{groupId}/{id}")
    public Response a(@PathParam(value="groupId") int n, @PathParam(value="id") int n2, @Context HttpServletRequest httpServletRequest, FileSizeLimitBean fileSizeLimitBean) {
        a.debug("Update file size limit id [" + n2 + "] for group id [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.d.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to update file size limit");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String string = fileSizeLimitBean.getExtension();
        if (string != null && !string.isEmpty() && !string.startsWith(".")) {
            fileSizeLimitBean.setExtension("." + string);
        }
        String string2 = FileTypeHelper.a(fileSizeLimitBean.getExtension());
        a.debug("Modified extension [" + string + "] mime type [" + string2 + "]");
        a.debug("Size limit [" + fileSizeLimitBean.getSizeLimit() + "]");
        a.debug("Size unit [" + fileSizeLimitBean.getSizeUnit() + "]");
        Result<FileSizeLimitBean> result = this.c.b(n, fileSizeLimitBean, string2);
        if (result.a()) {
            return Response.ok((Object)result.getResult()).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorCollection(result.getErrors())).cacheControl(this.e).build();
    }

    @DELETE
    @Path(value="/{groupId}/{id}")
    public Response a(@PathParam(value="groupId") int n, @PathParam(value="id") int n2, @Context HttpServletRequest httpServletRequest) {
        a.debug("Delete file size limit id [" + n2 + "] for group id [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (this.d.isConfluenceAdministrator(confluenceUser)) {
            this.c.a(n, n2);
            return Response.ok().build();
        }
        a.debug("An unauthorised user [" + String.valueOf(confluenceUser) + "] tried to delete file size limit.");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }
}

