/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/scanning-queue")
public class AttachmentScanningQueueResource {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentScanningQueueResource");
    private static final int b = 50;
    private final AttachmentHelper c;
    private final AttachmentToScanService d;
    private final DateHelper e;
    private final GlobalSettingsManager f;
    private final Gson g;
    private final I18nResolver h;
    private final PermissionManager i;

    @Inject
    public AttachmentScanningQueueResource(AttachmentHelper attachmentHelper, AttachmentToScanService attachmentToScanService, DateHelper dateHelper, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport I18nResolver i18nResolver, PermissionManager permissionManager) {
        this.c = attachmentHelper;
        this.d = attachmentToScanService;
        this.e = dateHelper;
        this.f = globalSettingsManager;
        this.g = new Gson();
        this.h = i18nResolver;
        this.i = permissionManager;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug("Get list of AttachmentToScan, start index [" + n + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator(confluenceUser)) {
            a.debug("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get scanning queue list");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        List<AttachmentToScan> list = this.d.a(n, 50);
        String string = this.f.getGlobalSettings().getBaseUrl();
        for (AttachmentToScan attachmentToScan : list) {
            Object object;
            long l = attachmentToScan.getAttachmentId();
            a.debug("Attachment id [" + l + "]");
            int n2 = attachmentToScan.getVersion();
            Date date = attachmentToScan.getCreationDate();
            Attachment attachment = this.c.a(l, n2, date);
            if (attachment == null) {
                this.d.a(attachmentToScan);
                continue;
            }
            String string2 = attachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(attachment.getFileSize(), 2);
            ContentEntityObject contentEntityObject = attachment.getContainer();
            long l2 = contentEntityObject == null ? 0L : contentEntityObject.getId();
            String string4 = this.c.a(attachment, l, n2, l2);
            AttachmentBean attachmentBean = new AttachmentBean(attachmentToScan.getID(), this.e.a(date, this.h.getText("com.akeles.acc.unknown")), attachmentToScan.getVersion(), string2, string3, string4);
            attachmentBean.setIsInTrash(attachment.isDeleted());
            attachmentBean.setCreator(this.a(attachment, string));
            Space space = attachment.getSpace();
            if (space != null) {
                object = new SpaceBean(space.getKey());
                ((SpaceBean)object).setName(space.getName());
                ((SpaceBean)object).setUrl(string + space.getUrlPath());
                attachmentBean.setSpace((SpaceBean)object);
            }
            if ((object = attachment.getContainer()) != null) {
                PageBean pageBean = new PageBean();
                pageBean.setTitle(object.getTitle());
                pageBean.setUrl(string + object.getAttachmentsUrlPath());
                attachmentBean.setPage(pageBean);
            }
            resultBean.addAttachment(attachmentBean);
        }
        int n3 = this.d.getAttachmentToScanCount();
        resultBean.setPagination(n, n3);
        a.debug(resultBean.toString());
        return Response.ok((Object)this.g.toJson((Object)resultBean)).build();
    }

    @NotNull
    private UserBean a(@NotNull Attachment attachment, String string) {
        UserBean userBean;
        ConfluenceUser confluenceUser = attachment.getCreator();
        if (confluenceUser != null) {
            userBean = new UserBean(confluenceUser.getKey().getStringValue());
            userBean.setDisplayName(confluenceUser.getFullName());
            userBean.setUsername(confluenceUser.getName());
            userBean.setUrl(string + "/display/~" + confluenceUser.getName());
        } else {
            userBean = new UserBean("");
        }
        return userBean;
    }
}

