/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.notification;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.lang.invoke.SerializedLambda;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MailService {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.notification.MailService");
    private static final String b = "mail";
    private final AttachmentCheckerConfig c;
    private final GlobalSettingsManager d;
    private final GroupManager e;
    private final MultiQueueTaskManager f;
    private final PageManager g;
    private final UserAccessor h;

    @Autowired
    public MailService(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport @Qualifier(value="globalSettingsManager") GlobalSettingsManager globalSettingsManager, @ComponentImport GroupManager groupManager, @ComponentImport MultiQueueTaskManager multiQueueTaskManager, @ComponentImport PageManager pageManager, @ComponentImport UserAccessor userAccessor) {
        this.c = attachmentCheckerConfig;
        this.d = globalSettingsManager;
        this.e = groupManager;
        this.f = multiQueueTaskManager;
        this.g = pageManager;
        this.h = userAccessor;
    }

    public void a(boolean bl, boolean bl2, int n, String string, String string2, long l, @NotNull Attachment attachment) {
        boolean bl3;
        String string3;
        Group group;
        String string4 = this.c.getGroupToEmail();
        a.debug("Send email to group [" + string4 + "] regarding attachment [" + string + "]");
        ConfluenceUser confluenceUser = attachment.getCreator();
        String string5 = confluenceUser == null ? "Anonymous" : confluenceUser.getName();
        String string6 = attachment.getCreationDate().toString();
        a.debug("Attachment creator [" + string5 + "]");
        a.debug("Attachment creation date [" + string6 + "]");
        try {
            group = this.e.getGroup(string4);
        }
        catch (EntityException entityException) {
            a.error("Virus scanning error/infection email not sent, error getting group with group name [" + string4 + "]", (Throwable)entityException);
            return;
        }
        ContentEntityObject contentEntityObject = this.g.getById(l);
        String string7 = "page id " + l;
        Object object = "Attachment Checker for Confluence alert";
        if (contentEntityObject != null) {
            object = (String)object + " for " + contentEntityObject.getType().toLowerCase() + ": " + contentEntityObject.getDisplayTitle();
            string7 = contentEntityObject.getType().toLowerCase() + " <a href=\"" + this.d.getGlobalSettings().getBaseUrl() + contentEntityObject.getUrlPath() + "\">" + contentEntityObject.getDisplayTitle() + "</a>";
        } else {
            a.debug("ContentEntityObject with id [" + l + "] is null");
        }
        a.debug("Email subject [" + (String)object + "]");
        if (bl) {
            string3 = "<p>Attachment Checker has detected an infected file <strong>" + string + "</strong> attached to " + string7 + ".</p>";
            bl3 = this.c.j();
        } else {
            string3 = "<p>Attachment Checker has encountered an error while scanning <strong>" + string + "</strong> attached to " + string7 + ".</p>";
            bl3 = this.c.l();
        }
        string3 = string3 + "<p>Attachment creator: " + string5 + "<br>Attachment creation date: " + string6 + "</p>";
        string3 = string3 + "<p>The error code is <strong>" + n + "</strong>.</p>";
        string3 = bl3 ? (bl2 ? string3 + "<p>The file has been deleted.</p>" : string3 + "<p>An unexpected error occurred while deleting the file.</p>") : string3 + "<p>To scan the file manually, please execute the command:</p><p>" + string2 + "</p>";
        a.debug("Email body [" + string3 + "]");
        this.a(group, (String)object, string3);
    }

    public void a(String string) {
        Group group;
        String string2 = this.c.getGroupToEmail();
        a.debug("Send virus scanning paused email to group [" + string2 + "] for node [" + string + "]");
        try {
            group = this.e.getGroup(string2);
        }
        catch (EntityException entityException) {
            a.error("Virus scanning paused email not sent, error getting group with group name [" + string2 + "]", (Throwable)entityException);
            return;
        }
        String string3 = "Attachment Checker for Confluence virus scanning safety limit alert";
        String string4 = "<p>Attachment Checker has encountered 5 errors/infections within 30 minutes.</p><p>Virus scanning has been paused" + (String)(string != null ? " in node <strong>" + string + "</strong>" : "") + ".</p><p>Please take a moment to review them before resuming scan at <a href=\"" + this.d.getGlobalSettings().getBaseUrl() + "/admin/attachmentChecker/AttachmentScanningStatus.action\">Attachment Scanning Status</a>.</p>";
        this.a(group, string3, string4);
    }

    public void a() {
        Group group;
        String string = this.c.getGroupToEmail();
        a.debug("Send virus scanning daily email to group [" + string + "]");
        try {
            group = this.e.getGroup(string);
        }
        catch (EntityException entityException) {
            a.error("Virus scanning daily email not sent, error getting group with group name [" + string + "]", (Throwable)entityException);
            return;
        }
        String string2 = "Attachment Checker for Confluence virus scanning daily alert";
        String string3 = "<p>This is a reminder to review virus scanning errors/infections that have been detected.</p><p>Please take a moment to check the <a href=\"" + this.d.getGlobalSettings().getBaseUrl() + "/admin/attachmentChecker/AttachmentScanningStatus.action\">Attachment Scanning Status</a> at your earliest convenience.</p>";
        this.a(group, string2, string3);
    }

    private void a(Group group, String string, String string2) {
        a.debug("Getting members of group [" + String.valueOf(group) + "]");
        Iterable iterable = this.h.getMembers(group);
        for (ConfluenceUser confluenceUser : iterable) {
            a.debug("Group member [" + String.valueOf(confluenceUser) + "]");
            String string3 = confluenceUser.getEmail();
            ConfluenceMailQueueItem confluenceMailQueueItem = new ConfluenceMailQueueItem(string3, string, string2, "text/html");
            this.f.addTask(b, () -> ((MailQueueItem)confluenceMailQueueItem).send());
            a.debug("Added mail to queue for user [" + String.valueOf(confluenceUser.getKey()) + "] email [" + string3 + "]");
        }
        a.debug("Done!");
    }

    private static /* synthetic */ Object a(SerializedLambda serializedLambda) {
        switch (serializedLambda.getImplMethodName()) {
            case "send": {
                if (serializedLambda.getImplMethodKind() != 9 || !serializedLambda.getFunctionalInterfaceClass().equals("com/atlassian/core/task/Task") || !serializedLambda.getFunctionalInterfaceMethodName().equals("execute") || !serializedLambda.getFunctionalInterfaceMethodSignature().equals("()V") || !serializedLambda.getImplClass().equals("com/atlassian/mail/queue/MailQueueItem") || !serializedLambda.getImplMethodSignature().equals("()V")) break;
                return () -> ((MailQueueItem)((MailQueueItem)serializedLambda.getCapturedArg(0))).send();
            }
        }
        throw new IllegalArgumentException("Invalid lambda deserialization");
    }
}

