/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.filter;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.akelesconsulting.confluence.plugins.utils.SmartRequestWrapper;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.struts.StrutsHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import com.google.gson.Gson;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class AttachmentCheckerFilter
implements Filter {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.filter.AttachmentCheckerFilter");
    private static final String b = "/pages/doattachfile.action";
    private static final String c = "/pages/plugins/attachments/doattachfile.action";
    private static final int d = 0;
    private static final int e = -1;
    private static final int f = -2;
    private static final int g = -3;
    private final AttachmentCheckerConfig h;
    private final Gson i;
    private final I18nResolver j;
    private final SpaceManager k;
    private final StrutsHelper l;

    public AttachmentCheckerFilter(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport SpaceManager spaceManager, @ComponentImport StrutsHelper strutsHelper) {
        this.h = attachmentCheckerConfig;
        this.i = new Gson();
        this.j = i18nResolver;
        this.k = spaceManager;
        this.l = strutsHelper;
    }

    public void init(FilterConfig filterConfig) {
        a.debug("Initializing AttachmentCheckerFilter...");
    }

    public void destroy() {
        a.debug("Stopping AttachmentCheckerFilter...");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        a.debug("*** START OF REQUEST ***");
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String string = httpServletRequest.getMethod();
            a.debug("Request URI [" + httpServletRequest.getRequestURI() + "]");
            a.debug("Method [" + string + "]");
            if ("POST".equalsIgnoreCase(string)) {
                this.a(httpServletRequest, httpServletResponse, filterChain);
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        a.debug("*** END OF REQUEST ***");
    }

    private void a(@NotNull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        String string = httpServletRequest.getRequestURL().toString().toLowerCase();
        a.debug("Request url [" + string + "]");
        SmartRequestWrapper smartRequestWrapper = new SmartRequestWrapper(httpServletRequest);
        boolean bl = string.contains(b);
        boolean bl2 = string.contains("confiforms");
        boolean bl3 = string.contains("/rest/api");
        a.debug("Is ConfiForms? [" + bl2 + "]");
        a.debug("Is REST API? [" + bl3 + "]");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Map<String, String>> arrayList2 = new ArrayList<Map<String, String>>();
        int n = bl3 ? this.a(smartRequestWrapper, arrayList) : (ServletActionContext.getRequest() instanceof MultiPartRequestWrapper ? this.a(smartRequestWrapper, bl, bl2, arrayList2, arrayList) : this.b(smartRequestWrapper, arrayList));
        if (n == 0) {
            a.debug("Continuing request...");
            if (bl2) {
                a.debug("Passing ServletActionContext.getRequest() down the filter chain");
                filterChain.doFilter((ServletRequest)ServletActionContext.getRequest(), (ServletResponse)httpServletResponse);
            } else {
                a.debug("Passing SmartRequestWrapper down the filter chain");
                filterChain.doFilter((ServletRequest)smartRequestWrapper, (ServletResponse)httpServletResponse);
            }
            smartRequestWrapper.a();
        } else {
            a.debug("Intercepting request...");
            smartRequestWrapper.a();
            if (bl) {
                String string2 = httpServletRequest.getContextPath() + "/plugins/servlet/upload-failure";
                a.debug("Redirecting to [" + string2 + "]");
                httpServletRequest.getSession().setAttribute("errorList", arrayList);
                httpServletRequest.getSession().setAttribute("attachmentList", (Object)this.i.toJson(arrayList2));
                httpServletResponse.sendRedirect(string2);
            } else if (string.contains(c)) {
                String string3 = "<div class=\"aui-message aui-message-error\"><p>" + (String)arrayList.getFirst() + "</p></div>";
                this.a(httpServletResponse, string3);
            } else {
                httpServletResponse.setStatus(bl2 ? Response.Status.OK.getStatusCode() : Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
                JSONObject jSONObject = this.a(arrayList, bl2);
                this.a(httpServletResponse, jSONObject);
            }
        }
    }

    private int a(@NotNull HttpServletRequestWrapper httpServletRequestWrapper, boolean bl, boolean bl2, List<Map<String, String>> list, List<String> list2) {
        a.debug("Checking struts multipart request");
        int n = 0;
        long l = 0L;
        String string = httpServletRequestWrapper.getParameter("pageId");
        if (string == null) {
            string = httpServletRequestWrapper.getParameter("contentId");
        }
        a.debug("Page ID [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        List list3 = new ArrayList();
        try {
            list3 = this.l.getUploadedFiles((HttpServletRequest)httpServletRequestWrapper);
        }
        catch (FileUploadException fileUploadException) {
            a.debug("Error getting uploaded files from struts multipart request");
        }
        a.debug("UploadedFile list size [" + list3.size() + "]");
        for (UploadedFile uploadedFile : list3) {
            String string2 = uploadedFile.getFileName();
            a.debug("File name [" + string2 + "]");
            String string3 = FileTypeHelper.d(string2);
            String string4 = "application/octet-stream";
            boolean bl3 = false;
            boolean bl4 = false;
            long l2 = 0L;
            File file = uploadedFile.getFile();
            try {
                string4 = FileTypeHelper.a(string2, Files.newInputStream(file.toPath(), new OpenOption[0]));
                bl3 = this.h.a(string3, false);
                bl4 = this.h.a(string3, string4, Files.newInputStream(file.toPath(), new OpenOption[0]), false);
                a.debug("MIME type [" + string4 + "]");
                l2 = Files.size(file.toPath());
                a.debug("File size [" + l2 + "]");
                l += l2;
            }
            catch (IOException iOException) {
                a.debug("Error detecting MIME type for [" + string2 + "]");
            }
            if (!bl3 || !bl4) {
                n = -1;
                list2.add(this.a(n, string2, bl2));
            }
            if (this.h.g() && this.h.a(string4, l2, confluenceUser)) {
                n = -3;
                list2.add(this.a(n, string2, bl2));
            }
            String string5 = this.a(l2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("name", string2);
            hashMap.put("size", string5);
            hashMap.put("isValid", Boolean.toString(bl3 && bl4));
            list.add(hashMap);
        }
        String string6 = this.a(string);
        n = this.a(n, string6, l, bl, false, list2);
        a.debug("Status code [" + n + "]");
        return n;
    }

    private int a(@NotNull SmartRequestWrapper smartRequestWrapper, List<String> list) {
        Object object;
        a.debug("Checking multipart request");
        int n = 0;
        String string = null;
        String string2 = smartRequestWrapper.getRequestURI();
        if (string2.contains("/rest/api/content/")) {
            string = string2.substring(string2.indexOf("/rest/api/content/") + 18, string2.indexOf("/child/attachment"));
        }
        a.debug("Page ID [" + string + "]");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        DiskFileItemFactory diskFileItemFactory = DiskFileItemFactory.builder().get();
        boolean bl = false;
        long l = 0L;
        try {
            object = new JakartaServletFileUpload((FileItemFactory)diskFileItemFactory).parseRequest((HttpServletRequest)smartRequestWrapper);
            a.debug("FileItem list size [" + object.size() + "]");
            DiskFileItem diskFileItem2 = object.stream().filter(diskFileItem -> "comment".equalsIgnoreCase(diskFileItem.getFieldName())).findFirst().orElse(null);
            String string3 = diskFileItem2 == null ? "" : diskFileItem2.getString();
            a.debug("Comment [" + string3 + "]");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                DiskFileItem diskFileItem3 = (DiskFileItem)iterator.next();
                String string4 = diskFileItem3.getFieldName();
                String string5 = diskFileItem3.getName();
                a.debug("Field name [" + string4 + "]");
                if (diskFileItem3.isFormField() || string5 == null || string5.isEmpty()) continue;
                String string6 = FilenameUtils.getName((String)string5);
                String string7 = FileTypeHelper.d(string6);
                a.debug("File name [" + string6 + "]");
                a.debug("File ext. [" + string7 + "]");
                String string8 = FileTypeHelper.a(string6, diskFileItem3.getInputStream());
                a.debug("MIME type [" + string8 + "]");
                bl = this.h.b(string7, string8, string3);
                boolean bl2 = this.h.a(string7, bl);
                boolean bl3 = this.h.a(string7, string8, (InputStream)smartRequestWrapper.getInputStream(), bl);
                if (!bl2 || !bl3) {
                    n = -1;
                    list.add(this.a(n, string6, false));
                }
                long l2 = diskFileItem3.getSize();
                a.debug("File size [" + l2 + "]");
                if (!bl && this.h.g() && this.h.a(string8, l2, confluenceUser)) {
                    n = -3;
                    list.add(this.a(n, string6, false));
                }
                l += l2;
            }
        }
        catch (IOException iOException) {
            a.error("Error checking file upload", (Throwable)iOException);
        }
        object = this.a(string);
        n = this.a(n, (String)object, l, false, bl, list);
        a.debug("Status code [" + n + "]");
        return n;
    }

    private String a(String string) {
        a.debug("Get space key with page ID [" + string + "]");
        String string2 = null;
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                string2 = this.k.getSpaceFromPageId(l);
            }
            catch (NumberFormatException numberFormatException) {
                a.error("Error parsing page ID as long [" + string + "]", (Throwable)numberFormatException);
            }
        }
        a.debug("Space key [" + string2 + "]");
        return string2;
    }

    private int a(int n, String string, long l, boolean bl, boolean bl2, List<String> list) {
        Space space = this.k.getSpace(string);
        if (this.h.o() && space != null && !bl2 && this.h.f(string)) {
            a.debug("Checking quota for space key [" + string + "]");
            a.debug("Total file size [" + l + "]");
            Map<String, String> map = this.h.a(space, l);
            if (!Boolean.parseBoolean(map.get("isSufficient"))) {
                n = -2;
                String string2 = this.a(map, bl, l);
                list.add(string2);
            }
        }
        return n;
    }

    private int b(@NotNull SmartRequestWrapper smartRequestWrapper, List<String> list) {
        String string;
        a.debug("Checking struts request");
        int n = 0;
        String string2 = smartRequestWrapper.getParameter("spaceKey");
        long l = Long.parseLong(smartRequestWrapper.getParameter("size"));
        String string3 = smartRequestWrapper.getParameter("filename");
        String string4 = FileTypeHelper.d(string3);
        a.debug("File name [" + string3 + "]");
        a.debug("File ext. [" + string4 + "]");
        if (!this.h.a(string4, false)) {
            n = -1;
        } else {
            string = FileTypeHelper.a(string3, (InputStream)smartRequestWrapper.getInputStream());
            a.debug("Mime type [" + string + "]");
            if (!this.h.a(string4, string, (InputStream)smartRequestWrapper.getInputStream(), false)) {
                n = -1;
            } else if (this.h.g() && this.h.a(string, l, AuthenticatedUserThreadLocal.get())) {
                n = -3;
            }
        }
        string = this.k.getSpace(string2);
        if (n != 0) {
            list.add(this.a(n, string3, false));
        } else if (this.h.o() && string != null && this.h.f(string2)) {
            a.debug("Space key [" + string2 + "]");
            a.debug("File size [" + l + "]");
            Map<String, String> map = this.h.a((Space)string, l);
            if (!Boolean.parseBoolean(map.get("isSufficient"))) {
                n = -2;
                String string5 = this.a(map, false, l);
                list.add(string5);
            }
        }
        return n;
    }

    @NotNull
    private String a(int n, String string, boolean bl) {
        Object object;
        switch (n) {
            case -1: {
                Object object2 = this.h.getFileTypeErrorMessage();
                break;
            }
            case -2: {
                Object object2 = this.h.getQuotaErrorMessage();
                break;
            }
            case -3: {
                Object object2 = this.h.getFileSizeErrorMessage();
                break;
            }
            default: {
                Object object2 = object = "";
            }
        }
        if (bl) {
            object = (String)object + " (" + string + ")";
        }
        return HtmlUtil.htmlEncode((String)object);
    }

    @NotNull
    private String a(@NotNull Map<String, String> map, boolean bl, long l) {
        Object object = this.a(-2, null, false);
        String string = this.j.getText("com.akeles.acc.quota.used");
        String string2 = this.j.getText("com.akeles.acc.quota.available");
        String string3 = this.j.getText("com.akeles.acc.quota.usage.details", new Serializable[]{(Serializable)((Object)map.get("used")), (Serializable)((Object)map.get("allocated"))});
        object = bl ? (String)object + "<br><br><span style=\"display:inline-block;width:80px;\"><strong>" + string + "</strong></span>" + string3 + "<br><span style=\"display:inline-block;width:80px;\"><strong>" + string2 + "</strong></span>" + map.get("available") : (String)object + "\n\n" + string + " \t " + string3 + "\n" + string2 + " \t " + map.get("available") + "\n" + this.j.getText("com.akeles.acc.quota.fileSize") + " \t " + this.a(l);
        return object;
    }

    @NotNull
    private String a(long l) {
        String string = this.h.getUnit();
        Object object = AttachmentCheckerHelper.a(l, string, 2);
        object = ((String)object).equals("0.00") ? AttachmentCheckerHelper.a(l, "KB", 2) + " KB" : (String)object + " " + string;
        return object;
    }

    @NotNull
    private JSONObject a(@NotNull List<String> list, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (bl) {
                jSONObject.put("errors", (Object)list.toArray());
            } else {
                jSONObject.put("actionErrors", (Object)new String[]{list.getFirst()});
            }
        }
        catch (JSONException jSONException) {
            a.debug(jSONException.getMessage());
        }
        return jSONObject;
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, @NotNull JSONObject jSONObject) throws IOException {
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        a.debug("Returning JSON response...");
        String string = jSONObject.toString();
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
        a.debug("Response [" + string + "]");
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        a.debug("Returning HTML response...");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }
}

