/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceToUpdate;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Arrays;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpaceToUpdateService {
    private static final Logger a = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.service.SpaceToUpdateService");
    private final ActiveObjects b;
    private final TransactionTemplate c;

    public SpaceToUpdateService(@ComponentImport ActiveObjects activeObjects, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = activeObjects;
        this.c = transactionTemplate;
    }

    public List<SpaceToUpdate> getSpaceToUpdateList() {
        return Arrays.asList((SpaceToUpdate[])this.b.find(SpaceToUpdate.class, Query.select().order("ID ASC")));
    }

    public boolean a(String string) {
        return ((SpaceToUpdate[])this.b.find(SpaceToUpdate.class, Query.select().where("SPACE_KEY = ?", new Object[]{string}))).length > 0;
    }

    public void b(@NotNull String string) {
        a.debug("Add space to SpaceToUpdate queue [" + string + "]");
        if (this.a(string)) {
            a.debug("Space already added to the SpaceToUpdate queue [" + string + "]");
            return;
        }
        try {
            SpaceToUpdate spaceToUpdate = (SpaceToUpdate)this.c.execute(() -> (SpaceToUpdate)this.b.create(SpaceToUpdate.class, new DBParam[]{new DBParam("SPACE_KEY", (Object)string)}));
            a.debug("Added SpaceToUpdate id [" + spaceToUpdate.getID() + "] for space key [" + string + "]");
        }
        catch (Exception exception) {
            a.error("Exception creating SpaceToUpdate", (Throwable)exception);
        }
    }

    public void a(@NotNull SpaceToUpdate spaceToUpdate) {
        a.debug("Delete SpaceToUpdate for space key [" + spaceToUpdate.getSpaceKey() + "]");
        this.c.execute(() -> {
            this.b.delete(new RawEntity[]{spaceToUpdate});
            return null;
        });
    }
}

