/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.actions;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSizeLimitManager
extends ConfluenceActionSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.config.FileSizeLimitManager");
    private transient AccessModeCompatService accessModeCompatService;
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient FileSizeLimitService fileSizeLimitService;
    private transient GroupManager groupManager;
    private transient LicenseHelper licenseHelper;
    private transient TransactionTemplate transactionTemplate;
    private String fileSizeCheck;
    private String groupId;
    private String group;
    private transient List<FileSizeGroup> fileSizeGroups;

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setFileSizeLimitService(FileSizeLimitService fileSizeLimitService) {
        this.fileSizeLimitService = fileSizeLimitService;
    }

    public void setGroupManager(@ComponentImport GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public void setTransactionTemplate(@ComponentImport TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getFileSizeCheck() {
        return this.fileSizeCheck;
    }

    @StrutsParameter
    public void setFileSizeCheck(String string) {
        this.fileSizeCheck = string;
    }

    @StrutsParameter
    public void setGroupId(String string) {
        this.groupId = string;
    }

    @StrutsParameter
    public void setGroup(String string) {
        this.group = string;
    }

    public List<FileSizeGroup> getFileSizeGroups() {
        return this.fileSizeGroups;
    }

    public boolean getIsReadOnlyAccessModeEnabled() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public String execute() {
        logger.debug("Accessing file size limit...");
        logger.debug("Validating license...");
        if (this.licenseHelper.b()) {
            logger.debug("Valid!");
            this.loadSettings();
            return "success";
        }
        logger.debug("Invalid!");
        return "unlicensed";
    }

    private void loadSettings() {
        this.fileSizeCheck = this.attachmentCheckerConfig.getFileSizeCheck();
        logger.debug("File size check [" + this.fileSizeCheck + "]");
        this.fileSizeGroups = this.fileSizeLimitService.getFileSizeGroups();
        logger.debug("Num of groups [" + this.fileSizeGroups.size() + "]");
    }

    public void validate() {
        super.validate();
        if (this.group != null) {
            logger.debug("Validating file size group...");
            try {
                logger.debug("Group id [" + Integer.parseInt(this.groupId) + "]");
                String string = "group" + this.groupId + "Error";
                if (this.group.isEmpty()) {
                    this.addFieldError(string, this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText("group.name")}));
                } else if (this.groupManager.getGroup(this.group) == null) {
                    this.addFieldError(string, this.getText("com.akeles.acc.fileSizeLimit.group.error.notFound", new String[]{this.group}));
                }
            }
            catch (EntityException | NullPointerException | NumberFormatException throwable) {
                this.addActionError(this.getText("com.akeles.acc.config.error.update.failed"));
            }
        } else if (this.fileSizeCheck == null) {
            this.fileSizeCheck = "off";
        }
    }

    @ReadOnlyAccessBlocked
    public String doUpdate() {
        if (this.groupId != null && this.group != null) {
            logger.debug("Group id [" + this.groupId + "] Group [" + this.group + "]");
            logger.debug("Saving file size group...");
            if (!this.fileSizeLimitService.a(Integer.parseInt(this.groupId), this.group)) {
                this.addFieldError("group" + this.groupId + "Error", this.getText("com.akeles.acc.fileSizeLimit.group.error.duplicate"));
                return "error";
            }
        } else {
            this.saveFileSizeCheck();
        }
        return "success";
    }

    private void saveFileSizeCheck() {
        logger.debug("File size check [" + this.fileSizeCheck + "]");
        logger.debug("Saving file size check...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setFileSizeCheck(this.fileSizeCheck);
            return null;
        });
    }
}

