/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.actions;

import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
extends ConfluenceActionSupport {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.akeles.plugins.acc.actions.ConfigManager");
    private static final String ERROR_MESSAGE_I18N_KEY = "com.akeles.acc.config.common.errorMessage";
    private transient AccessModeCompatService accessModeCompatService;
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient AttachmentToScanService attachmentToScanService;
    private transient JobScheduler jobScheduler;
    private transient LicenseHelper licenseHelper;
    private transient TransactionTemplate transactionTemplate;
    private boolean isVirusScanningCommentEnabled;
    private String filterMode;
    private String extensions;
    private String mimeTypeCheck;
    private String allowFilesWithoutExtension;
    private String allowProtected;
    private String allowEncrypted;
    private String allowDrawIo;
    private String allowTableSpreadsheetMacro;
    private String errorMessage;
    private String fileSizeCheck;
    private String fileSizeErrorMessage;
    private String missingFileCheck;
    private String virusScanning;
    private String scannerPath;
    private String scannerOption;
    private String scannerDetected;
    private String deleteIfInfected;
    private String emailIfInfected;
    private String deleteIfError;
    private String emailIfError;
    private String groupToEmail;
    private String virusAlertActor;
    private String quotaCheck;
    private String defaultQuotaAllocated;
    private String defaultQuotaUnit;
    private boolean isDefaultQuotaUnlimited;
    private String quotaCheckErrorMessage;
    private boolean isSetupComplete;
    private int quotaAlertThreshold;
    private String quotaAlertMessage;
    private String allowUsersToViewSpaceQuota;
    private String showSpaceQuotaTips;
    private String spaceQuotaTipsText;
    private String spaceQuotaTipsUrl;
    private String unauthorisedDownloadErrorMessage;
    private String loggingMode;
    private String attachmentLogGroup;

    public void setAccessModeCompatService(AccessModeCompatService accessModeCompatService) {
        this.accessModeCompatService = accessModeCompatService;
    }

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setAttachmentToScanService(AttachmentToScanService attachmentToScanService) {
        this.attachmentToScanService = attachmentToScanService;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public void setJobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void setTransactionTemplate(@ComponentImport TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public String getBaseUrl() {
        return this.getGlobalSettings().getBaseUrl();
    }

    public boolean getIsVirusScanningCommentEnabled() {
        return this.isVirusScanningCommentEnabled;
    }

    public String getFilterMode() {
        return this.filterMode;
    }

    @StrutsParameter
    public void setFilterMode(String string) {
        this.filterMode = string;
    }

    public String getExtensions() {
        return this.extensions;
    }

    @StrutsParameter
    public void setExtensions(String string) {
        this.extensions = string;
    }

    public String getMimeTypeCheck() {
        return this.mimeTypeCheck;
    }

    @StrutsParameter
    public void setMimeTypeCheck(String string) {
        this.mimeTypeCheck = string;
    }

    public String getAllowFilesWithoutExtension() {
        return this.allowFilesWithoutExtension;
    }

    @StrutsParameter
    public void setAllowFilesWithoutExtension(String string) {
        this.allowFilesWithoutExtension = string;
    }

    public String getAllowProtected() {
        return this.allowProtected;
    }

    @StrutsParameter
    public void setAllowProtected(String string) {
        this.allowProtected = string;
    }

    public String getAllowEncrypted() {
        return this.allowEncrypted;
    }

    @StrutsParameter
    public void setAllowEncrypted(String string) {
        this.allowEncrypted = string;
    }

    public String getAllowDrawIo() {
        return this.allowDrawIo;
    }

    @StrutsParameter
    public void setAllowDrawIo(String string) {
        this.allowDrawIo = string;
    }

    public String getAllowTableSpreadsheetMacro() {
        return this.allowTableSpreadsheetMacro;
    }

    @StrutsParameter
    public void setAllowTableSpreadsheetMacro(String string) {
        this.allowTableSpreadsheetMacro = string;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @StrutsParameter
    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public String getFileSizeCheck() {
        return this.fileSizeCheck;
    }

    @StrutsParameter
    public void setFileSizeCheck(String string) {
        this.fileSizeCheck = string;
    }

    public String getFileSizeErrorMessage() {
        return this.fileSizeErrorMessage;
    }

    @StrutsParameter
    public void setFileSizeErrorMessage(String string) {
        this.fileSizeErrorMessage = string;
    }

    public String getMissingFileCheck() {
        return this.missingFileCheck;
    }

    @StrutsParameter
    public void setMissingFileCheck(String string) {
        this.missingFileCheck = string;
    }

    public String getVirusScanning() {
        return this.virusScanning;
    }

    @StrutsParameter
    public void setVirusScanning(String string) {
        this.virusScanning = string;
    }

    public String getScannerPath() {
        return this.scannerPath;
    }

    @StrutsParameter
    public void setScannerPath(String string) {
        this.scannerPath = string;
    }

    public String getScannerOption() {
        return this.scannerOption;
    }

    @StrutsParameter
    public void setScannerOption(String string) {
        this.scannerOption = string;
    }

    public String getScannerDetected() {
        return this.scannerDetected;
    }

    public String getDeleteIfInfected() {
        return this.deleteIfInfected;
    }

    @StrutsParameter
    public void setDeleteIfInfected(String string) {
        this.deleteIfInfected = string;
    }

    public String getEmailIfInfected() {
        return this.emailIfInfected;
    }

    @StrutsParameter
    public void setEmailIfInfected(String string) {
        this.emailIfInfected = string;
    }

    public String getDeleteIfError() {
        return this.deleteIfError;
    }

    @StrutsParameter
    public void setDeleteIfError(String string) {
        this.deleteIfError = string;
    }

    public String getEmailIfError() {
        return this.emailIfError;
    }

    @StrutsParameter
    public void setEmailIfError(String string) {
        this.emailIfError = string;
    }

    public String getGroupToEmail() {
        return this.groupToEmail;
    }

    @StrutsParameter
    public void setGroupToEmail(String string) {
        this.groupToEmail = string;
    }

    public String getVirusAlertActor() {
        return this.virusAlertActor;
    }

    @StrutsParameter
    public void setVirusAlertActor(String string) {
        this.virusAlertActor = string;
    }

    public String getQuotaCheck() {
        return this.quotaCheck;
    }

    @StrutsParameter
    public void setQuotaCheck(String string) {
        this.quotaCheck = string;
    }

    public String getDefaultQuotaAllocated() {
        return this.defaultQuotaAllocated;
    }

    @StrutsParameter
    public void setDefaultQuotaAllocated(String string) {
        this.defaultQuotaAllocated = string;
    }

    public String getDefaultQuotaUnit() {
        return this.defaultQuotaUnit;
    }

    @StrutsParameter
    public void setDefaultQuotaUnit(String string) {
        this.defaultQuotaUnit = string;
    }

    public boolean getIsDefaultQuotaUnlimited() {
        return this.isDefaultQuotaUnlimited;
    }

    public String getQuotaCheckErrorMessage() {
        return this.quotaCheckErrorMessage;
    }

    @StrutsParameter
    public void setQuotaCheckErrorMessage(String string) {
        this.quotaCheckErrorMessage = string;
    }

    public int getQuotaAlertThreshold() {
        return this.quotaAlertThreshold;
    }

    @StrutsParameter
    public void setQuotaAlertThreshold(int n) {
        this.quotaAlertThreshold = n;
    }

    public String getQuotaAlertMessage() {
        return this.quotaAlertMessage;
    }

    @StrutsParameter
    public void setQuotaAlertMessage(String string) {
        this.quotaAlertMessage = string;
    }

    public String getAllowUsersToViewSpaceQuota() {
        return this.allowUsersToViewSpaceQuota;
    }

    @StrutsParameter
    public void setAllowUsersToViewSpaceQuota(String string) {
        this.allowUsersToViewSpaceQuota = string;
    }

    public String getShowSpaceQuotaTips() {
        return this.showSpaceQuotaTips;
    }

    @StrutsParameter
    public void setShowSpaceQuotaTips(String string) {
        this.showSpaceQuotaTips = string;
    }

    public String getSpaceQuotaTipsText() {
        return this.spaceQuotaTipsText;
    }

    @StrutsParameter
    public void setSpaceQuotaTipsText(String string) {
        this.spaceQuotaTipsText = string;
    }

    public String getSpaceQuotaTipsUrl() {
        return this.spaceQuotaTipsUrl;
    }

    @StrutsParameter
    public void setSpaceQuotaTipsUrl(String string) {
        this.spaceQuotaTipsUrl = string;
    }

    public boolean getIsSetupComplete() {
        return this.isSetupComplete;
    }

    public boolean getIsReadOnlyAccessModeEnabled() {
        return this.accessModeCompatService.isReadOnlyAccessModeEnabled();
    }

    public String getUnauthorisedDownloadErrorMessage() {
        return this.unauthorisedDownloadErrorMessage;
    }

    @StrutsParameter
    public void setUnauthorisedDownloadErrorMessage(String string) {
        this.unauthorisedDownloadErrorMessage = string;
    }

    public String getLoggingMode() {
        return this.loggingMode;
    }

    @StrutsParameter
    public void setLoggingMode(String string) {
        this.loggingMode = string;
    }

    public String getAttachmentLogGroup() {
        return this.attachmentLogGroup;
    }

    @StrutsParameter
    public void setAttachmentLogGroup(String string) {
        this.attachmentLogGroup = string;
    }

    public String execute() {
        logger.debug("Accessing attachment checker configuration...");
        logger.debug("Validating license...");
        if (!this.licenseHelper.b()) {
            logger.debug("No valid license found for Attachment Checker for Confluence.");
            return "unlicensed";
        }
        logger.debug("Valid!");
        this.loadSettings();
        return "success";
    }

    private void loadSettings() {
        this.filterMode = this.attachmentCheckerConfig.getFilterMode();
        logger.debug("Filter mode [" + this.filterMode + "]");
        this.extensions = this.attachmentCheckerConfig.getExtensions();
        logger.debug("Extensions [" + this.extensions + "]");
        this.mimeTypeCheck = this.attachmentCheckerConfig.getMimeTypeCheck();
        logger.debug("MIME type check [" + this.mimeTypeCheck + "]");
        this.allowFilesWithoutExtension = this.attachmentCheckerConfig.getAllowFilesWithoutExtension();
        logger.debug("Allow files without extension [" + this.allowFilesWithoutExtension + "]");
        this.allowProtected = this.attachmentCheckerConfig.getAllowProtected();
        logger.debug("Allow protected [" + this.allowProtected + "]");
        this.allowEncrypted = this.attachmentCheckerConfig.getAllowEncrypted();
        logger.debug("Allow encrypted [" + this.allowEncrypted + "]");
        this.allowDrawIo = this.attachmentCheckerConfig.getAllowDrawIo();
        logger.debug("Allow draw.io? [" + this.allowDrawIo + "]");
        this.allowTableSpreadsheetMacro = this.attachmentCheckerConfig.getAllowTableSpreadsheetMacro();
        logger.debug("Allow Table Spreadsheet Macro attachments? [" + this.allowTableSpreadsheetMacro + "]");
        this.errorMessage = this.attachmentCheckerConfig.getFileTypeErrorMessage();
        logger.debug("Error message [" + this.errorMessage + "]");
        this.fileSizeCheck = this.attachmentCheckerConfig.getFileSizeCheck();
        logger.debug("File size check [" + this.fileSizeCheck + "]");
        this.fileSizeErrorMessage = this.attachmentCheckerConfig.getFileSizeErrorMessage();
        logger.debug("File size error message [" + this.fileSizeErrorMessage + "]");
        this.missingFileCheck = this.attachmentCheckerConfig.getMissingFileCheck();
        logger.debug("Missing file check [" + this.missingFileCheck + "]");
        this.virusScanning = this.attachmentCheckerConfig.getVirusScanning();
        logger.debug("Virus scanning [" + this.virusScanning + "]");
        this.scannerPath = this.attachmentCheckerConfig.getScannerPath();
        logger.debug("Scanner path [" + this.scannerPath + "]");
        this.scannerOption = this.attachmentCheckerConfig.getScannerOption();
        logger.debug("Scanner option [" + this.scannerOption + "]");
        this.scannerDetected = this.attachmentCheckerConfig.getScannerDetected();
        logger.debug("Scanner detected [" + this.scannerDetected + "]");
        this.deleteIfInfected = this.attachmentCheckerConfig.getDeleteIfInfected();
        this.emailIfInfected = this.attachmentCheckerConfig.getEmailIfInfected();
        logger.debug("Delete if infected? [" + this.deleteIfInfected + "]");
        logger.debug("Email if infected? [" + this.emailIfInfected + "]");
        this.deleteIfError = this.attachmentCheckerConfig.getDeleteIfError();
        this.emailIfError = this.attachmentCheckerConfig.getEmailIfError();
        logger.debug("Delete if error? [" + this.deleteIfError + "]");
        logger.debug("Email if error? [" + this.emailIfError + "]");
        this.groupToEmail = this.attachmentCheckerConfig.getGroupToEmail();
        logger.debug("Group to email (Confluence Sysadmin Group) [" + this.groupToEmail + "]");
        ConfluenceUser confluenceUser = this.attachmentCheckerConfig.getVirusAlertActorUser();
        logger.debug("Virus alert actor [" + String.valueOf(confluenceUser) + "]");
        if (confluenceUser != null) {
            this.virusAlertActor = confluenceUser.getName();
        }
        this.isVirusScanningCommentEnabled = this.attachmentCheckerConfig.a();
        logger.debug("Is virus scanning comment enabled? [" + this.isVirusScanningCommentEnabled + "]");
        this.quotaCheck = this.attachmentCheckerConfig.getQuotaCheck();
        logger.debug("Quota check [" + this.quotaCheck + "]");
        this.defaultQuotaUnit = this.attachmentCheckerConfig.getUnit();
        this.isDefaultQuotaUnlimited = this.attachmentCheckerConfig.p();
        if (this.isDefaultQuotaUnlimited) {
            this.defaultQuotaAllocated = "Unlimited";
        } else {
            long l = this.attachmentCheckerConfig.getDefaultQuotaAllocated();
            this.defaultQuotaAllocated = AttachmentCheckerHelper.a(l, this.defaultQuotaUnit, 2);
        }
        logger.debug("Default quota allocated [" + this.defaultQuotaAllocated + "] " + this.defaultQuotaUnit);
        this.quotaCheckErrorMessage = this.attachmentCheckerConfig.getQuotaErrorMessage();
        logger.debug("Quota check error message [" + this.quotaCheckErrorMessage + "]");
        this.quotaAlertThreshold = this.attachmentCheckerConfig.getQuotaAlertThreshold();
        logger.debug("Quota alert threshold [" + this.quotaAlertThreshold + "]");
        this.quotaAlertMessage = this.attachmentCheckerConfig.getQuotaAlertMessage();
        logger.debug("Quota alert message [" + this.quotaAlertMessage + "]");
        this.allowUsersToViewSpaceQuota = this.attachmentCheckerConfig.getAllowUsersToViewSpaceQuota();
        logger.debug("Allow users to view space quota? [" + this.allowUsersToViewSpaceQuota + "]");
        this.showSpaceQuotaTips = this.attachmentCheckerConfig.getShowSpaceQuotaTips();
        logger.debug("Show space quota tips? [" + this.showSpaceQuotaTips + "]");
        this.spaceQuotaTipsText = this.attachmentCheckerConfig.getSpaceQuotaTipsText();
        logger.debug("Space quota tips text [" + this.spaceQuotaTipsText + "]");
        this.spaceQuotaTipsUrl = this.attachmentCheckerConfig.getSpaceQuotaTipsUrl();
        logger.debug("Space quota tips URL [" + this.spaceQuotaTipsUrl + "]");
        this.isSetupComplete = this.attachmentCheckerConfig.u();
        this.unauthorisedDownloadErrorMessage = this.attachmentCheckerConfig.getUnauthorisedDownloadErrorMessage();
        logger.debug("Unauthorised download error message [" + this.unauthorisedDownloadErrorMessage + "]");
        this.loggingMode = this.attachmentCheckerConfig.getAttachmentLog();
        logger.debug("Attachment logging mode [" + this.loggingMode + "]");
        this.attachmentLogGroup = this.attachmentCheckerConfig.getAttachmentLogGroup();
        logger.debug("Attachment logging group [ " + this.attachmentLogGroup + " ]");
    }

    public void validate() {
        super.validate();
        if (this.filterMode != null) {
            this.validateFileTypeBlockingSettings();
        } else if (this.fileSizeErrorMessage != null) {
            this.validateFileSizeCheckingSettings();
        } else if (this.scannerPath != null) {
            this.validateVirusCheckingSettings();
        } else if (this.defaultQuotaAllocated != null) {
            this.validateQuotaCheckingSettings();
        }
        this.validateAttachmentLogSettings();
    }

    @NotNull
    private String setToOffIfNull(String string) {
        if (string == null) {
            string = "off";
        }
        return string;
    }

    private void validateFileTypeBlockingSettings() {
        logger.debug("Validating file type blocking settings...");
        if (!AttachmentCheckerHelper.a(this.extensions)) {
            this.extensions = AttachmentCheckerHelper.b(this.extensions);
        }
        this.mimeTypeCheck = this.setToOffIfNull(this.mimeTypeCheck);
        this.allowFilesWithoutExtension = this.setToOffIfNull(this.allowFilesWithoutExtension);
        this.allowProtected = this.setToOffIfNull(this.allowProtected);
        this.allowEncrypted = this.setToOffIfNull(this.allowEncrypted);
        this.allowDrawIo = this.setToOffIfNull(this.allowDrawIo);
        this.allowTableSpreadsheetMacro = this.setToOffIfNull(this.allowTableSpreadsheetMacro);
        if (AttachmentCheckerHelper.a(this.errorMessage)) {
            this.addFieldError("errorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
    }

    private void validateFileSizeCheckingSettings() {
        logger.debug("Validating file size checking settings...");
        if (this.fileSizeCheck == null) {
            this.fileSizeCheck = "off";
        }
        if (AttachmentCheckerHelper.a(this.fileSizeErrorMessage)) {
            this.addFieldError("fileSizeErrorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
    }

    private void validateVirusCheckingSettings() {
        logger.debug("Validating virus scanning settings...");
        if (this.missingFileCheck == null) {
            this.missingFileCheck = "off";
        }
        if (this.virusScanning == null) {
            this.virusScanning = "off";
        } else {
            String string = "scannerPathError";
            if (AttachmentCheckerHelper.a(this.scannerPath)) {
                this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.empty"));
            } else {
                File file = new File(this.scannerPath);
                if (!file.exists()) {
                    logger.debug("Unable to find file at " + this.scannerPath);
                    this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.notFound", new String[]{this.scannerPath}));
                } else if (!file.canExecute()) {
                    logger.debug("Unable to execute file at " + this.scannerPath);
                    this.addFieldError("scannerPathError", this.getText("com.akeles.acc.config.virusScanning.scannerFullPath.error.notExecutable", new String[]{this.scannerPath}));
                }
            }
        }
        if (this.deleteIfInfected == null) {
            this.deleteIfInfected = "off";
        }
        if (this.emailIfInfected == null) {
            this.emailIfInfected = "off";
        }
        if (this.deleteIfError == null) {
            this.deleteIfError = "off";
        }
        if (this.emailIfError == null) {
            this.emailIfError = "off";
        }
    }

    private void validateQuotaCheckingSettings() {
        logger.debug("Validating quota checking settings...");
        if (!AttachmentCheckerHelper.a(this.defaultQuotaAllocated)) {
            this.defaultQuotaAllocated = AttachmentCheckerHelper.c(this.defaultQuotaAllocated);
            if (this.defaultQuotaUnit == null) {
                this.defaultQuotaUnit = this.attachmentCheckerConfig.getUnit();
            }
            this.defaultQuotaAllocated = AttachmentCheckerHelper.a(this.defaultQuotaAllocated, this.defaultQuotaUnit);
        }
        this.isSetupComplete = this.attachmentCheckerConfig.u();
        if (!this.attachmentCheckerConfig.o() && !this.isSetupComplete && "on".equalsIgnoreCase(this.quotaCheck)) {
            this.addFieldError("quotaCheckError", this.getText("com.akeles.acc.config.quotaChecking.quotaCheck.error.incompleteSetup"));
        } else if (this.quotaCheck == null) {
            this.quotaCheck = "off";
        }
        if (AttachmentCheckerHelper.a(this.quotaCheckErrorMessage)) {
            this.addFieldError("quotaCheckErrorMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText(ERROR_MESSAGE_I18N_KEY)}));
        }
        if (this.quotaAlertThreshold < 0) {
            this.addFieldError("quotaAlertThresholdError", this.getText("com.akeles.acc.quota.error.invalid"));
        }
        if (this.quotaAlertThreshold > 0 && AttachmentCheckerHelper.a(this.quotaAlertMessage)) {
            this.addFieldError("quotaAlertMessageError", this.getText("com.akeles.acc.config.error.isRequired", new String[]{this.getText("com.akeles.acc.config.quotaChecking.alertMessage")}));
        }
        if (this.allowUsersToViewSpaceQuota == null) {
            this.allowUsersToViewSpaceQuota = "off";
        }
        if (this.showSpaceQuotaTips == null) {
            this.showSpaceQuotaTips = "off";
        }
        this.spaceQuotaTipsText = this.spaceQuotaTipsText.trim();
        this.spaceQuotaTipsUrl = this.spaceQuotaTipsUrl.trim();
        if (this.spaceQuotaTipsUrl.length() > 0) {
            try {
                new URL(this.spaceQuotaTipsUrl).toURI();
            }
            catch (MalformedURLException | URISyntaxException exception) {
                this.addFieldError("spaceQuotaTipsUrlError", this.getText("com.akeles.acc.config.error.invalidUrl"));
            }
        }
    }

    private void validateAttachmentLogSettings() {
        logger.debug("Validating attachment log settings...");
        logger.debug("loggingMode: " + this.loggingMode);
        if (this.loggingMode == null) {
            this.loggingMode = "off";
        }
    }

    @ReadOnlyAccessBlocked
    public String doUpdate() {
        if (this.filterMode != null) {
            this.saveFileTypeBlockingSettings();
        } else if (this.fileSizeCheck != null) {
            this.saveFileSizeCheckingSettings();
        } else if (this.scannerPath != null) {
            this.saveVirusScanningSettings();
        } else if (this.defaultQuotaAllocated != null) {
            this.saveQuotaCheckingSettings();
        } else if (this.unauthorisedDownloadErrorMessage != null) {
            this.saveAttachmentPermissionsSettings();
        } else if (this.loggingMode != null) {
            this.saveAttachmentLogSettings();
        }
        return "success";
    }

    private void saveFileTypeBlockingSettings() {
        logger.debug("Filter mode [" + this.filterMode + "]");
        logger.debug("Extensions [" + this.extensions + "]");
        logger.debug("MIME type check [" + this.mimeTypeCheck + "]");
        logger.debug("Allow protected [" + this.allowProtected + "]");
        logger.debug("Allow encrypted [" + this.allowEncrypted + "]");
        logger.debug("Allow draw.io? [" + this.allowDrawIo + "]");
        logger.debug("Allow Table Spreadsheet Macro attachments? [" + this.allowTableSpreadsheetMacro + "]");
        logger.debug("Error message [" + this.errorMessage + "]");
        logger.debug("Saving file type blocking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.a(this.filterMode, this.extensions, this.mimeTypeCheck, this.errorMessage);
            this.attachmentCheckerConfig.a(this.allowFilesWithoutExtension, this.allowProtected, this.allowEncrypted, this.allowDrawIo, this.allowTableSpreadsheetMacro);
            return null;
        });
    }

    private void saveFileSizeCheckingSettings() {
        logger.debug("File size check [" + this.fileSizeCheck + "]");
        logger.debug("File size error message [" + this.fileSizeErrorMessage + "]");
        logger.debug("Saving file size checking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setFileSizeCheck(this.fileSizeCheck);
            this.attachmentCheckerConfig.setFileSizeErrorMessage(this.fileSizeErrorMessage);
            return null;
        });
    }

    private void saveVirusScanningSettings() {
        logger.debug("Missing file check [" + this.missingFileCheck + "]");
        logger.debug("Virus scanning [" + this.virusScanning + "]");
        logger.debug("Scanner path [" + this.scannerPath + "]");
        logger.debug("Scanner option [" + this.scannerOption + "]");
        logger.debug("Delete if infected? [" + this.deleteIfInfected + "]");
        logger.debug("Email if infected? [" + this.emailIfInfected + "]");
        logger.debug("Delete if error? [" + this.deleteIfError + "]");
        logger.debug("Email if error? [" + this.emailIfError + "]");
        logger.debug("Group to email (Confluence Sysadmin Group) [" + this.groupToEmail + "]");
        String string = this.getUserKey(this.virusAlertActor);
        logger.debug("Virus alert actor user key [" + string + "]");
        logger.debug("Saving virus scanning settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setMissingFileCheck(this.missingFileCheck);
            this.attachmentCheckerConfig.setVirusScanning(this.virusScanning);
            this.attachmentCheckerConfig.a(this.scannerPath, this.scannerOption);
            this.attachmentCheckerConfig.b(this.deleteIfInfected, this.emailIfInfected, this.deleteIfError, this.emailIfError);
            this.attachmentCheckerConfig.setGroupToEmail(this.groupToEmail);
            this.attachmentCheckerConfig.setVirusAlertActor(string);
            return null;
        });
        if (this.virusScanning.equalsIgnoreCase("off") && this.missingFileCheck.equalsIgnoreCase("off")) {
            this.jobScheduler.c();
            this.attachmentToScanService.a();
        } else {
            this.jobScheduler.a();
        }
    }

    private void saveQuotaCheckingSettings() {
        logger.debug("Quota check [" + this.quotaCheck + "]");
        logger.debug("Quota check error message [" + this.quotaCheckErrorMessage + "]");
        logger.debug("Default quota allocated [" + this.defaultQuotaAllocated + "] bytes");
        logger.debug("Default quota unit [" + this.defaultQuotaUnit + "]");
        logger.debug("Quota alert threshold [" + this.quotaAlertThreshold + "]");
        logger.debug("Quota alert message [" + this.quotaAlertMessage + "]");
        logger.debug("Allow users to view space quota? [" + this.allowUsersToViewSpaceQuota + "]");
        logger.debug("Show space quota tips? [" + this.showSpaceQuotaTips + "]");
        logger.debug("Space quota tips text [" + this.spaceQuotaTipsText + "]");
        logger.debug("Space quota tips URL [" + this.spaceQuotaTipsUrl + "]");
        logger.debug("Saving quota checking settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setQuotaCheck(this.quotaCheck);
            this.attachmentCheckerConfig.b(this.defaultQuotaAllocated, this.defaultQuotaUnit);
            this.attachmentCheckerConfig.setQuotaErrorMessage(this.quotaCheckErrorMessage);
            this.attachmentCheckerConfig.b(this.quotaAlertThreshold, this.quotaAlertMessage);
            this.attachmentCheckerConfig.setQuotaPermissions(this.allowUsersToViewSpaceQuota);
            this.attachmentCheckerConfig.a(this.showSpaceQuotaTips, this.spaceQuotaTipsText, this.spaceQuotaTipsUrl);
            return null;
        });
    }

    private void saveAttachmentPermissionsSettings() {
        logger.debug("Saving Attachment Permissions settings...");
        logger.debug("Unauthorised download error message [" + this.unauthorisedDownloadErrorMessage + "]");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setAttachmentPermissions(this.unauthorisedDownloadErrorMessage);
            return null;
        });
        logger.debug("Saved Attachment Permissions settings!");
    }

    private void saveAttachmentLogSettings() {
        logger.debug("Logging Mode [" + this.loggingMode + "]");
        logger.debug("Attachment Log Group [ " + this.attachmentLogGroup + " ]");
        logger.debug("Saving attachment logging mode settings...");
        this.transactionTemplate.execute(() -> {
            this.attachmentCheckerConfig.setAttachmentLogGroup(this.attachmentLogGroup);
            this.attachmentCheckerConfig.setAttachmentLog(this.loggingMode);
            return null;
        });
    }

    private String getUserKey(String string) {
        ConfluenceUser confluenceUser;
        String string2 = "";
        if (!string.isEmpty() && (confluenceUser = this.userAccessor.getUserByName(string)) != null) {
            string2 = confluenceUser.getKey().getStringValue();
        }
        logger.debug("Username [" + string + "] user key [" + string2 + "]");
        return string2;
    }
}

