/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import java.time.temporal.ChronoUnit;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.LicenseHelper");
    private final PluginLicenseManager b;
    private final SettingsManager c;

    @Autowired
    public LicenseHelper(@ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport SettingsManager settingsManager) {
        this.b = pluginLicenseManager;
        this.c = settingsManager;
    }

    public boolean a() {
        boolean bl = false;
        if (this.b.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.b.getLicense().get();
            bl = pluginLicense.isEvaluation();
        }
        return bl;
    }

    public boolean b() {
        boolean bl = false;
        String string = this.c.getGlobalSettings().getBaseUrl();
        if (string != null && string.contains("akeles")) {
            bl = true;
        } else {
            Option option = this.b.getLicense();
            if (option.isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)option.get();
                boolean bl2 = bl = !pluginLicense.getError().isDefined();
                if (bl && pluginLicense.isEvaluation()) {
                    DateTime dateTime = pluginLicense.getCreationDate();
                    a.debug((Object)("Evaluation license creation date [" + String.valueOf(dateTime) + "]"));
                    Option option2 = pluginLicense.getExpiryDate();
                    if (option2.isDefined()) {
                        DateTime dateTime2 = (DateTime)option2.get();
                        a.debug((Object)("Evaluation license expiry date [" + String.valueOf(dateTime2) + "]"));
                        long l = ChronoUnit.DAYS.between(dateTime.toDate().toInstant(), dateTime2.toDate().toInstant()) + 1L;
                        a.debug((Object)("Evaluation license duration is [" + l + "] days"));
                        bl = l <= 31L;
                    } else {
                        a.debug((Object)"Evaluation license expiry date is empty");
                        bl = false;
                    }
                }
            }
        }
        a.debug((Object)("Is license valid? [" + bl + "]"));
        return bl;
    }
}

