/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.servlet;

import com.akelesconsulting.confluence.plugins.ao.service.FileTypeViolationService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.utils.FileTypeViolationHelper;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class FileTypeViolationReportDownload
extends HttpServlet {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.servlet.FileTypeViolationReportDownload");
    private static final int b = 1000;
    private final FileTypeViolationHelper c;
    private final FileTypeViolationService d;
    private final I18nResolver e;
    private final LoginUriProvider f;
    private final PermissionManager g;
    private final VelocityHelperService h;

    public FileTypeViolationReportDownload(FileTypeViolationHelper fileTypeViolationHelper, FileTypeViolationService fileTypeViolationService, @ComponentImport I18nResolver i18nResolver, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PermissionManager permissionManager, @ComponentImport VelocityHelperService velocityHelperService) {
        this.c = fileTypeViolationHelper;
        this.d = fileTypeViolationService;
        this.e = i18nResolver;
        this.f = loginUriProvider;
        this.g = permissionManager;
        this.h = velocityHelperService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        a.debug((Object)"Download File Type Violation report");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            a.debug((Object)"User is not logged in");
            this.a(httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.g.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to download file type violation report"));
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("pageTitle", this.e.getText("com.akeles.acc.fileTypeViolationReport"));
                hashMap.put("errorTitle", this.e.getText("errors.occurred"));
                hashMap.put("errorMessage", this.e.getText("com.akeles.acc.fileTypeViolationReport.noDownloadPermission"));
                PrintWriter printWriter = httpServletResponse.getWriter();
                printWriter.write(this.h.getRenderedTemplate("templates/errorMessage.vm", hashMap));
                printWriter.close();
            }
            catch (IOException iOException) {
                a.error((Object)"Error generating response", (Throwable)iOException);
            }
            return;
        }
        try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
             ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            this.a(xSSFWorkbook);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string = new SimpleDateFormat("yyyyMMdd-HHmmss").format(timestamp);
            a.debug((Object)"Writing to response output stream");
            httpServletResponse.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            httpServletResponse.setHeader("Pragma", "private");
            httpServletResponse.setHeader("Cache-Control", "cache, must-revalidate");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=file-type-violation-report-" + string + ".xlsx");
            xSSFWorkbook.write((OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        catch (IOException iOException) {
            a.error((Object)"Error downloading quota summary", (Throwable)iOException);
        }
    }

    private void a(@NotNull XSSFWorkbook xSSFWorkbook) {
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet(this.e.getText("com.akeles.acc.fileTypeViolationReport"));
        XSSFRow xSSFRow = xSSFSheet.createRow(0);
        xSSFRow.createCell(0).setCellValue(this.e.getText("columnheading.creation.date"));
        xSSFRow.createCell(1).setCellValue(this.e.getText("heading.creator"));
        xSSFRow.createCell(2).setCellValue(this.e.getText("columnheading.name"));
        xSSFRow.createCell(3).setCellValue(this.e.getText("com.akeles.acc.version"));
        xSSFRow.createCell(4).setCellValue(this.e.getText("com.akeles.acc.extension"));
        xSSFRow.createCell(5).setCellValue(this.e.getText("com.akeles.acc.mimeType"));
        xSSFRow.createCell(6).setCellValue(this.e.getText("com.akeles.acc.violationType"));
        xSSFRow.createCell(7).setCellValue(this.e.getText("status.name"));
        xSSFRow.createCell(8).setCellValue(this.e.getText("space-key"));
        xSSFRow.createCell(9).setCellValue(this.e.getText("heading.page.space"));
        xSSFRow.createCell(10).setCellValue(this.e.getText("heading.page.title"));
        int n = this.d.getViolatedAttachmentTotalCount();
        int n2 = 1;
        for (int i = 0; i < n; i += 1000) {
            List<AttachmentBean> list = this.c.a(i, 1000, "");
            for (AttachmentBean attachmentBean : list) {
                a.debug((Object)("Creating row for violated attachment [" + attachmentBean.getFileName() + "]"));
                XSSFRow xSSFRow2 = xSSFSheet.createRow(n2);
                xSSFRow2.createCell(0).setCellValue(attachmentBean.getCreationDate());
                String string = attachmentBean.getCreator().getUsername();
                if (string.length() == 0) {
                    string = this.e.getText("anonymous.name");
                }
                xSSFRow2.createCell(1).setCellValue(string);
                xSSFRow2.createCell(2).setCellValue(attachmentBean.getFileName());
                xSSFRow2.createCell(3).setCellValue((double)attachmentBean.getVersion());
                xSSFRow2.createCell(4).setCellValue(attachmentBean.getExtension());
                xSSFRow2.createCell(5).setCellValue(attachmentBean.getMimeType());
                String string2 = this.a(attachmentBean);
                a.debug((Object)("Violation type [" + string2 + "]"));
                xSSFRow2.createCell(6).setCellValue(string2);
                xSSFRow2.createCell(7).setCellValue(attachmentBean.isInTrash() ? this.e.getText("com.akeles.acc.content.status.inTrash") : "");
                xSSFRow2.createCell(8).setCellValue(attachmentBean.getSpace().getKey());
                xSSFRow2.createCell(9).setCellValue(attachmentBean.getSpace().getName());
                xSSFRow2.createCell(10).setCellValue(attachmentBean.getPage().getTitle());
                ++n2;
            }
        }
        xSSFSheet.autoSizeColumn(0);
        xSSFSheet.autoSizeColumn(1);
        xSSFSheet.autoSizeColumn(2);
        xSSFSheet.autoSizeColumn(3);
        xSSFSheet.autoSizeColumn(4);
        xSSFSheet.autoSizeColumn(5);
        xSSFSheet.autoSizeColumn(6);
        xSSFSheet.autoSizeColumn(7);
        xSSFSheet.autoSizeColumn(8);
        xSSFSheet.autoSizeColumn(9);
        xSSFSheet.autoSizeColumn(10);
    }

    private String a(@NotNull AttachmentBean attachmentBean) {
        Object object = "";
        if (!attachmentBean.isExtensionValid()) {
            object = this.e.getText("com.akeles.acc.extension");
        }
        if (!attachmentBean.isMimeTypeValid()) {
            if (((String)object).length() > 0) {
                object = (String)object + ",";
            }
            object = (String)object + this.e.getText("com.akeles.acc.mimeType");
        }
        return object;
    }

    private void a(@NotNull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURL().toString());
            if (httpServletRequest.getQueryString() != null) {
                stringBuilder.append("?");
                stringBuilder.append(httpServletRequest.getQueryString());
            }
            URI uRI = URI.create(stringBuilder.toString());
            httpServletResponse.sendRedirect(this.f.getLoginUri(uRI).toString());
        }
        catch (IOException iOException) {
            a.error((Object)"Error redirecting to login", (Throwable)iOException);
        }
    }
}

