/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest.beans;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;

@XmlRootElement
public class SpaceQuotaBean
implements Serializable {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.rest.SpaceQuotaBean");
    @XmlElement
    private final String spaceKey;
    @XmlElement
    private final String spaceName;
    @XmlElement
    private String quotaUnit;
    @XmlElement
    private String quotaAllocated;
    @XmlElement
    private String quotaUsed;
    @XmlElement
    private String quotaAvailable;
    @XmlElement
    private String quotaUsage;
    @XmlElement
    private String quotaUsageColour;
    @XmlElement
    private boolean isQuotaDefault;
    @XmlElement
    private boolean isQuotaUnlimited;
    @XmlElement
    private boolean isQuotaUsageEmpty;
    @XmlElement
    private int allVersionsCount;
    @XmlElement
    private int currentVersionsCount;
    @XmlElement
    private String lastUpdateTime;
    @XmlElement
    private String nextUpdateTime;
    @XmlElement
    private boolean isAddedToQueue;

    public SpaceQuotaBean(String string, String string2) {
        this.spaceKey = string;
        this.spaceName = string2;
        this.quotaUsageColour = "green";
    }

    public String getQuotaAllocated() {
        return this.quotaAllocated;
    }

    public String getQuotaUsed() {
        return this.quotaUsed;
    }

    public String getQuotaAvailable() {
        return this.quotaAvailable;
    }

    public void setQuota(String string, String string2, String string3, String string4, boolean bl, boolean bl2, boolean bl3) {
        this.quotaUnit = string;
        this.quotaAllocated = string2;
        this.quotaUsed = string3;
        this.quotaAvailable = string4;
        this.isQuotaDefault = bl;
        this.isQuotaUnlimited = bl2;
        this.isQuotaUsageEmpty = bl3;
    }

    public void setQuotaUsage(long l, long l2, int n) {
        logger.debug((Object)"Calculating quota usage");
        BigDecimal bigDecimal = BigDecimal.valueOf(100L);
        try {
            logger.debug((Object)("Bytes allocated [" + l + "]"));
            logger.debug((Object)("Bytes used [" + l2 + "]"));
            BigDecimal bigDecimal2 = new BigDecimal(l2).multiply(bigDecimal).divide(new BigDecimal(l), 1, RoundingMode.HALF_UP);
            this.quotaUsage = bigDecimal2.toPlainString();
            logger.debug((Object)("Quota usage (%) [" + this.quotaUsage + "]"));
            if (bigDecimal2.compareTo(bigDecimal) >= 0) {
                this.quotaUsageColour = "red";
            } else if (n > 0 && bigDecimal2.compareTo(BigDecimal.valueOf(n)) >= 0) {
                this.quotaUsageColour = "orange";
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)"Error calculating percentage", (Throwable)numberFormatException);
        }
    }

    public String getQuotaUsageColour() {
        return this.quotaUsageColour;
    }

    public boolean getIsQuotaDefault() {
        return this.isQuotaDefault;
    }

    public boolean getIsQuotaUnlimited() {
        return this.isQuotaUnlimited;
    }

    public boolean getIsQuotaUsageEmpty() {
        return this.isQuotaUsageEmpty;
    }

    public void setAttachmentsCount(int n, int n2) {
        this.allVersionsCount = n;
        this.currentVersionsCount = n2;
    }

    public void setSchedule(String string, String string2, boolean bl) {
        this.lastUpdateTime = string;
        this.nextUpdateTime = string2;
        this.isAddedToQueue = bl;
    }

    public String toString() {
        return "SpaceQuotaBean {spaceKey='" + this.spaceKey + "', spaceName='" + this.spaceName + "', quotaUnit='" + this.quotaUnit + "', quotaAllocated='" + this.quotaAllocated + "', quotaUsed='" + this.quotaUsed + "', quotaAvailable='" + this.quotaAvailable + "', quotaUsage='" + this.quotaUsage + "', quotaUsageColour='" + this.quotaUsageColour + "', isQuotaDefault=" + this.isQuotaDefault + ", isQuotaUnlimited=" + this.isQuotaUnlimited + ", allVersionsCount=" + this.allVersionsCount + ", currentVersionsCount=" + this.currentVersionsCount + ", lastUpdateTime=" + this.lastUpdateTime + ", nextUpdateTime=" + this.nextUpdateTime + ", isAddedToQueue=" + this.isAddedToQueue + "}";
    }
}

