/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.service.FileTypeViolationService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceScannedService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledJobBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ScheduledTimeBean;
import com.akelesconsulting.confluence.plugins.scheduler.JobScheduler;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeViolationHelper;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.Serializable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/file-type-violation")
public class FileTypeViolationReportResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.FileTypeViolationReportResource");
    private static final int b = 50;
    private final AttachmentCheckerConfig c;
    private final DateHelper d;
    private final Gson e;
    private final I18nResolver f;
    private final JobScheduler g;
    private final LicenseHelper h;
    private final PermissionManager i;
    private final FileTypeViolationHelper j;
    private final FileTypeViolationService k;
    private final SettingsManager l;
    private final SpaceManager m;
    private final SpaceScannedService n;

    @Inject
    public FileTypeViolationReportResource(AttachmentCheckerConfig attachmentCheckerConfig, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, JobScheduler jobScheduler, LicenseHelper licenseHelper, @ComponentImport PermissionManager permissionManager, FileTypeViolationHelper fileTypeViolationHelper, FileTypeViolationService fileTypeViolationService, @ComponentImport SettingsManager settingsManager, @ComponentImport SpaceManager spaceManager, SpaceScannedService spaceScannedService) {
        this.c = attachmentCheckerConfig;
        this.d = dateHelper;
        this.e = new Gson();
        this.f = i18nResolver;
        this.g = jobScheduler;
        this.h = licenseHelper;
        this.i = permissionManager;
        this.j = fileTypeViolationHelper;
        this.k = fileTypeViolationService;
        this.l = settingsManager;
        this.m = spaceManager;
        this.n = spaceScannedService;
    }

    @GET
    @Path(value="/config")
    @Produces(value={"application/json"})
    public Response getConfig() {
        boolean bl;
        a.debug((Object)"Get file type violation scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get file type violation scanner config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ScheduledJobBean scheduledJobBean = new ScheduledJobBean();
        String string = this.c.getViolationScannerStartHour();
        String string2 = this.c.getViolationScannerStartMinute();
        String string3 = this.c.getViolationScannerStartAmPm();
        String string4 = this.c.getViolationScannerEndHour();
        String string5 = this.c.getViolationScannerEndMinute();
        String string6 = this.c.getViolationScannerEndAmPm();
        boolean bl2 = bl = !StringUtils.isEmpty((CharSequence)string);
        if (bl) {
            scheduledJobBean.setStartTime(string, string2, string3);
            scheduledJobBean.setEndTime(string4, string5, string6);
        }
        String string7 = this.d.a(string, string2, string3, string4, string5, string6, this.f.getText("com.akeles.acc.untilAllSpacesAreScanned"));
        scheduledJobBean.setScheduledTime(string7);
        int n = this.n.a("violation");
        int n2 = this.m.getSpaces(SpacesQuery.newQuery().build()).getAvailableSize();
        String string8 = this.f.getText("com.akeles.acc.scanStatus.spaceCount", new Serializable[]{Integer.valueOf(n), Integer.valueOf(n2)});
        scheduledJobBean.setStatus(string8, n, n2);
        boolean bl3 = this.c.A();
        boolean bl4 = this.c.B();
        a.debug((Object)("Is violation scan completed? [" + bl4 + "]"));
        Long l = this.c.getViolationScannerLastRun();
        String string9 = this.d.a(l, this.f.getText("com.akeles.acc.date.never"));
        String string10 = "-";
        boolean bl5 = this.h.a();
        scheduledJobBean.setIsEvaluationLicense(bl5);
        if (bl3) {
            a.debug((Object)"Violation scanner is running!");
            string10 = this.f.getText("com.akeles.acc.scanning");
        } else if (bl5 && this.k.getViolatedAttachmentTotalCount() > 0) {
            a.debug((Object)"Eval license detected! Purchase to continue scanning!");
            string10 = this.f.getText("com.akeles.acc.fileTypeViolationReport.purchaseLicenseToScan");
            scheduledJobBean.setIsEvaluationMessage(true);
        } else if (!bl4 && bl) {
            string10 = this.d.a(DateHelper.a(string, string2, string3), "");
            a.debug((Object)("Violation scanner is scheduled to run at [" + string10 + "]"));
        }
        scheduledJobBean.setLastRunDetails(string9, "", "");
        scheduledJobBean.setNextRunDetails(string10, "");
        scheduledJobBean.setJobStatus(bl, bl3);
        a.debug((Object)scheduledJobBean.toString());
        return Response.ok((Object)this.e.toJson((Object)scheduledJobBean)).build();
    }

    @POST
    @Path(value="/config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response a(ScheduledJobBean scheduledJobBean) {
        a.debug((Object)"Update file type violation scanner config");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to update file type violation scanner config"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.A();
        if (bl) {
            a.debug((Object)"File type violation scanner is running, config is not updated!");
        } else {
            ScheduledTimeBean scheduledTimeBean = scheduledJobBean.getStartTime();
            ScheduledTimeBean scheduledTimeBean2 = scheduledJobBean.getEndTime();
            this.c.c(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm(), scheduledTimeBean2.getHour(), scheduledTimeBean2.getMinute(), scheduledTimeBean2.getAmPm());
            this.g.c(DateHelper.a(scheduledTimeBean.getHour(), scheduledTimeBean.getMinute(), scheduledTimeBean.getAmPm()));
        }
        return this.getConfig();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug((Object)("Get list of ViolatedAttachment, start index [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get violated attachment list"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        String string = this.l.getGlobalSettings().getBaseUrl();
        resultBean.addAttachments(this.j.a(n, 50, string));
        int n2 = this.k.getViolatedAttachmentTotalCount();
        resultBean.setPagination(n, n2);
        resultBean.setIsEvaluationLicense(this.h.a());
        a.debug((Object)resultBean.toString());
        return Response.ok((Object)this.e.toJson((Object)resultBean)).build();
    }

    @POST
    @Path(value="/rescan")
    @Produces(value={"application/json"})
    public Response a() {
        a.debug((Object)"Trigger rescan for file type violation");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.i.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to trigger rescan for file type violation"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        boolean bl = this.c.A();
        if (bl) {
            a.debug((Object)"File type violation scanner is running, rescan is not triggered!");
        } else {
            this.k.a();
            this.n.c("violation");
            this.c.setIsViolationScanCompleted(false);
        }
        return this.getConfig();
    }
}

