/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.PageBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ResultBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceBean;
import com.akelesconsulting.confluence.plugins.rest.beans.UserBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Path(value="/scanning-queue")
public class AttachmentScanningQueueResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentScanningQueueResource");
    private static final int b = 50;
    private final AttachmentHelper c;
    private final AttachmentToScanService d;
    private final DateHelper e;
    private final Gson f;
    private final I18nResolver g;
    private final PermissionManager h;
    private final SettingsManager i;

    @Inject
    public AttachmentScanningQueueResource(AttachmentHelper attachmentHelper, AttachmentToScanService attachmentToScanService, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, PermissionManager permissionManager, @ComponentImport SettingsManager settingsManager) {
        this.c = attachmentHelper;
        this.d = attachmentToScanService;
        this.e = dateHelper;
        this.f = new Gson();
        this.g = i18nResolver;
        this.h = permissionManager;
        this.i = settingsManager;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response a(@QueryParam(value="startIndex") int n) {
        a.debug((Object)("Get list of AttachmentToScan, start index [" + n + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.h.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + String.valueOf(confluenceUser) + "] does not have admin permission to get scanning queue list"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ResultBean resultBean = new ResultBean(50);
        List<AttachmentToScan> list = this.d.a(n, 50);
        String string = this.i.getGlobalSettings().getBaseUrl();
        for (AttachmentToScan attachmentToScan : list) {
            Object object;
            long l = attachmentToScan.getAttachmentId();
            a.debug((Object)("Attachment id [" + l + "]"));
            int n2 = attachmentToScan.getVersion();
            Date date = attachmentToScan.getCreationDate();
            Attachment attachment = this.c.a(l, n2, date);
            if (attachment == null) {
                this.d.a(attachmentToScan);
                continue;
            }
            String string2 = attachment.getFileName();
            String string3 = AttachmentCheckerHelper.a(attachment.getFileSize(), 2);
            ContentEntityObject contentEntityObject = attachment.getContainer();
            long l2 = contentEntityObject == null ? 0L : contentEntityObject.getId();
            String string4 = this.c.a(attachment, l, n2, l2);
            AttachmentBean attachmentBean = new AttachmentBean(attachmentToScan.getID(), this.e.a(date, this.g.getText("com.akeles.acc.unknown")), attachmentToScan.getVersion(), string2, string3, string4);
            attachmentBean.setIsInTrash(attachment.isDeleted());
            attachmentBean.setCreator(this.a(attachment, string));
            Space space = attachment.getSpace();
            if (space != null) {
                object = new SpaceBean(space.getKey());
                ((SpaceBean)object).setName(space.getName());
                ((SpaceBean)object).setUrl(string + space.getUrlPath());
                attachmentBean.setSpace((SpaceBean)object);
            }
            if ((object = attachment.getContainer()) != null) {
                PageBean pageBean = new PageBean();
                pageBean.setTitle(object.getTitle());
                pageBean.setUrl(string + object.getAttachmentsUrlPath());
                attachmentBean.setPage(pageBean);
            }
            resultBean.addAttachment(attachmentBean);
        }
        int n3 = this.d.getAttachmentToScanCount();
        resultBean.setPagination(n, n3);
        a.debug((Object)resultBean.toString());
        return Response.ok((Object)this.f.toJson((Object)resultBean)).build();
    }

    @NotNull
    private UserBean a(@NotNull Attachment attachment, String string) {
        UserBean userBean;
        ConfluenceUser confluenceUser = attachment.getCreator();
        if (confluenceUser != null) {
            userBean = new UserBean(confluenceUser.getKey().getStringValue());
            userBean.setDisplayName(confluenceUser.getFullName());
            userBean.setUsername(confluenceUser.getName());
            userBean.setUrl(string + "/display/~" + confluenceUser.getName());
        } else {
            userBean = new UserBean("");
        }
        return userBean;
    }
}

