/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config.xwork;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.LicenseHelper;
import com.atlassian.confluence.pages.actions.SpaceToolsAction;
import com.atlassian.confluence.user.ConfluenceUser;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SpaceQuotaManager
extends SpaceToolsAction {
    private static final Logger logger = Logger.getLogger((String)"com.akeles.plugins.acc.config.SpaceQuotaManager");
    private static final String DEFAULT_TIPS_TEXT_I18N_KEY = "com.akeles.acc.spaceQuota.defaultTipsText";
    private static final String DEFAULT_SPACE_QUOTA_TIPS_URL = "https://docs.akeles.com/acc/checklist-for-confluence-space-admins-to-housekeep";
    private transient AttachmentCheckerConfig attachmentCheckerConfig;
    private transient LicenseHelper licenseHelper;
    private boolean isQuotaUsageViewable;
    private boolean hasViewPermission;
    private boolean showTips;
    private String tipsText;
    private String tipsUrl;

    public void setAttachmentCheckerConfig(AttachmentCheckerConfig attachmentCheckerConfig) {
        this.attachmentCheckerConfig = attachmentCheckerConfig;
    }

    public void setLicenseHelper(LicenseHelper licenseHelper) {
        this.licenseHelper = licenseHelper;
    }

    public String getQuotaUnit() {
        return this.attachmentCheckerConfig.getUnit();
    }

    public boolean getIsQuotaUsageViewable() {
        return this.isQuotaUsageViewable;
    }

    public boolean getHasViewPermission() {
        return this.hasViewPermission;
    }

    public boolean getShowTips() {
        return this.showTips;
    }

    public String getTipsText() {
        return this.tipsText;
    }

    public String getTipsUrl() {
        return this.tipsUrl;
    }

    public String execute() {
        logger.debug((Object)("Loading Space Quota for space key [" + this.key + "]"));
        if (this.space == null) {
            logger.debug((Object)("Space not found [" + this.key + "]"));
            return "notfound";
        }
        if (this.licenseHelper.b()) {
            logger.debug((Object)"License is valid!");
            ConfluenceUser confluenceUser = this.getAuthenticatedUser();
            this.isQuotaUsageViewable = this.attachmentCheckerConfig.e(this.key);
            logger.debug((Object)("Is quota usage viewable? [" + this.isQuotaUsageViewable + "]"));
            this.hasViewPermission = this.attachmentCheckerConfig.a(confluenceUser, this.space);
            logger.debug((Object)("User [" + String.valueOf(confluenceUser) + "] has permission to view space quota? [" + this.hasViewPermission + "]"));
            this.tipsText = this.attachmentCheckerConfig.getSpaceQuotaTipsText();
            this.tipsUrl = this.attachmentCheckerConfig.getSpaceQuotaTipsUrl();
            this.showTips = this.attachmentCheckerConfig.t();
            if (StringUtils.isEmpty((CharSequence)this.tipsText) && StringUtils.isEmpty((CharSequence)this.tipsUrl)) {
                this.tipsText = this.getText(DEFAULT_TIPS_TEXT_I18N_KEY);
                this.tipsUrl = DEFAULT_SPACE_QUOTA_TIPS_URL;
            } else if (StringUtils.isEmpty((CharSequence)this.tipsText)) {
                this.tipsText = this.getText("com.akeles.acc.learnMore");
            }
            logger.debug((Object)("Show tips? [" + this.showTips + "]"));
            logger.debug((Object)("Tips text [" + this.tipsText + "]"));
            logger.debug((Object)("Tips URL [" + this.tipsUrl + "]"));
            return "success";
        }
        logger.debug((Object)"License is invalid!");
        return "unlicensed";
    }
}

