/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceInfoService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.SpaceInfoService");
    private static final int b = 1;
    private static final int c = 2;
    private static final int d = 3;
    private final ActiveObjects e;
    private final AttachmentManager f;
    private final PageManager g;
    private final SpaceManager h;
    private final TransactionTemplate i;

    @Autowired
    public SpaceInfoService(@ComponentImport ActiveObjects activeObjects, @ComponentImport AttachmentManager attachmentManager, @ComponentImport PageManager pageManager, @ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.e = activeObjects;
        this.f = attachmentManager;
        this.g = pageManager;
        this.h = spaceManager;
        this.i = transactionTemplate;
    }

    public SpaceInfo a(String string) {
        a.debug((Object)("Get SpaceInfo for space [" + string + "]"));
        return (SpaceInfo)this.e.get(SpaceInfo.class, (Object)string);
    }

    public void a(@NotNull Space space) {
        String string = space.getKey();
        a.debug((Object)("Get SpaceInfo for space [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null || spaceInfo.getStorageUsed() == -1L || spaceInfo.getStatus() == 3) {
            long l = 0L;
            int n = 0;
            int n2 = 0;
            for (Long l2 : this.g.getPageIds(space)) {
                ContentEntityObject contentEntityObject = this.g.getById(l2.longValue());
                if (contentEntityObject == null) continue;
                n += this.f.getAllVersionsOfAttachments(contentEntityObject).size();
                n2 += this.f.countLatestVersionsOfAttachments(contentEntityObject);
                List list = contentEntityObject.getAttachments();
                for (Attachment attachment : list) {
                    l += attachment.getFileSize();
                }
            }
            a.debug((Object)("Quota used (bytes) [" + l + "]"));
            a.debug((Object)("All versions count [" + n + "]"));
            a.debug((Object)("Current versions count [" + n2 + "]"));
            if (spaceInfo == null) {
                a.debug((Object)("SpaceInfo not found for space [" + string + "]"));
                this.a(string, l, n, n2);
            } else {
                a.debug((Object)("Update quota usage for space [" + string + "]"));
                this.a(spaceInfo, l, n, n2);
            }
        }
    }

    private void a(String string, long l, int n, int n2) {
        a.debug((Object)("Create SpaceInfo for space [" + string + "]"));
        this.i.execute(() -> (SpaceInfo)this.e.create(SpaceInfo.class, new DBParam[]{new DBParam("SPACE_KEY", (Object)string), new DBParam("STORAGE_ALLOCATED", (Object)-1L), new DBParam("STORAGE_USED", (Object)l), new DBParam("ALL_VERSIONS_COUNT", (Object)n), new DBParam("CURRENT_VERSIONS_COUNT", (Object)n2), new DBParam("LAST_UPDATED", (Object)new Date()), new DBParam("STATUS", (Object)1)}));
        a.debug((Object)("Created SpaceInfo for space [" + string + "]"));
    }

    public List<Space> getSpaceList() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().sortBy("key").build();
        ListBuilder listBuilder = this.h.getSpaces(spacesQuery);
        return listBuilder.getAvailableSize() > 0 ? listBuilder.getRange(0, listBuilder.getAvailableSize() - 1) : new ArrayList<Space>();
    }

    public int getSpaceCount() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().build();
        return this.h.getSpaces(spacesQuery).getAvailableSize();
    }

    public int getSpaceInfoCount() {
        return this.e.count(SpaceInfo.class);
    }

    public int getSpaceInfoNotPurgedCount() {
        return this.e.count(SpaceInfo.class, Query.select().where("STORAGE_USED != ?", new Object[]{-1L}));
    }

    public int getSpaceInfoCalculatedCount() {
        return this.e.count(SpaceInfo.class, Query.select().where("STATUS != ? AND STORAGE_USED != ?", new Object[]{3, -1L}));
    }

    public int getSpaceInfoRecalculatedCount() {
        return this.e.count(SpaceInfo.class, Query.select().where("STATUS = ?", new Object[]{2}));
    }

    public int getSpaceInfoPendingRecalculationCount() {
        return this.e.count(SpaceInfo.class, Query.select().where("STATUS = ?", new Object[]{3}));
    }

    public void a(String string, long l) {
        a.debug((Object)("Update quota allocated for space [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            this.i.execute(() -> {
                spaceInfo.setStorageAllocated(l);
                spaceInfo.save();
                return null;
            });
            a.debug((Object)("Updated quota allocated (bytes) [" + spaceInfo.getStorageAllocated() + "]"));
        } else {
            a.debug((Object)("SpaceInfo not found [" + string + "]"));
        }
    }

    public void a(String string, String string2, long l) {
        this.i.execute(() -> {
            this.a(string, l, true);
            this.a(string2, l, false);
            return null;
        });
    }

    public void a(String string, long l, boolean bl) {
        a.debug((Object)"*** Update quota used ***");
        a.debug((Object)("Space key [" + string + "]"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            long l2 = spaceInfo.getStorageUsed();
            a.debug((Object)("Current [" + l2 + "] bytes"));
            if (l2 == -1L) {
                a.debug((Object)("Quota used for space [" + string + "] has been purged, skip update"));
                return;
            }
            long l3 = bl ? l2 - l : l2 + l;
            this.i.execute(() -> {
                spaceInfo.setStorageUsed(l3);
                spaceInfo.save();
                return null;
            });
            a.debug((Object)("Updated to [" + spaceInfo.getStorageUsed() + "] bytes used"));
        }
    }

    public void a() {
        SpaceInfo[] spaceInfoArray;
        a.debug((Object)"Update all SpaceInfo status to pending recalculation...");
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.e.find(SpaceInfo.class)) {
            this.i.execute(() -> {
                spaceInfo.setStatus(3);
                spaceInfo.save();
                return null;
            });
        }
        a.debug((Object)"Update done!");
    }

    public void b(String string) {
        a.debug((Object)("*** Delete SpaceInfo [" + string + "] ***"));
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo != null) {
            this.i.execute(() -> {
                this.e.delete(new RawEntity[]{spaceInfo});
                return null;
            });
            a.debug((Object)"SpaceInfo deleted");
        }
    }

    public void b() {
        SpaceInfo[] spaceInfoArray;
        a.debug((Object)"Delete SpaceInfo if Space not found...");
        for (SpaceInfo spaceInfo : spaceInfoArray = (SpaceInfo[])this.e.find(SpaceInfo.class)) {
            String string = spaceInfo.getSpaceKey();
            a.debug((Object)("Checking space key [" + string + "]"));
            if (this.h.getSpace(string) != null) continue;
            a.debug((Object)("Space [" + string + "] not found, deleting SpaceInfo."));
            this.i.execute(() -> {
                this.e.delete(new RawEntity[]{spaceInfo});
                return null;
            });
        }
    }

    public void c(String string) {
        a.debug((Object)("Update attachments count for space [" + string + "]"));
        Space space = this.h.getSpace(string);
        if (space == null) {
            a.debug((Object)("Space not found [" + string + "]"));
            return;
        }
        SpaceInfo spaceInfo = this.a(string);
        if (spaceInfo == null) {
            a.debug((Object)("SpaceInfo not found [" + string + "]"));
            return;
        }
        int n = 0;
        int n2 = 0;
        for (Long l : this.g.getPageIds(space)) {
            ContentEntityObject contentEntityObject = this.g.getById(l.longValue());
            if (contentEntityObject == null) continue;
            n += this.f.getAllVersionsOfAttachments(contentEntityObject).size();
            n2 += this.f.countLatestVersionsOfAttachments(contentEntityObject);
        }
        a.debug((Object)("All versions count [" + n + "]"));
        a.debug((Object)("Current versions count [" + n2 + "]"));
        this.a(spaceInfo, n, n2);
    }

    private void a(@NotNull SpaceInfo spaceInfo, long l, int n, int n2) {
        a.debug((Object)"Update SpaceInfo quota used and attachments count");
        int n3 = spaceInfo.getStorageUsed() == -1L ? 1 : 2;
        this.i.execute(() -> {
            spaceInfo.setStorageUsed(l);
            spaceInfo.setAllVersionsCount(n);
            spaceInfo.setCurrentVersionsCount(n2);
            spaceInfo.setLastUpdated(new Date());
            spaceInfo.setStatus(n3);
            spaceInfo.save();
            return null;
        });
        a.debug((Object)"Updated quota used and attachments count!");
    }

    private void a(SpaceInfo spaceInfo, int n, int n2) {
        a.debug((Object)"Update SpaceInfo attachments count");
        this.i.execute(() -> {
            spaceInfo.setAllVersionsCount(n);
            spaceInfo.setCurrentVersionsCount(n2);
            spaceInfo.setLastUpdated(new Date());
            spaceInfo.save();
            return null;
        });
        a.debug((Object)"Updated attachments count!");
    }
}

