/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.MissingAttachment;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class MissingAttachmentService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.MissingAttachmentService");
    private final ActiveObjects b;
    private final AttachmentHelper c;
    private final AttachmentManager d;
    private final TransactionTemplate e;

    public MissingAttachmentService(@ComponentImport ActiveObjects activeObjects, AttachmentHelper attachmentHelper, @ComponentImport AttachmentManager attachmentManager, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = activeObjects;
        this.c = attachmentHelper;
        this.d = attachmentManager;
        this.e = transactionTemplate;
    }

    public int getMissingAttachmentTotalCount() {
        return this.b.count(MissingAttachment.class);
    }

    public List<MissingAttachment> getAllMissingAttachment() {
        return Arrays.asList((MissingAttachment[])this.b.find(MissingAttachment.class));
    }

    public List<MissingAttachment> a(int n, int n2) {
        a.debug((Object)("Get list of MissingAttachment, startIndex [" + n + "]"));
        ArrayList<MissingAttachment> arrayList = new ArrayList<MissingAttachment>(Arrays.asList((MissingAttachment[])this.b.find(MissingAttachment.class, Query.select().order("CREATION_DATE DESC").offset(n).limit(n2))));
        boolean bl = this.a(arrayList);
        int n3 = this.b.count(MissingAttachment.class);
        int n4 = arrayList.size();
        a.debug((Object)("MissingAttachment count [" + n3 + "]"));
        a.debug((Object)("MissingAttachment list size [" + n4 + "]"));
        a.debug((Object)("Is one or more MissingAttachment deleted or restored? [" + bl + "]"));
        while (bl) {
            arrayList = new ArrayList<MissingAttachment>(Arrays.asList((MissingAttachment[])this.b.find(MissingAttachment.class, Query.select().order("CREATION_DATE DESC").offset(n).limit(n2))));
            bl = this.a(arrayList);
            n3 = this.b.count(MissingAttachment.class);
            n4 = arrayList.size();
            a.debug((Object)("MissingAttachment count [" + n3 + "]"));
            a.debug((Object)("MissingAttachment list size [" + n4 + "]"));
            a.debug((Object)("Is one or more MissingAttachment deleted or restored? [" + bl + "]"));
        }
        return arrayList;
    }

    private boolean a(@NotNull List<MissingAttachment> list) {
        a.debug((Object)"Remove MissingAttachment if attachment deleted or restored");
        return list.removeIf(missingAttachment -> {
            Date date;
            int n;
            long l = missingAttachment.getAttachmentId();
            Attachment attachment = this.c.a(l, n = missingAttachment.getVersion(), date = missingAttachment.getCreationDate());
            boolean bl = attachment == null;
            boolean bl2 = attachment != null && this.d.getAttachmentData(attachment) != null;
            a.debug((Object)("Is attachment id [" + l + "] deleted? [" + bl + "]"));
            a.debug((Object)("Is attachment id [" + l + "] data restored? [" + bl2 + "]"));
            if (bl || bl2) {
                this.a((MissingAttachment)missingAttachment);
            }
            return bl || bl2;
        });
    }

    public MissingAttachment a(int n) {
        return (MissingAttachment)this.b.get(MissingAttachment.class, (Object)n);
    }

    public void a() {
        this.e.execute(() -> {
            this.b.deleteWithSQL(MissingAttachment.class, "ID > 0", new Object[0]);
            return null;
        });
    }

    public void a(String string) {
        this.e.execute(() -> {
            this.b.deleteWithSQL(MissingAttachment.class, "SPACE_KEY = ?", new Object[]{string});
            return null;
        });
    }

    public void a(MissingAttachment missingAttachment) {
        this.e.execute(() -> {
            if (missingAttachment != null) {
                this.b.delete(new RawEntity[]{missingAttachment});
            }
            return null;
        });
    }

    public void a(@NotNull Attachment attachment) {
        long l = attachment.getLatestVersionId();
        int n = attachment.getVersion();
        String string = attachment.getSpaceKey();
        Date date = DateHelper.a(attachment.getCreationDate());
        try {
            MissingAttachment missingAttachment = (MissingAttachment)this.e.execute(() -> (MissingAttachment)this.b.create(MissingAttachment.class, new DBParam[]{new DBParam("ATTACHMENT_ID", (Object)l), new DBParam("VERSION", (Object)n), new DBParam("CREATION_DATE", (Object)date), new DBParam("SPACE_KEY", (Object)string)}));
            a.debug((Object)("Created MissingAttachment id [" + missingAttachment.getID() + "]"));
            a.debug((Object)("Attachment id [" + l + "]"));
            a.debug((Object)("Version [" + n + "]"));
            a.debug((Object)("Creation date [" + String.valueOf(date) + "]"));
        }
        catch (Exception exception) {
            a.error((Object)"Exception creating MissingAttachment", (Throwable)exception);
        }
    }
}

