/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentToScanService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.AttachmentToScanService");
    private static final String b = "CREATION_DATE ASC";
    private final ActiveObjects c;
    private final AttachmentHelper d;
    private final TransactionTemplate e;

    @Autowired
    public AttachmentToScanService(@ComponentImport ActiveObjects activeObjects, AttachmentHelper attachmentHelper, @ComponentImport TransactionTemplate transactionTemplate) {
        this.c = activeObjects;
        this.d = attachmentHelper;
        this.e = transactionTemplate;
    }

    public int getAttachmentToScanCount() {
        return (Integer)this.e.execute(() -> this.c.count(AttachmentToScan.class));
    }

    public int a(String string) {
        return (Integer)this.e.execute(() -> this.c.count(AttachmentToScan.class, Query.select().where("ASSIGNED_NODE_ID = ?", new Object[]{string})));
    }

    public List<AttachmentToScan> a(int n, int n2) {
        ArrayList<AttachmentToScan> arrayList;
        boolean bl;
        a.debug((Object)("Get list of AttachmentToScan, startIndex [" + n + "]"));
        do {
            arrayList = new ArrayList<AttachmentToScan>(Arrays.asList((AttachmentToScan[])this.c.find(AttachmentToScan.class, Query.select().order("ID DESC").offset(n).limit(n2))));
            bl = this.b(arrayList);
            int n3 = this.c.count(AttachmentToScan.class);
            int n4 = arrayList.size();
            a.debug((Object)("AttachmentToScan count [" + n3 + "]"));
            a.debug((Object)("AttachmentToScan list size [" + n4 + "]"));
            a.debug((Object)("Is one or more AttachmentToScan deleted or restored? [" + bl + "]"));
        } while (bl);
        return arrayList;
    }

    private boolean b(@NotNull List<AttachmentToScan> list) {
        a.debug((Object)"Remove AttachmentToScan if attachment deleted");
        return list.removeIf(attachmentToScan -> {
            Date date;
            int n;
            long l = attachmentToScan.getAttachmentId();
            Attachment attachment = this.d.a(l, n = attachmentToScan.getVersion(), date = attachmentToScan.getCreationDate());
            boolean bl = attachment == null;
            a.debug((Object)("Is attachment id [" + l + "] deleted? [" + bl + "]"));
            if (bl) {
                this.a((AttachmentToScan)attachmentToScan);
            }
            return bl;
        });
    }

    public List<AttachmentToScan> a(@NotNull List<String> list) {
        a.debug((Object)"Get AttachmentToScan for reassignment");
        String string = list.stream().map(Functions.constant((Object)"?")).collect(Collectors.joining(", "));
        a.debug((Object)("Placeholder [" + string + "]"));
        Object[] objectArray = list.toArray();
        a.debug((Object)("Node ID array [" + Arrays.toString(objectArray) + "]"));
        AttachmentToScan[] attachmentToScanArray = (AttachmentToScan[])this.e.execute(() -> (AttachmentToScan[])this.c.find(AttachmentToScan.class, Query.select().where("ASSIGNED_NODE_ID IN (" + string + ")", objectArray).order(b)));
        return Arrays.asList(attachmentToScanArray);
    }

    public List<AttachmentToScan> getAttachmentsToAssign() {
        a.debug((Object)"Get AttachmentToScan for assignment");
        AttachmentToScan[] attachmentToScanArray = (AttachmentToScan[])this.e.execute(() -> (AttachmentToScan[])this.c.find(AttachmentToScan.class, Query.select().where("ASSIGNED_NODE_ID IS NULL", new Object[0]).order(b).limit(100)));
        return Arrays.asList(attachmentToScanArray);
    }

    public void a(AttachmentToScan attachmentToScan, String string) {
        this.e.execute(() -> {
            attachmentToScan.setAssignedNodeId(string);
            attachmentToScan.save();
            return null;
        });
    }

    public AttachmentToScan[] getAttachmentToScan() {
        a.debug((Object)"Get AttachmentToScan order by CREATION_DATE ASC limit 100");
        return (AttachmentToScan[])this.e.execute(() -> (AttachmentToScan[])this.c.find(AttachmentToScan.class, Query.select().order(b).limit(100)));
    }

    public AttachmentToScan[] b(String string) {
        a.debug((Object)("Get AttachmentToScan order by CREATION_DATE ASC limit 100 assigned to node id [" + string + "]"));
        return (AttachmentToScan[])this.e.execute(() -> (AttachmentToScan[])this.c.find(AttachmentToScan.class, Query.select().where("ASSIGNED_NODE_ID = ?", new Object[]{string}).order(b).limit(100)));
    }

    public AttachmentToScan a(long l, int n, Date date, long l2) {
        a.debug((Object)("Creating AttachmentToScan entity for attachment id [" + l + "]"));
        try {
            AttachmentToScan attachmentToScan = (AttachmentToScan)this.e.execute(() -> (AttachmentToScan)this.c.create(AttachmentToScan.class, new DBParam[]{new DBParam("ATTACHMENT_ID", (Object)l), new DBParam("VERSION", (Object)n), new DBParam("ATTACHED_TO_ID", (Object)l2), new DBParam("CREATION_DATE", (Object)date)}));
            a.debug((Object)("Created AttachmentToScan entity with id [" + attachmentToScan.getID() + "] for attachment id [" + l + "] version [" + n + "] creation date [" + String.valueOf(date) + "] attached to id [" + l2 + "]"));
            return attachmentToScan;
        }
        catch (Exception exception) {
            a.error((Object)"Error creating AttachmentToScan entity", (Throwable)exception);
            return null;
        }
    }

    public void a(AttachmentToScan attachmentToScan) {
        int n = attachmentToScan.getID();
        a.debug((Object)("Deleting AttachmentToScan entity with id [" + n + "]"));
        try {
            this.e.execute(() -> {
                this.c.delete(new RawEntity[]{attachmentToScan});
                return null;
            });
            a.debug((Object)("Deleted AttachmentToScan entity with id [" + n + "]"));
        }
        catch (Exception exception) {
            a.error((Object)"Error deleting AttachmentToScan entity", (Throwable)exception);
        }
    }

    public void a() {
        a.debug((Object)"Delete all AttachmentToScan");
        try {
            a.debug((Object)("Deleting [" + this.c.count(AttachmentToScan.class) + "] AttachmentToScan"));
            this.e.execute(() -> {
                this.c.deleteWithSQL(AttachmentToScan.class, "ID > 0", new Object[0]);
                return null;
            });
            a.debug((Object)"Delete completed!");
        }
        catch (Exception exception) {
            a.error((Object)"Error deleting AttachmentToScan", (Throwable)exception);
        }
    }
}

