/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.AssignedNode;
import com.akelesconsulting.confluence.plugins.ao.entity.VirusScanError;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AssignedNodeService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.AssignedNodeService");
    private final ActiveObjects b;
    private final TransactionTemplate c;

    @Inject
    public AssignedNodeService(@ComponentImport ActiveObjects activeObjects, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = activeObjects;
        this.c = transactionTemplate;
    }

    public boolean a() {
        a.debug((Object)"Checking status...");
        boolean bl = false;
        for (AssignedNode assignedNode : this.getAllAssignedNodes()) {
            String string = assignedNode.getErrorIds();
            a.debug((Object)("Node ID [" + assignedNode.getNodeId() + "] error ids [" + string + "]"));
            if (string == null || string.isEmpty()) continue;
            bl = true;
            break;
        }
        a.debug((Object)("Has error? [" + bl + "]"));
        return bl;
    }

    public boolean b() {
        a.debug((Object)"Checking for paused nodes...");
        AssignedNode[] assignedNodeArray = (AssignedNode[])this.c.execute(() -> (AssignedNode[])this.b.find(AssignedNode.class, Query.select().where("IS_PAUSED = ?", new Object[]{true})));
        a.debug((Object)("Paused nodes count [" + assignedNodeArray.length + "]"));
        return assignedNodeArray.length > 0;
    }

    public List<AssignedNode> getAllAssignedNodes() {
        return (List)this.c.execute(() -> Arrays.asList((AssignedNode[])this.b.find(AssignedNode.class)));
    }

    public AssignedNode a(String string) {
        AssignedNode assignedNode;
        a.debug((Object)("Get AssignedNode for node id [" + string + "]"));
        AssignedNode[] assignedNodeArray = (AssignedNode[])this.c.execute(() -> (AssignedNode[])this.b.find(AssignedNode.class, string == null || string.isEmpty() ? Query.select().where("NODE_ID IS NULL", new Object[0]) : Query.select().where("NODE_ID = ?", new Object[]{string})));
        if (assignedNodeArray.length == 0) {
            int n = this.e(string);
            assignedNode = (AssignedNode)this.c.execute(() -> (AssignedNode)this.b.get(AssignedNode.class, (Object)n));
        } else {
            assignedNode = assignedNodeArray[0];
        }
        return assignedNode;
    }

    public void a(int n, int n2) {
        this.c.execute(() -> {
            AssignedNode assignedNode = (AssignedNode)this.b.get(AssignedNode.class, (Object)n);
            if (assignedNode != null) {
                String string = assignedNode.getNodeId();
                a.debug((Object)("Updating last queue count for node id [" + string + "]"));
                a.debug((Object)("Current last queue count [" + assignedNode.getLastQueueCount() + "]"));
                assignedNode.setLastQueueCount(n2);
                assignedNode.save();
                a.debug((Object)("Updated last queue count [" + n2 + "]"));
            }
            return null;
        });
    }

    public void a(@NotNull List<AssignedNode> list) {
        for (AssignedNode assignedNode : list) {
            this.c.execute(() -> {
                String string = assignedNode.getNodeId();
                a.debug((Object)("Increasing bucket size for node id [" + string + "]"));
                int n = assignedNode.getBucketSize();
                a.debug((Object)("Current bucket size [" + n + "]"));
                if (n < 100) {
                    int n2 = n + 10;
                    assignedNode.setBucketSize(n2);
                    assignedNode.save();
                    a.debug((Object)("Updated bucket size [" + n2 + "]"));
                } else {
                    a.debug((Object)"Bucket size is already at maximum 100.");
                }
                return null;
            });
        }
    }

    public void b(@NotNull List<AssignedNode> list) {
        for (AssignedNode assignedNode : list) {
            this.c.execute(() -> {
                String string = assignedNode.getNodeId();
                a.debug((Object)("Decreasing bucket size for node id [" + string + "]"));
                int n = assignedNode.getBucketSize();
                a.debug((Object)("Current bucket size [" + n + "]"));
                if (n > 10) {
                    int n2 = n - 10;
                    assignedNode.setBucketSize(n2);
                    assignedNode.save();
                    a.debug((Object)("Updated bucket size [" + n2 + "]"));
                } else {
                    a.debug((Object)"Bucket size is already at minimum 10.");
                }
                return null;
            });
        }
    }

    private int e(String string) {
        int n = 0;
        try {
            n = (Integer)this.c.execute(() -> {
                AssignedNode assignedNode = (AssignedNode)this.b.create(AssignedNode.class, new DBParam[]{new DBParam("NODE_ID", (Object)string), new DBParam("BUCKET_SIZE", (Object)10), new DBParam("LAST_QUEUE_COUNT", (Object)0)});
                a.debug((Object)("Created AssignedNode id [" + assignedNode.getID() + "]"));
                a.debug((Object)("Node id [" + string + "] bucket size [" + assignedNode.getBucketSize() + "]"));
                return assignedNode.getID();
            });
        }
        catch (Exception exception) {
            a.error((Object)"Exception creating AssignedNode", (Throwable)exception);
        }
        return n;
    }

    public boolean b(String string) {
        boolean bl = false;
        AssignedNode assignedNode = this.a(string);
        if (assignedNode != null) {
            bl = assignedNode.getIsPaused();
        }
        return bl;
    }

    public List<Integer> c(String string) {
        List<Integer> list = new ArrayList<Integer>();
        AssignedNode assignedNode = this.a(string);
        if (assignedNode != null) {
            String string2 = (String)this.c.execute(assignedNode::getErrorIds);
            if (string2 != null) {
                list = Arrays.stream(string2.split(",")).map(Integer::valueOf).collect(Collectors.toList());
            }
        }
        return list;
    }

    public boolean a(String string, Integer n) {
        a.debug((Object)("Update errors for node ID [" + string + "]"));
        boolean bl = false;
        AssignedNode assignedNode = this.a(string);
        if (assignedNode != null && n != null) {
            bl = (Boolean)this.c.execute(() -> {
                List<Object> list = new ArrayList<Integer>();
                String string = assignedNode.getErrorIds();
                a.debug((Object)("Current errors [" + string + "]"));
                if (string != null && !string.isEmpty()) {
                    list = Arrays.stream(string.split(",")).map(Integer::valueOf).collect(Collectors.toList());
                }
                list.add(0, n);
                if (list.size() >= 5) {
                    list = list.subList(0, 5);
                    VirusScanError virusScanError = (VirusScanError)this.b.get(VirusScanError.class, (Object)((Integer)list.get(0)));
                    VirusScanError virusScanError2 = (VirusScanError)this.b.get(VirusScanError.class, (Object)((Integer)list.get(4)));
                    long l = virusScanError.getCreationDate().getTime() - virusScanError2.getCreationDate().getTime();
                    if (l <= 1800000L) {
                        assignedNode.setIsPaused(true);
                    }
                }
                assignedNode.setErrorIds(list.stream().map(String::valueOf).collect(Collectors.joining(",")));
                assignedNode.save();
                a.debug((Object)("Updated errors [" + assignedNode.getErrorIds() + "]"));
                return assignedNode.getIsPaused();
            });
        }
        a.debug((Object)("Is paused? [" + bl + "]"));
        return bl;
    }

    public void d(String string) {
        AssignedNode assignedNode = this.a(string);
        if (assignedNode != null) {
            this.c.execute(() -> {
                assignedNode.setErrorIds(null);
                assignedNode.setIsPaused(false);
                assignedNode.save();
                return null;
            });
        }
    }
}

