/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest;

import com.akelesconsulting.confluence.plugins.ao.entity.AssignedNode;
import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.entity.VirusScanError;
import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.ao.service.VirusScanErrorService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.AlertBannerBean;
import com.akelesconsulting.confluence.plugins.rest.beans.NodeStatusBean;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Path(value="/scanning-status")
public class AttachmentScanningStatusResource {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.rest.AttachmentScanningStatusResource");
    private final AssignedNodeService b;
    private final AttachmentCheckerConfig c;
    private final AttachmentToScanService d;
    private final ClusterManager e;
    private final Gson f;
    private final I18nResolver g;
    private final PermissionManager h;
    private final VirusScanErrorService i;

    @Inject
    public AttachmentScanningStatusResource(AssignedNodeService assignedNodeService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentToScanService attachmentToScanService, @ComponentImport ClusterManager clusterManager, @ComponentImport I18nResolver i18nResolver, @ComponentImport PermissionManager permissionManager, VirusScanErrorService virusScanErrorService) {
        this.b = assignedNodeService;
        this.c = attachmentCheckerConfig;
        this.d = attachmentToScanService;
        this.e = clusterManager;
        this.f = new Gson();
        this.g = i18nResolver;
        this.h = permissionManager;
        this.i = virusScanErrorService;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getStatus() {
        a.debug((Object)"Get status");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.h.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to perform getStatus"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ArrayList<NodeStatusBean> arrayList = new ArrayList<NodeStatusBean>();
        if (this.e.isClustered()) {
            Set set = this.e.getAllNodesInformation().stream().map(ClusterNodeInformation::getAnonymizedNodeIdentifier).collect(Collectors.toSet());
            a.debug((Object)("Active nodes count [" + set.size() + "]"));
            List<AssignedNode> list = this.b.getAllAssignedNodes();
            a.debug((Object)("AssignedNode count [" + list.size() + "]"));
            for (AssignedNode assignedNode : list) {
                String string = set.contains(assignedNode.getNodeId()) ? "active" : "inactive";
                arrayList.add(this.a(assignedNode, string));
            }
            arrayList.sort(Comparator.comparing(NodeStatusBean::getNodeStatus));
        } else {
            AssignedNode assignedNode = this.b.a((String)null);
            arrayList.add(this.a(assignedNode, "active"));
        }
        return Response.ok((Object)this.f.toJson(arrayList)).build();
    }

    @NotNull
    private NodeStatusBean a(AssignedNode assignedNode, String string) {
        if (assignedNode == null) {
            return new NodeStatusBean();
        }
        String string2 = assignedNode.getNodeId();
        String string3 = assignedNode.getErrorIds();
        int n = 0;
        if (string3 != null && !string3.isEmpty()) {
            n = string3.split(",").length;
        }
        NodeStatusBean nodeStatusBean = new NodeStatusBean(string2, string, n, assignedNode.getIsPaused());
        a.debug((Object)("Node ID [" + nodeStatusBean.getNodeId() + "]"));
        a.debug((Object)("Node status [" + nodeStatusBean.getNodeStatus() + "]"));
        a.debug((Object)("Node error count [" + nodeStatusBean.getErrorCount() + "]"));
        a.debug((Object)("Scanning paused on node? [" + nodeStatusBean.isPaused() + "]"));
        return nodeStatusBean;
    }

    @GET
    @Path(value="/alert")
    @Produces(value={"application/json"})
    public Response getAlertStatus() {
        a.debug((Object)"Get scanning alert status");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.h.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] is not an admin, no alert required!"));
            return Response.noContent().build();
        }
        if (!this.c.i()) {
            a.debug((Object)"Virus scanning is disabled, no alert required!");
            return Response.noContent().build();
        }
        boolean bl = this.b.b();
        if (!bl) {
            a.debug((Object)"No paused nodes, no alert required!");
            return Response.noContent().build();
        }
        String string = this.e.isClustered() ? this.g.getText("com.akeles.acc.alertBanner.virusScanning.clustered") : this.g.getText("com.akeles.acc.alertBanner.virusScanning.nonClustered");
        AlertBannerBean alertBannerBean = new AlertBannerBean("error", string);
        a.debug((Object)("Alert type [" + alertBannerBean.getType() + "]"));
        a.debug((Object)("Alert message [" + alertBannerBean.getMessage() + "]"));
        return Response.ok((Object)this.f.toJson((Object)alertBannerBean)).build();
    }

    @GET
    @Path(value="/rescan")
    @Produces(value={"text/plain"})
    public Response a(@QueryParam(value="nodeId") String string) {
        a.debug((Object)("Rescan attachments for node ID [" + string + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.h.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to perform rescanAttachments"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        List<Integer> list = this.b.c(string);
        if (list != null && !list.isEmpty()) {
            int n = 0;
            List<VirusScanError> list2 = this.i.a(list);
            for (VirusScanError virusScanError : list2) {
                AttachmentToScan attachmentToScan = this.d.a(virusScanError.getAttachmentId(), virusScanError.getVersion(), virusScanError.getCreationDate(), virusScanError.getAttachedToId());
                if (attachmentToScan == null) continue;
                ++n;
            }
            this.b.d(string);
            return Response.ok((Object)this.g.getText("com.akeles.acc.attachmentScanningStatus.message.reQueued", new Serializable[]{Integer.valueOf(n)})).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/clear")
    @Produces(value={"application/json"})
    public Response b(@QueryParam(value="nodeId") String string) {
        a.debug((Object)("Clear errors for node ID [" + string + "]"));
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.h.isConfluenceAdministrator((User)confluenceUser)) {
            a.debug((Object)("[" + confluenceUser + "] does not have admin permission to perform clearErrors"));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.b.d(string);
        return Response.noContent().build();
    }
}

