/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.rest.beans;

import com.akelesconsulting.confluence.plugins.rest.beans.AttachmentBean;
import com.akelesconsulting.confluence.plugins.rest.beans.ItemBean;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.rest.beans.VirusScanErrorBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlRootElement
public class ResultBean
implements Serializable {
    @XmlElement(name="startCount")
    private int startCount;
    @XmlElement(name="endCount")
    private int endCount;
    @XmlElement(name="totalCount")
    private int totalCount;
    @XmlElement(name="numOfPages")
    private int numOfPages;
    @XmlElement(name="currPage")
    private int currPage;
    @XmlElement(name="itemsPerPage")
    private final int itemsPerPage;
    @XmlElement(name="itemList")
    private final List<ItemBean<?>> itemList;
    @XmlElement(name="isEvaluationLicense")
    private boolean isEvaluationLicense;

    public ResultBean(int n) {
        this.itemsPerPage = n;
        this.itemList = new ArrayList();
    }

    public void setPagination(int n, int n2) {
        this.startCount = n + 1;
        this.endCount = n + this.itemsPerPage;
        if (this.endCount > n2) {
            this.endCount = n2;
        }
        this.totalCount = n2;
        this.numOfPages = (n2 + this.itemsPerPage - 1) / this.itemsPerPage;
        this.currPage = n == 0 ? 1 : n / this.itemsPerPage + 1;
    }

    public void addAttachment(AttachmentBean attachmentBean) {
        this.itemList.add(new ItemBean<AttachmentBean>(attachmentBean));
    }

    public void addAttachments(@NotNull List<AttachmentBean> list) {
        this.itemList.addAll(list.stream().map(ItemBean::new).collect(Collectors.toList()));
    }

    public void addSpaceQuotaBeanList(@NotNull List<SpaceQuotaBean> list) {
        this.itemList.addAll(list.stream().map(ItemBean::new).collect(Collectors.toList()));
    }

    public void addVirusScanErrorBeanList(@NotNull List<VirusScanErrorBean> list) {
        this.itemList.addAll(list.stream().map(ItemBean::new).collect(Collectors.toList()));
    }

    public void setIsEvaluationLicense(boolean bl) {
        this.isEvaluationLicense = bl;
    }

    public String toString() {
        return "ResultBean {startCount=" + this.startCount + ", endCount=" + this.endCount + ", totalCount=" + this.totalCount + ", numOfPages=" + this.numOfPages + ", currPage=" + this.currPage + ", itemsPerPage=" + this.itemsPerPage + ", itemListSize=" + this.itemList.size() + ", isEvaluationLicense=" + this.isEvaluationLicense + '}';
    }
}

