/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.config;

import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeGroup;
import com.akelesconsulting.confluence.plugins.ao.entity.FileSizeLimit;
import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.FileSizeLimitService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.rest.beans.ExtensionBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachmentCheckerConfig {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.config.AttachmentCheckerConfig");
    private static final String b = "whitelist";
    private static final String c = "blacklist";
    private static final String d = "enabled";
    private static final List<String> e = Arrays.asList("application/vnd.apple.keynote.13", "application/vnd.apple.unknown.13", "application/vnd.ms-spreadsheetml", "application/vnd.ms-wordml", "application/x-x509-key");
    private static final String f = "application/octet-stream";
    private static final String g = "application/x-msdownload";
    private static final String h = "application/x-dosexec";
    private static final String i = "text/plain";
    private static final String j = ".render";
    private static final String k = ".tfss";
    private static final String l = "jpg";
    private static final String m = "whitelist";
    private static final String n = "This file type is not allowed.";
    private static final String o = "The file size has exceeded the maximum size limit set for the file type.";
    private static final String p = "Insufficient quota available.";
    private static final String q = "MB";
    private static final int r = 90;
    private static final String s = "This space has exceeded 90% of the disk quota. Please housekeep the attachments or inform the Confluence admin to increase the quota.";
    private static final String t = "You do not have permission to download the file. Please look for your Space Administrator.";
    private static final String u = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.";
    private static final String v = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanningCommentEnabled";
    private static final String w = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanningEmailJobRunning";
    private static final String x = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanningEmailJobNodeId";
    private static final String y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions";
    private static final String z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set";
    private static final String A = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set";
    private static final String B = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode";
    private static final String C = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimeTypeCheck";
    private static final String D = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowFilesWithoutExtension";
    private static final String E = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected";
    private static final String F = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted";
    private static final String G = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowDrawIo";
    private static final String H = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro";
    private static final String I = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message";
    private static final String J = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck";
    private static final String K = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError";
    private static final String L = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning";
    private static final String M = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode";
    private static final String N = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath";
    private static final String O = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption";
    private static final String P = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode";
    private static final String Q = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected";
    private static final String R = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError";
    private static final String S = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError";
    private static final String T = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail";
    private static final String U = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor";
    private static final String V = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning";
    private static final String W = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId";
    private static final String X = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isAttachmentAssignmentJobRunning";
    private static final String Y = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentAssignmentJobNodeId";
    private static final String Z = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck";
    private static final String aa = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError";
    private static final String ab = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage";
    private static final String ac = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit";
    private static final String ad = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaAllocated";
    private static final String ae = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaUnit";
    private static final String af = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold";
    private static final String ag = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage";
    private static final String ah = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota";
    private static final String ai = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.showSpaceQuotaTips";
    private static final String aj = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsText";
    private static final String ak = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsUrl";
    private static final String al = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm";
    private static final String am = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour";
    private static final String an = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute";
    private static final String ao = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm";
    private static final String ap = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour";
    private static final String aq = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute";
    private static final String ar = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaRecalculationInterval";
    private static final String as = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationStartTime";
    private static final String at = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationEndTime";
    private static final String au = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning";
    private static final String av = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted";
    private static final String aw = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup";
    private static final String ax = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment";
    private static final String ay = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize";
    private static final long az = 0xFA00000L;
    private static final String aA = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour";
    private static final String aB = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute";
    private static final String aC = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm";
    private static final String aD = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour";
    private static final String aE = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute";
    private static final String aF = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm";
    private static final String aG = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun";
    private static final String aH = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning";
    private static final String aI = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted";
    private static final String aJ = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartHour";
    private static final String aK = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartMinute";
    private static final String aL = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartAmPm";
    private static final String aM = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndHour";
    private static final String aN = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndMinute";
    private static final String aO = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndAmPm";
    private static final String aP = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobLastRun";
    private static final String aQ = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanRunning";
    private static final String aR = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanCompleted";
    private static final String aS = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unauthorisedDownloadErrorMessage";
    private static final String aT = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode";
    private static final String aU = "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup";
    private final Cache<String, Object> aV;
    private final FileSizeLimitService aW;
    private final GroupManager aX;
    private final PluginAccessor aY;
    private final PluginSettingsFactory aZ;
    private final PermissionManager ba;
    private final SpaceInfoService bb;
    private final UserAccessor bc;

    @Autowired
    public AttachmentCheckerConfig(@ComponentImport @NotNull CacheManager cacheManager, FileSizeLimitService fileSizeLimitService, @ComponentImport GroupManager groupManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport PermissionManager permissionManager, SpaceInfoService spaceInfoService, @ComponentImport UserAccessor userAccessor) {
        String string = AttachmentCheckerConfig.class.getName() + ".cache";
        CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().expireAfterAccess(30L, TimeUnit.MINUTES).maxEntries(1000).flushable().build();
        this.aV = cacheManager.getCache(string, (CacheLoader)new AcConfigCacheLoader(), cacheSettings);
        this.aX = groupManager;
        this.aW = fileSizeLimitService;
        this.aY = pluginAccessor;
        this.aZ = pluginSettingsFactory;
        this.ba = permissionManager;
        this.bb = spaceInfoService;
        this.bc = userAccessor;
    }

    public boolean a() {
        return Boolean.parseBoolean((String)this.aV.get((Object)v));
    }

    public void setDarkFeatures(boolean bl) {
        this.aZ.createGlobalSettings().put(v, (Object)Boolean.toString(bl));
        this.aV.remove((Object)v);
        a.debug((Object)("Updated dark feature isVirusScanningCommentEnabled [" + bl + "]"));
    }

    public boolean b() {
        return Boolean.parseBoolean((String)this.aV.get((Object)w));
    }

    public void setIsVirusScanningEmailJobRunning(boolean bl) {
        this.aZ.createGlobalSettings().put(w, (Object)Boolean.toString(bl));
        this.aV.remove((Object)w);
        a.debug((Object)("Updated isVirusScanningEmailJobRunning [" + bl + "]"));
    }

    public String getVirusScanningEmailJobNodeId() {
        return (String)this.aV.get((Object)x);
    }

    public void setVirusScanningEmailJobNodeId(String string) {
        this.aZ.createGlobalSettings().put(x, (Object)string);
        this.aV.remove((Object)x);
        a.debug((Object)("Updated virusScanningEmailJobNodeId [" + string + "]"));
    }

    public String getExtensions() {
        return (String)this.aV.get((Object)y);
    }

    public String getFilterMode() {
        return (String)this.aV.get((Object)B);
    }

    public boolean c() {
        return "on".equalsIgnoreCase(this.getMimeTypeCheck());
    }

    public String getMimeTypeCheck() {
        return (String)this.aV.get((Object)C);
    }

    public String getFileTypeErrorMessage() {
        return (String)this.aV.get((Object)I);
    }

    public Set<String> getExtensionSet() {
        TreeSet treeSet = (TreeSet)this.aV.get((Object)z);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    public Set<String> getMimeTypeSet() {
        TreeSet treeSet = (TreeSet)this.aV.get((Object)A);
        if (treeSet == null) {
            treeSet = new TreeSet();
        }
        return treeSet;
    }

    @NotNull
    public Set<String> a(String string) {
        a.debug((Object)("Get extension set for extensions [" + string + "]"));
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.isEmpty()) {
            return hashSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            hashSet.add(string2);
            String string3 = FileTypeHelper.a(string2);
            a.debug((Object)("Extension [" + string2 + "] MIME type [" + string3 + "]"));
            hashSet.addAll(FileTypeHelper.b(string3));
        }
        return hashSet;
    }

    public Set<String> b(String string) {
        a.debug((Object)"Get MIME type set");
        HashSet<String> hashSet = new HashSet<String>();
        if (string == null || string.isEmpty()) {
            return hashSet;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            a.debug((Object)("Get MIME type for extension [" + string2 + "]"));
            String string3 = FileTypeHelper.a(string2);
            if (string3 != null) {
                if (string3.equalsIgnoreCase(g) || string3.equalsIgnoreCase(h)) {
                    hashSet.add(g);
                    hashSet.add(h);
                    a.debug((Object)"Added MIME type [application/x-msdownload] and [application/x-dosexec]");
                    continue;
                }
                hashSet.add(string3);
                a.debug((Object)("Added MIME type [" + string3 + "]"));
                continue;
            }
            a.debug((Object)("Unable to detect MIME type for extension [" + string2 + "]"));
        }
        return hashSet;
    }

    public List<ExtensionBean> c(String string) {
        ArrayList<ExtensionBean> arrayList = new ArrayList<ExtensionBean>();
        if (string == null || string.isEmpty()) {
            return arrayList;
        }
        string = string.replace(" ", "");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!string2.startsWith(".")) {
                string2 = "." + string2;
            }
            ExtensionBean extensionBean = new ExtensionBean(string2, this.d(string2));
            a.debug((Object)("Extension [" + extensionBean.getExtension() + "] associated [" + extensionBean.getAssociatedExtensionList() + "]"));
            arrayList.add(extensionBean);
        }
        return arrayList;
    }

    public List<String> d(String string) {
        a.debug((Object)("Get associated extensions of [" + string + "]"));
        if (string != null && !string.startsWith(".")) {
            string = "." + string;
        }
        String string2 = FileTypeHelper.a(string);
        List<String> list = FileTypeHelper.b(string2);
        list.remove(string);
        return list;
    }

    public void a(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(B, (Object)string);
        this.aV.remove((Object)B);
        a.debug((Object)("Updated filterMode [" + string + "]"));
        pluginSettings.put(y, (Object)string2);
        this.aV.remove((Object)y);
        this.aV.remove((Object)z);
        this.aV.remove((Object)A);
        a.debug((Object)("Updated extensions [" + string2 + "]"));
        pluginSettings.put(C, (Object)string3);
        this.aV.remove((Object)C);
        a.debug((Object)("Updated mimeTypeCheck [" + string3 + "]"));
        pluginSettings.put(I, (Object)string4);
        this.aV.remove((Object)I);
        a.debug((Object)("Updated fileTypeErrorMessage (message) [" + string4 + "]"));
    }

    public void a(String string, String string2, String string3, String string4, String string5) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(D, (Object)string);
        this.aV.remove((Object)D);
        a.debug((Object)("Updated allowFilesWithoutExtension [" + string2 + "]"));
        pluginSettings.put(E, (Object)string2);
        this.aV.remove((Object)E);
        a.debug((Object)("Updated allowProtected [" + string2 + "]"));
        pluginSettings.put(F, (Object)string3);
        this.aV.remove((Object)F);
        a.debug((Object)("Updated allowEncrypted [" + string3 + "]"));
        pluginSettings.put(G, (Object)string4);
        this.aV.remove((Object)G);
        a.debug((Object)("Updated allowDrawIo [" + string4 + "]"));
        pluginSettings.put(H, (Object)string5);
        this.aV.remove((Object)H);
        a.debug((Object)("Updated allowTableSpreadsheetMacro [" + string5 + "]"));
    }

    public boolean d() {
        boolean bl = "on".equalsIgnoreCase(this.getAllowFilesWithoutExtension());
        a.debug((Object)("Allow files without extension? [" + bl + "]"));
        return bl;
    }

    public String getAllowFilesWithoutExtension() {
        return (String)this.aV.get((Object)D);
    }

    public String getAllowProtected() {
        return (String)this.aV.get((Object)E);
    }

    public String getAllowEncrypted() {
        return (String)this.aV.get((Object)F);
    }

    public String getAllowDrawIo() {
        return (String)this.aV.get((Object)G);
    }

    public boolean e() {
        boolean bl = "on".equalsIgnoreCase(this.getAllowDrawIo());
        a.debug((Object)("Allow draw.io? [" + bl + "]"));
        return bl;
    }

    public String getAllowTableSpreadsheetMacro() {
        return (String)this.aV.get((Object)H);
    }

    public boolean f() {
        return "on".equalsIgnoreCase(this.getAllowTableSpreadsheetMacro());
    }

    public boolean g() {
        return "on".equalsIgnoreCase(this.getFileSizeCheck());
    }

    public String getFileSizeCheck() {
        String string = (String)this.aV.get((Object)J);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setFileSizeCheck(String string) {
        this.aZ.createGlobalSettings().put(J, (Object)string);
        this.aV.remove((Object)J);
        a.debug((Object)("Updated file size check [" + string + "]"));
    }

    public String getFileSizeErrorMessage() {
        return (String)this.aV.get((Object)K);
    }

    public void setFileSizeErrorMessage(String string) {
        this.aZ.createGlobalSettings().put(K, (Object)string);
        this.aV.remove((Object)K);
        a.debug((Object)("Updated file size error message [" + string + "]"));
    }

    public boolean h() {
        return this.getMissingFileCheck().equalsIgnoreCase("on");
    }

    public String getMissingFileCheck() {
        String string = (String)this.aV.get((Object)L);
        if (Boolean.TRUE.toString().equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setMissingFileCheck(String string) {
        this.aZ.createGlobalSettings().put(L, (Object)string);
        this.aV.remove((Object)L);
        a.debug((Object)("Updated missing file check [" + string + "]"));
    }

    public boolean i() {
        return this.getVirusScanning().equalsIgnoreCase("on");
    }

    public String getVirusScanning() {
        String string = (String)this.aV.get((Object)M);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setVirusScanning(String string) {
        this.aZ.createGlobalSettings().put(M, (Object)string);
        this.aV.remove((Object)M);
        a.debug((Object)("Updated virus scanning [" + string + "]"));
    }

    public boolean a(int n, @NotNull String string) {
        boolean bl = true;
        if (!this.getScannerDetected().equalsIgnoreCase("unknown")) {
            bl = n == 1 && (string.contains("clamscan") || string.contains("clamdscan") || string.contains("fpscan")) || n == 3 && string.contains("savscan") || n == 13 && (string.contains("uvscan") || string.contains("scan.exe")) || n == 50 && (string.contains("ecls.exe") || string.contains("eset")) || n == 72 && string.contains("kesl-control");
        }
        a.debug((Object)("Is infected? [" + bl + "]"));
        return bl;
    }

    public String getScannerDetected() {
        String string = this.getScannerPath().toLowerCase();
        String string2 = string.contains("clamscan") || string.contains("clamdscan") ? "ClamAV" : (string.contains("ecls.exe") || string.contains("eset") ? "ESET" : (string.contains("fpscan") ? "F-PROT Antivirus" : (string.contains("kesl-control") ? "Kaspersky Endpoint Security for Linux" : (string.contains("savscan") ? "Sophos Anti-Virus" : (string.contains("uvscan") || string.contains("scan.exe") ? "McAfee VirusScan" : "unknown")))));
        return string2;
    }

    public String getScannerPath() {
        return (String)this.aV.get((Object)N);
    }

    public void a(String string, String string2) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(N, (Object)string);
        this.aV.remove((Object)N);
        a.debug((Object)("Updated scannerPath [" + string + "]"));
        pluginSettings.put(O, (Object)string2);
        this.aV.remove((Object)O);
        a.debug((Object)("Updated scannerOption [" + string2 + "]"));
    }

    public String getScannerOption() {
        return (String)this.aV.get((Object)O);
    }

    public boolean j() {
        return this.getDeleteIfInfected().equalsIgnoreCase("on");
    }

    public String getDeleteIfInfected() {
        String string = (String)this.aV.get((Object)P);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public boolean k() {
        return this.getEmailIfInfected().equalsIgnoreCase("on");
    }

    public String getEmailIfInfected() {
        return (String)this.aV.get((Object)Q);
    }

    public boolean l() {
        return this.getDeleteIfError().equalsIgnoreCase("on");
    }

    public String getDeleteIfError() {
        return (String)this.aV.get((Object)R);
    }

    public boolean m() {
        return this.getEmailIfError().equalsIgnoreCase("on");
    }

    public String getEmailIfError() {
        return (String)this.aV.get((Object)S);
    }

    public void b(String string, String string2, String string3, String string4) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(P, (Object)string);
        this.aV.remove((Object)P);
        a.debug((Object)("Updated deleteIfInfected (autoDeleteMode) [" + string + "]"));
        pluginSettings.put(Q, (Object)string2);
        this.aV.remove((Object)Q);
        a.debug((Object)("Updated emailIfInfected [" + string2 + "]"));
        pluginSettings.put(R, (Object)string3);
        this.aV.remove((Object)R);
        a.debug((Object)("Updated deleteIfError [" + string3 + "]"));
        pluginSettings.put(S, (Object)string4);
        this.aV.remove((Object)S);
        a.debug((Object)("Updated emailIfError [" + string4 + "]"));
    }

    public String getGroupToEmail() {
        return (String)this.aV.get((Object)T);
    }

    public void setGroupToEmail(String string) {
        this.aZ.createGlobalSettings().put(T, (Object)string);
        this.aV.remove((Object)T);
        a.debug((Object)("Updated group to email (Confluence Sysadmin Group) [" + string + "]"));
    }

    private String getVirusAlertActor() {
        return (String)this.aV.get((Object)U);
    }

    public void setVirusAlertActor(String string) {
        this.aZ.createGlobalSettings().put(U, (Object)string);
        this.aV.remove((Object)U);
        a.debug((Object)("Updated virus alert actor [" + string + "]"));
    }

    public ConfluenceUser getVirusAlertActorUser() {
        ConfluenceUser confluenceUser = null;
        String string = this.getVirusAlertActor();
        if (!string.isEmpty()) {
            confluenceUser = this.bc.getUserByKey(new UserKey(string));
        }
        return confluenceUser;
    }

    public boolean n() {
        return Boolean.parseBoolean((String)this.aV.get((Object)X));
    }

    public void setIsAttachmentAssignmentJobRunning(boolean bl) {
        this.aZ.createGlobalSettings().put(X, (Object)Boolean.toString(bl));
        this.aV.remove((Object)X);
        a.debug((Object)("Updated isAttachmentAssignmentJobRunning [" + bl + "]"));
    }

    public String getAttachmentAssignmentJobNodeId() {
        return (String)this.aV.get((Object)Y);
    }

    public void setAttachmentAssignmentJobNodeId(String string) {
        this.aZ.createGlobalSettings().put(Y, (Object)string);
        this.aV.remove((Object)Y);
        a.debug((Object)("Updated attachmentAssignmentJobNodeId [" + string + "]"));
    }

    public boolean o() {
        boolean bl = this.getQuotaCheck().equalsIgnoreCase("on");
        a.debug((Object)("Is quota check enabled? [" + bl + "]"));
        return bl;
    }

    public String getQuotaCheck() {
        String string = (String)this.aV.get((Object)Z);
        if (d.equalsIgnoreCase(string)) {
            string = "on";
        }
        return string;
    }

    public void setQuotaCheck(String string) {
        this.aZ.createGlobalSettings().put(Z, (Object)string);
        this.aV.remove((Object)Z);
        a.debug((Object)("Updated quota check [" + string + "]"));
    }

    public String getQuotaErrorMessage() {
        return (String)this.aV.get((Object)aa);
    }

    public String getUnit() {
        return (String)this.aV.get((Object)ac);
    }

    public long getDefaultQuotaAllocated() {
        Long l = (Long)this.aV.get((Object)ab);
        return l == null ? 0L : l;
    }

    public boolean p() {
        return this.getDefaultQuotaAllocated() == 0L;
    }

    public void setQuotaErrorMessage(String string) {
        this.aZ.createGlobalSettings().put(aa, (Object)string);
        this.aV.remove((Object)aa);
        a.debug((Object)("Updated quota error message [" + string + "]"));
    }

    public void b(String string, String string2) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(ab, (Object)string);
        this.aV.remove((Object)ab);
        a.debug((Object)("Updated defaultQuotaAllocated (defaultStorage) [" + string + "]"));
        pluginSettings.put(ac, (Object)string2);
        this.aV.remove((Object)ac);
        a.debug((Object)("Updated defaultQuotaAllocatedUnit (unit) [" + string2 + "]"));
    }

    public long getDefaultPersonalQuotaAllocated() {
        Long l = (Long)this.aV.get((Object)ad);
        if (l == null || l == -1L) {
            l = this.getDefaultQuotaAllocated();
        }
        return l;
    }

    public String getDefaultPersonalQuotaUnit() {
        String string = (String)this.aV.get((Object)ae);
        if (string == null || string.trim().isEmpty()) {
            string = this.getUnit();
        }
        return string;
    }

    public void c(String string, String string2) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(ad, (Object)string);
        this.aV.remove((Object)ad);
        a.debug((Object)("Updated defaultPersonalQuotaAllocated [" + string + "]"));
        pluginSettings.put(ae, (Object)string2);
        this.aV.remove((Object)ae);
        a.debug((Object)("Updated defaultPersonalQuotaUnit [" + string2 + "]"));
    }

    public int getQuotaAlertThreshold() {
        Integer n = (Integer)this.aV.get((Object)af);
        return n == null ? 90 : n;
    }

    public String getQuotaAlertMessage() {
        return (String)this.aV.get((Object)ag);
    }

    public void b(int n, String string) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(af, (Object)Integer.toString(n));
        this.aV.remove((Object)af);
        a.debug((Object)("Updated quotaAlertThreshold [" + n + "]"));
        pluginSettings.put(ag, (Object)string);
        this.aV.remove((Object)ag);
        a.debug((Object)("Updated quotaAlertMessage [" + string + "]"));
    }

    public boolean q() {
        int n = this.bb.getSpaceCount();
        int n2 = this.bb.getSpaceInfoCalculatedCount();
        a.debug((Object)("Num of Space [" + n + "]"));
        a.debug((Object)("Num of SpaceInfo [" + n2 + "]"));
        boolean bl = this.o() || this.u() || n == n2;
        a.debug((Object)("Is quota usage viewable? [" + bl + "]"));
        return bl;
    }

    public boolean e(String string) {
        int n = this.bb.getSpaceCount();
        int n2 = this.bb.getSpaceInfoCalculatedCount();
        a.debug((Object)("Num of Space [" + n + "]"));
        a.debug((Object)("Num of SpaceInfo [" + n2 + "]"));
        boolean bl = (this.o() || this.u() || n == n2) && this.f(string);
        a.debug((Object)("Is quota usage viewable for space [" + string + "]? [" + bl + "]"));
        return bl;
    }

    public boolean f(String string) {
        SpaceInfo spaceInfo = this.bb.a(string);
        boolean bl = spaceInfo != null && spaceInfo.getStorageUsed() != -1L;
        a.debug((Object)("Is quota usage calculated? [" + bl + "]"));
        return bl;
    }

    public boolean a(ConfluenceUser confluenceUser, Space space) {
        boolean bl = confluenceUser != null && (this.ba.isConfluenceAdministrator((User)confluenceUser) || this.ba.hasPermission((User)confluenceUser, Permission.ADMINISTER, (Object)space) || this.B() && this.ba.hasPermission((User)confluenceUser, Permission.VIEW, (Object)space));
        a.debug((Object)("User has permission to view space quota? [" + bl + "]"));
        return bl;
    }

    private boolean B() {
        return this.getAllowUsersToViewSpaceQuota().equalsIgnoreCase("on");
    }

    public String getAllowUsersToViewSpaceQuota() {
        return (String)this.aV.get((Object)ah);
    }

    public void setQuotaPermissions(String string) {
        this.aZ.createGlobalSettings().put(ah, (Object)string);
        this.aV.remove((Object)ah);
        a.debug((Object)("Updated allowUsersToViewSpaceQuota [" + string + "]"));
    }

    public boolean r() {
        return this.getShowSpaceQuotaTips().equalsIgnoreCase("on");
    }

    public String getShowSpaceQuotaTips() {
        return (String)this.aV.get((Object)ai);
    }

    public String getSpaceQuotaTipsText() {
        return (String)this.aV.get((Object)aj);
    }

    public String getSpaceQuotaTipsUrl() {
        return (String)this.aV.get((Object)ak);
    }

    public void a(String string, String string2, String string3) {
        this.aZ.createGlobalSettings().put(ai, (Object)string);
        this.aV.remove((Object)ai);
        a.debug((Object)("Updated showSpaceQuotaTips [" + string + "]"));
        this.aZ.createGlobalSettings().put(aj, (Object)string2);
        this.aV.remove((Object)aj);
        a.debug((Object)("Updated spaceQuotaTipsText [" + string2 + "]"));
        this.aZ.createGlobalSettings().put(ak, (Object)string3);
        this.aV.remove((Object)ak);
        a.debug((Object)("Updated spaceQuotaTipsUrl [" + string3 + "]"));
    }

    public Date getQuotaJobNextRunTime() {
        return DateHelper.a(this.getJobStartHour(), this.getJobStartMinute(), this.getJobStartAmPm());
    }

    public String getJobEndAmPm() {
        return (String)this.aV.get((Object)al);
    }

    public String getJobEndHour() {
        return (String)this.aV.get((Object)am);
    }

    public String getJobEndMinute() {
        return (String)this.aV.get((Object)an);
    }

    public String getJobStartAmPm() {
        return (String)this.aV.get((Object)ao);
    }

    public String getJobStartHour() {
        return (String)this.aV.get((Object)ap);
    }

    public String getJobStartMinute() {
        return (String)this.aV.get((Object)aq);
    }

    public String getQuotaRecalculationInterval() {
        return (String)this.aV.get((Object)ar);
    }

    public void setQuotaRecalculationInterval(String string) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(ar, (Object)string);
        this.aV.remove((Object)ar);
        a.debug((Object)("Updated calculateAttachmentJobInterval (quotaRecalculationInterval) [" + string + "]"));
    }

    public int getMonthsInterval() {
        int n;
        String string;
        switch (string = this.getQuotaRecalculationInterval()) {
            case "quarterly": {
                n = 3;
                break;
            }
            case "bimonthly": {
                n = 2;
                break;
            }
            default: {
                n = 1;
            }
        }
        return n;
    }

    private String getEnableQuotaCheckAfterSetup() {
        return (String)this.aV.get((Object)aw);
    }

    private String getIsJobRunning() {
        return (String)this.aV.get((Object)au);
    }

    public boolean s() {
        return Boolean.parseBoolean(this.getEnableQuotaCheckAfterSetup());
    }

    public boolean t() {
        return Boolean.parseBoolean(this.getIsJobRunning());
    }

    public void a(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(ap, (Object)string);
        this.aV.remove((Object)ap);
        a.debug((Object)("Updated calculateAttachmentJobStartHour (jobStartHour) [" + string + "]"));
        pluginSettings.put(aq, (Object)string2);
        this.aV.remove((Object)aq);
        a.debug((Object)("Updated calculateAttachmentJobStartMinute (jobStartMinute) [" + string2 + "]"));
        pluginSettings.put(ao, (Object)string3);
        this.aV.remove((Object)ao);
        a.debug((Object)("Updated calculateAttachmentJobStartAmPm (jobStartAmPm) [" + string3 + "]"));
        pluginSettings.put(am, (Object)string4);
        this.aV.remove((Object)am);
        a.debug((Object)("Updated calculateAttachmentJobEndHour (jobEndHour) [" + string4 + "]"));
        pluginSettings.put(an, (Object)string5);
        this.aV.remove((Object)an);
        a.debug((Object)("Updated calculateAttachmentJobEndMinute (jobEndMinute) [" + string5 + "]"));
        pluginSettings.put(al, (Object)string6);
        this.aV.remove((Object)al);
        a.debug((Object)("Updated calculateAttachmentJobEndAmPm (jobEndAmPm) [" + string6 + "]"));
    }

    public void setIsJobRunning(boolean bl) {
        this.aZ.createGlobalSettings().put(au, (Object)String.valueOf(bl));
        this.aV.remove((Object)au);
        a.debug((Object)("Updated is job running [" + bl + "]"));
    }

    public boolean u() {
        boolean bl = Boolean.parseBoolean((String)this.aV.get((Object)av));
        a.debug((Object)("Is quota setup completed? [" + bl + "]"));
        return bl;
    }

    public void setIsQuotaSetupCompleted(boolean bl) {
        this.aZ.createGlobalSettings().put(av, (Object)Boolean.toString(bl));
        this.aV.remove((Object)av);
        a.debug((Object)("Updated isQuotaSetupCompleted [" + bl + "]"));
    }

    public Long getQuotaCalculationStartTime() {
        Long l = (Long)this.aV.get((Object)as);
        a.debug((Object)("Get quotaCalculationStartTime [" + l + "]"));
        return l;
    }

    public void setQuotaCalculationStartTime(long l) {
        this.aZ.createGlobalSettings().put(as, (Object)Long.toString(l));
        this.aV.remove((Object)as);
        a.debug((Object)("Updated quotaCalculationStartTime [" + l + "]"));
    }

    public Long getQuotaCalculationEndTime() {
        Long l = (Long)this.aV.get((Object)at);
        a.debug((Object)("Get quotaCalculationEndTime [" + l + "]"));
        return l;
    }

    public void setQuotaCalculationEndTime(long l) {
        this.aZ.createGlobalSettings().put(at, (Object)Long.toString(l));
        this.aV.remove((Object)at);
        a.debug((Object)("Updated quotaCalculationEndTime [" + l + "]"));
    }

    public boolean v() {
        return "on".equalsIgnoreCase(this.getTrackLargeAttachment());
    }

    public String getTrackLargeAttachment() {
        return (String)this.aV.get((Object)ax);
    }

    public void setTrackLargeAttachment(String string) {
        this.aZ.createGlobalSettings().put(ax, (Object)string);
        this.aV.remove((Object)ax);
        a.debug((Object)("Updated track large attachment [" + string + "]"));
    }

    public long getLargeAttachmentSize() {
        Long l = (Long)this.aV.get((Object)ay);
        return l == null ? 0xFA00000L : l;
    }

    public void setLargeAttachmentSize(String string) {
        this.aZ.createGlobalSettings().put(ay, (Object)string);
        this.aV.remove((Object)ay);
        a.debug((Object)("Updated large attachment size [" + string + "]"));
    }

    public boolean w() {
        return Boolean.parseBoolean((String)this.aV.get((Object)aH));
    }

    public void setIsMissingAttachmentScanRunning(boolean bl) {
        this.aZ.createGlobalSettings().put(aH, (Object)Boolean.toString(bl));
        this.aV.remove((Object)aH);
        a.debug((Object)("Updated isMissingAttachmentScanRunning [" + bl + "]"));
    }

    public boolean x() {
        return Boolean.parseBoolean((String)this.aV.get((Object)aI));
    }

    public void setIsMissingAttachmentScanCompleted(boolean bl) {
        this.aZ.createGlobalSettings().put(aI, (Object)Boolean.toString(bl));
        this.aV.remove((Object)aI);
        a.debug((Object)("Updated isMissingAttachmentScanCompleted [" + bl + "]"));
    }

    public Long getMissingAttachmentScannerLastRun() {
        return (Long)this.aV.get((Object)aG);
    }

    public void setMissingAttachmentScannerLastRun(long l) {
        this.aZ.createGlobalSettings().put(aG, (Object)String.valueOf(l));
        this.aV.remove((Object)aG);
        a.debug((Object)("Updated missingAttachmentJobLastRun [" + l + "]"));
    }

    public void b(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(aA, (Object)string);
        this.aV.remove((Object)aA);
        a.debug((Object)("Updated missingAttachmentJobStartHour [" + string + "]"));
        pluginSettings.put(aB, (Object)string2);
        this.aV.remove((Object)aB);
        a.debug((Object)("Updated missingAttachmentJobStartMinute [" + string2 + "]"));
        pluginSettings.put(aC, (Object)string3);
        this.aV.remove((Object)aC);
        a.debug((Object)("Updated missingAttachmentJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(aD, (Object)string4);
        this.aV.remove((Object)aD);
        a.debug((Object)("Updated missingAttachmentJobEndHour [" + string4 + "]"));
        pluginSettings.put(aE, (Object)string5);
        this.aV.remove((Object)aE);
        a.debug((Object)("Updated missingAttachmentJobEndMinute [" + string5 + "]"));
        pluginSettings.put(aF, (Object)string6);
        this.aV.remove((Object)aF);
        a.debug((Object)("Updated missingAttachmentJobEndAmPm [" + string6 + "]"));
    }

    public String getMissingAttachmentScannerStartHour() {
        return (String)this.aV.get((Object)aA);
    }

    public String getMissingAttachmentScannerStartMinute() {
        return (String)this.aV.get((Object)aB);
    }

    public String getMissingAttachmentScannerStartAmPm() {
        return (String)this.aV.get((Object)aC);
    }

    public String getMissingAttachmentScannerEndHour() {
        return (String)this.aV.get((Object)aD);
    }

    public String getMissingAttachmentScannerEndMinute() {
        return (String)this.aV.get((Object)aE);
    }

    public String getMissingAttachmentScannerEndAmPm() {
        return (String)this.aV.get((Object)aF);
    }

    public boolean y() {
        return Boolean.parseBoolean((String)this.aV.get((Object)aQ));
    }

    public void setIsViolationScanRunning(boolean bl) {
        this.aZ.createGlobalSettings().put(aQ, (Object)Boolean.toString(bl));
        this.aV.remove((Object)aQ);
        a.debug((Object)("Updated isViolationScanRunning [" + bl + "]"));
    }

    public boolean z() {
        return Boolean.parseBoolean((String)this.aV.get((Object)aR));
    }

    public void setIsViolationScanCompleted(boolean bl) {
        this.aZ.createGlobalSettings().put(aR, (Object)Boolean.toString(bl));
        this.aV.remove((Object)aR);
        a.debug((Object)("Updated isViolationScanCompleted [" + bl + "]"));
    }

    public Long getViolationScannerLastRun() {
        return (Long)this.aV.get((Object)aP);
    }

    public void setViolationScannerLastRun(long l) {
        this.aZ.createGlobalSettings().put(aP, (Object)String.valueOf(l));
        this.aV.remove((Object)aP);
        a.debug((Object)("Updated violationScannerJobLastRun [" + l + "]"));
    }

    public void c(String string, String string2, String string3, String string4, String string5, String string6) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(aJ, (Object)string);
        this.aV.remove((Object)aJ);
        a.debug((Object)("Updated violationScannerJobStartHour [" + string + "]"));
        pluginSettings.put(aK, (Object)string2);
        this.aV.remove((Object)aK);
        a.debug((Object)("Updated violationScannerJobStartMinute [" + string2 + "]"));
        pluginSettings.put(aL, (Object)string3);
        this.aV.remove((Object)aL);
        a.debug((Object)("Updated violationScannerJobStartAmPm [" + string3 + "]"));
        pluginSettings.put(aM, (Object)string4);
        this.aV.remove((Object)aM);
        a.debug((Object)("Updated violationScannerJobEndHour [" + string4 + "]"));
        pluginSettings.put(aN, (Object)string5);
        this.aV.remove((Object)aN);
        a.debug((Object)("Updated violationScannerJobEndMinute [" + string5 + "]"));
        pluginSettings.put(aO, (Object)string6);
        this.aV.remove((Object)aO);
        a.debug((Object)("Updated violationScannerJobEndAmPm [" + string6 + "]"));
    }

    public String getViolationScannerStartHour() {
        return (String)this.aV.get((Object)aJ);
    }

    public String getViolationScannerStartMinute() {
        return (String)this.aV.get((Object)aK);
    }

    public String getViolationScannerStartAmPm() {
        return (String)this.aV.get((Object)aL);
    }

    public String getViolationScannerEndHour() {
        return (String)this.aV.get((Object)aM);
    }

    public String getViolationScannerEndMinute() {
        return (String)this.aV.get((Object)aN);
    }

    public String getViolationScannerEndAmPm() {
        return (String)this.aV.get((Object)aO);
    }

    public String getUnauthorisedDownloadErrorMessage() {
        return (String)this.aV.get((Object)aS);
    }

    public void setAttachmentPermissions(String string) {
        PluginSettings pluginSettings = this.aZ.createGlobalSettings();
        pluginSettings.put(aS, (Object)string);
        this.aV.remove((Object)aS);
        a.debug((Object)("Updated unauthorisedDownloadErrorMessage [" + string + "]"));
    }

    public String getAttachmentLog() {
        return (String)this.aV.get((Object)aT);
    }

    public void setAttachmentLog(String string) {
        this.aZ.createGlobalSettings().put(aT, (Object)string);
        this.aV.remove((Object)aT);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public String getAttachmentLogGroup() {
        return (String)this.aV.get((Object)aU);
    }

    public void setAttachmentLogGroup(String string) {
        this.aZ.createGlobalSettings().put(aU, (Object)string);
        this.aV.remove((Object)aU);
        a.debug((Object)("Updated attachment log [" + string + "]"));
    }

    public boolean a(String string, boolean bl) {
        boolean bl2;
        a.debug((Object)"*** Checking Extension ***");
        if (string != null) {
            if (bl) {
                bl2 = this.e();
            } else {
                boolean bl3 = bl2 = (string.equals(k) || string.equals(j)) && this.f();
            }
            if (!bl2) {
                String string2 = this.getFilterMode();
                boolean bl4 = string2.equalsIgnoreCase("whitelist");
                Set<String> set = this.getExtensionSet();
                String string3 = FileTypeHelper.e(string);
                bl2 = this.a(bl4, string3, set);
            }
        } else {
            bl2 = this.d();
        }
        a.debug((Object)("Is extension [" + string + "] valid? [" + bl2 + "]"));
        return bl2;
    }

    public boolean a(String string, String string2, InputStream inputStream, boolean bl) {
        boolean bl2;
        a.debug((Object)"*** Checking MIME Type ***");
        boolean bl3 = this.c();
        a.debug((Object)("Is MIME type check enabled? [" + bl3 + "]"));
        if (!bl3) {
            return true;
        }
        String string3 = this.getFilterMode();
        a.debug((Object)("Filter mode [" + string3 + "]"));
        a.debug((Object)("MIME type [" + string2 + "]"));
        boolean bl4 = string3.equalsIgnoreCase("whitelist");
        boolean bl5 = FileTypeHelper.a(string, string2, inputStream);
        if (string2.equals("application/x-tika-ooxml-protected")) {
            String string4 = this.getAllowProtected();
            a.debug((Object)("Allow protected [" + string4 + "]"));
            bl2 = string4.equals("on");
        } else if (bl5) {
            String string5 = this.getAllowEncrypted();
            a.debug((Object)("Allow encrypted [" + string5 + "]"));
            bl2 = string5.equals("on");
        } else if (e.contains(string2)) {
            a.debug((Object)"Checking if extension and MIME type matches");
            bl2 = this.a(bl4, string, string2);
        } else if (bl) {
            bl2 = this.e();
        } else if (string != null && string.startsWith(".kal_") && string2.equals(f)) {
            bl2 = true;
        } else {
            boolean bl6 = bl2 = this.d(string, string2) && this.f() || this.a(string, string2, inputStream);
            if (!bl2) {
                Set<String> set = this.getMimeTypeSet();
                bl2 = this.a(bl4, string2, set);
            }
        }
        a.debug((Object)("Is MIME type [" + string2 + "] valid? [" + bl2 + "]"));
        return bl2;
    }

    private boolean a(boolean bl, String string, @NotNull String string2) {
        boolean bl2 = false;
        if (string2.equals("application/vnd.apple.keynote.13")) {
            a.debug((Object)"Apple keynote file detected");
            bl2 = this.a(bl, string, new String[]{".key"});
        } else if (string2.equals("application/vnd.apple.unknown.13")) {
            a.debug((Object)"Apple keynote/numbers/pages file detected");
            bl2 = this.a(bl, string, ".key", ".numbers", ".pages");
        } else if (string2.equals("application/vnd.ms-spreadsheetml") || string2.equals("application/vnd.ms-wordml")) {
            a.debug((Object)"Office xml file detected");
            bl2 = this.a(bl, string, new String[]{".xml"});
        } else if (string2.equalsIgnoreCase("application/x-x509-key")) {
            a.debug((Object)"application/x-x509-key detected");
            bl2 = this.a(bl, string, ".pfx", ".p12");
        }
        return bl2;
    }

    public boolean b(String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = string2 == null;
        a.debug((Object)("Attachment comment [" + string3 + "]"));
        if (string3 != null) {
            if (string3.endsWith("exported to image")) {
                bl = string.equals(".png") && (bl2 || string2.equals("image/png"));
            } else if ("draw.io Draft".equalsIgnoreCase(string3)) {
                bl = string.equals(".tmp") && (bl2 || string2.equals(i));
            } else if ("draw.io diagram".equalsIgnoreCase(string3)) {
                bl = bl2 || string2.equals(i);
            }
        }
        a.debug((Object)("Is draw.io attachment? [" + bl + "]"));
        return bl;
    }

    private boolean a(boolean bl, String string, Set<String> set) {
        return bl && set.contains(string) || !bl && !set.contains(string);
    }

    private boolean a(boolean bl, String string, String ... stringArray) {
        boolean bl2 = false;
        for (String string2 : stringArray) {
            boolean bl3 = bl2 = bl && string2.equals(string) || !bl && !this.getExtensionSet().contains(string2);
            if (bl2) break;
        }
        return bl2;
    }

    private boolean a(String string, String string2, InputStream inputStream) {
        boolean bl = false;
        if (".ics".equals(string) && string2.equals("text/html")) {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string3 = bufferedReader.readLine();
                a.debug((Object)("First line [" + string3 + "]"));
                bl = string3.equals("BEGIN:VCALENDAR");
            }
            catch (IOException iOException) {
                a.error((Object)"IOException while trying to read input stream", (Throwable)iOException);
            }
        }
        a.debug((Object)("Is calendar file with html? [" + bl + "]"));
        return bl;
    }

    private boolean d(String string, String string2) {
        boolean bl = false;
        if (string != null) {
            bl = string.equals(k) && string2.equals(i) || string.equals(j) && (string2.equals(f) || string2.equals("text/html"));
        }
        a.debug((Object)("Is Table Spreadsheet Macro attachments? [" + bl + "]"));
        return bl;
    }

    public boolean a(String string, long l, ConfluenceUser confluenceUser) {
        a.debug((Object)("User [" + confluenceUser + "]"));
        FileSizeLimit fileSizeLimit = null;
        if (confluenceUser != null) {
            List<FileSizeGroup> list = this.aW.getFileSizeGroups();
            for (FileSizeGroup fileSizeGroup : list) {
                try {
                    Group group = this.aX.getGroup(fileSizeGroup.getGroup());
                    if (!this.aX.hasMembership(group, (User)confluenceUser)) continue;
                    a.debug((Object)("Get file size limit for [" + fileSizeGroup.getGroup() + "]"));
                    fileSizeLimit = this.aW.b(fileSizeGroup.getID(), string);
                    break;
                }
                catch (EntityException entityException) {
                    a.error((Object)entityException.getMessage());
                }
            }
            if (fileSizeLimit == null) {
                a.debug((Object)"Get file size limit for any logged in user");
                fileSizeLimit = this.aW.b(0, string);
            }
        } else {
            a.debug((Object)"Get file size limit for anonymous ");
            fileSizeLimit = this.aW.b(-1, string);
        }
        if (fileSizeLimit != null) {
            long l2 = AttachmentCheckerHelper.a(fileSizeLimit.getSizeLimit(), fileSizeLimit.getSizeUnit());
            a.debug((Object)("Mime type [" + string + "] size limit [" + l2 + "] bytes"));
            a.debug((Object)("File size [" + l + "] bytes"));
            return l > l2;
        }
        return false;
    }

    public Map<String, String> a(@NotNull Space space, long l) {
        long l2;
        a.debug((Object)("Check quota for space [" + space.getKey() + "]"));
        a.debug((Object)("File size [" + l + "]"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        SpaceInfo spaceInfo = this.bb.a(space.getKey());
        boolean bl = spaceInfo != null;
        a.debug((Object)("Has SpaceInfo? [" + bl + "]"));
        long l3 = l2 = !bl ? 0L : spaceInfo.getStorageAllocated();
        if (l2 == -1L) {
            long l4 = l2 = space.isPersonal() ? this.getDefaultPersonalQuotaAllocated() : this.getDefaultQuotaAllocated();
        }
        if (!bl || l2 == 0L) {
            a.debug((Object)"Quota allocated is unlimited");
            hashMap.put("isSufficient", Boolean.toString(true));
        } else {
            long l5 = spaceInfo.getStorageUsed();
            long l6 = l2 - l5;
            a.debug((Object)("Quota allocated (bytes) [" + l2 + "]"));
            a.debug((Object)("Quota available (bytes) [" + l6 + "]"));
            hashMap.put("allocated", AttachmentCheckerHelper.a(l2, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("available", AttachmentCheckerHelper.a(l6, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("used", AttachmentCheckerHelper.a(l5, this.getUnit(), 2) + " " + this.getUnit());
            hashMap.put("isSufficient", String.valueOf(l <= l6));
        }
        return hashMap;
    }

    private class AcConfigCacheLoader
    implements CacheLoader<String, Object> {
        private AcConfigCacheLoader() {
        }

        @Nonnull
        public Object a(@Nonnull String string) {
            Object object;
            a.debug((Object)("Load value for key [" + string + "]"));
            String string2 = this.b(string);
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions": {
                    object = this.a(string2, AttachmentCheckerConfig.l);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": {
                    object = AttachmentCheckerConfig.this.a(AttachmentCheckerConfig.this.getExtensions());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    object = AttachmentCheckerConfig.this.b(AttachmentCheckerConfig.this.getExtensions());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.filterMode": {
                    object = this.d(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimeTypeCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowFilesWithoutExtension": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowUsersToViewSpaceQuota": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.showSpaceQuotaTips": {
                    object = this.a(string2, "on");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowDrawIo": {
                    object = this.a(string2, AttachmentCheckerConfig.this.aY.isPluginEnabled("com.mxgraph.confluence.plugins.diagramly") ? "on" : "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowEncrypted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowProtected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.allowTableSpreadsheetMacro": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.onAccessScanning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.autoDeleteMode": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfInfected": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.deleteIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.emailIfError": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCheck": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.trackLargeAttachment": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.loggingMode": {
                    object = this.a(string2, "off");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.largeAttachmentSize": {
                    object = this.a(string2, 0xFA00000L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobLastRun": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobLastRun": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationStartTime": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaCalculationEndTime": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.message": {
                    object = this.a(string2, AttachmentCheckerConfig.n);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.fileSizeError": {
                    object = this.a(string2, AttachmentCheckerConfig.o);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unauthorisedDownloadErrorMessage": {
                    object = this.a(string2, AttachmentCheckerConfig.t);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanningCommentEnabled": {
                    object = this.a(string2, Boolean.TRUE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.enableQuotaCheckAfterSetup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isVirusScanningEmailJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isAttachmentAssignmentJobRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isQuotaSetupCompleted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isMissingAttachmentScanCompleted": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanRunning": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.isViolationScanCompleted": {
                    object = this.a(string2, Boolean.FALSE.toString());
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.groupToEmail": {
                    object = this.a(string2, "confluence-administrators");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaUnit": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerPath": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.scannerOption": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusAlertActor": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.virusScanningEmailJobNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentAssignmentJobNodeId": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.jobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.missingAttachmentJobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobStartAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndHour": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndMinute": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.violationScannerJobEndAmPm": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.attachmentLogGroup": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsText": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.spaceQuotaTipsUrl": {
                    object = this.a(string2, "");
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaError": {
                    object = this.a(string2, AttachmentCheckerConfig.p);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultStorage": {
                    object = this.a(string2, 0L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.defaultPersonalQuotaAllocated": {
                    object = this.a(string2, -1L);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.unit": {
                    object = this.a(string2, AttachmentCheckerConfig.q);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertThreshold": {
                    object = this.c(string2);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaAlertMessage": {
                    object = this.a(string2, AttachmentCheckerConfig.s);
                    break;
                }
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.quotaRecalculationInterval": {
                    object = this.a(string2, "monthly");
                    break;
                }
                default: {
                    object = "This should not happen";
                }
            }
            return object;
        }

        @Nullable
        private String b(@NotNull String string) {
            switch (string) {
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.extensions.set": 
                case "com.akelesconsulting.confluence.plugins.AttachmentCheckerResource.mimetype.set": {
                    return null;
                }
            }
            return (String)AttachmentCheckerConfig.this.aZ.createGlobalSettings().get(string);
        }

        @NotNull
        private String a(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                string = string2;
            }
            a.debug((Object)("String value [" + string + "]"));
            return string;
        }

        private int c(String string) {
            int n;
            if (string == null || string.isEmpty()) {
                n = 90;
            } else {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 90;
                }
            }
            a.debug((Object)("int value [" + n + "]"));
            return n;
        }

        private String d(String string) {
            if (string == null || !string.equalsIgnoreCase(AttachmentCheckerConfig.c) && !string.equalsIgnoreCase("whitelist")) {
                string = "whitelist";
            }
            a.debug((Object)("Filter mode [" + string + "]"));
            return string.toLowerCase();
        }

        private Long a(String string, long l) {
            long l2;
            if (string == null || string.isEmpty()) {
                string = String.valueOf(l);
            }
            try {
                l2 = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
            a.debug((Object)("Long value [" + string + "]"));
            return l2;
        }

        @Nonnull
        public /* synthetic */ Object load(@Nonnull Object object) {
            return this.a((String)object);
        }
    }
}

