/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceInfo;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceToUpdateService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class QuotaHelper {
    private static final Logger h = Logger.getLogger((String)"com.akeles.plugins.acc.utils.QuotaHelper");
    public static final int a = 50;
    public static final long b = -1L;
    public static final long c = 0L;
    public static final long d = -1L;
    public static final String e = "green";
    public static final String f = "orange";
    public static final String g = "red";
    private final AttachmentCheckerConfig i;
    private final DateHelper j;
    private final I18nResolver k;
    private final SpaceInfoService l;
    private final SpaceManager m;
    private final SpaceToUpdateService n;

    public QuotaHelper(AttachmentCheckerConfig attachmentCheckerConfig, DateHelper dateHelper, @ComponentImport I18nResolver i18nResolver, SpaceInfoService spaceInfoService, @ComponentImport SpaceManager spaceManager, SpaceToUpdateService spaceToUpdateService) {
        this.i = attachmentCheckerConfig;
        this.j = dateHelper;
        this.k = i18nResolver;
        this.l = spaceInfoService;
        this.m = spaceManager;
        this.n = spaceToUpdateService;
    }

    public List<SpaceQuotaBean> a(int n) {
        h.debug((Object)"Get SpaceQuotaBean list");
        ArrayList<SpaceQuotaBean> arrayList = new ArrayList<SpaceQuotaBean>();
        ListBuilder listBuilder = this.m.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        while (arrayList.size() < 50) {
            h.debug((Object)("Start index [" + n + "]"));
            List list = listBuilder.getPage(n, 50 - arrayList.size());
            if (list.isEmpty()) {
                h.debug((Object)("No space found for start index [" + n + "]"));
                break;
            }
            for (Space space : list) {
                SpaceQuotaBean spaceQuotaBean = this.a(space);
                if (spaceQuotaBean == null) continue;
                arrayList.add(spaceQuotaBean);
                h.debug((Object)("Adding space [" + space.getKey() + "]"));
            }
            h.debug((Object)("SpaceQuotaBean count [" + arrayList.size() + "]"));
            n += 50;
        }
        return arrayList;
    }

    public List<SpaceQuotaBean> a(String string, String string2, String string3, String string4) {
        h.debug((Object)"Get SpaceQuotaBean list");
        string = string.trim().toLowerCase();
        ArrayList<SpaceQuotaBean> arrayList = new ArrayList<SpaceQuotaBean>();
        ListBuilder listBuilder = this.m.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        if (listBuilder.getAvailableSize() == 0) {
            return arrayList;
        }
        List list = listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
        for (Space space : list) {
            SpaceQuotaBean spaceQuotaBean;
            if (!this.a(space, string) || !this.b(space, string4) || (spaceQuotaBean = this.a(space)) == null || !this.a(spaceQuotaBean, string2) || !this.b(spaceQuotaBean, string3)) continue;
            arrayList.add(spaceQuotaBean);
            h.debug((Object)("Adding space [" + space.getKey() + "]"));
        }
        h.debug((Object)("SpaceQuotaBean count [" + arrayList.size() + "]"));
        return arrayList;
    }

    public boolean a(@NotNull Space space, @NotNull String string) {
        String string2 = space.getKey();
        String string3 = space.getName();
        h.debug((Object)("Space key [" + string2 + "] name [" + string3 + "]"));
        boolean bl = string.isEmpty() || string2.toLowerCase().contains(string) || string3.toLowerCase().contains(string);
        h.debug((Object)("Matches query? [" + bl + "]"));
        return bl;
    }

    public boolean b(Space space, String string) {
        boolean bl = string == null || string.isEmpty() || "personal".equalsIgnoreCase(string) && space.isPersonal() || "global".equalsIgnoreCase(string) && !space.isPersonal();
        h.debug((Object)("Matches space type filter? [" + bl + "]"));
        return bl;
    }

    public boolean a(SpaceQuotaBean spaceQuotaBean, String string) {
        boolean bl = string == null || string.isEmpty() || "custom".equalsIgnoreCase(string) && !spaceQuotaBean.getIsQuotaDefault() || "default".equalsIgnoreCase(string) && spaceQuotaBean.getIsQuotaDefault();
        h.debug((Object)("Matches allocation filter? [" + bl + "]"));
        return bl;
    }

    public boolean b(SpaceQuotaBean spaceQuotaBean, String string) {
        boolean bl = string == null || string.isEmpty() || "empty".equalsIgnoreCase(string) && spaceQuotaBean.getIsQuotaUsageEmpty() || "alert".equalsIgnoreCase(string) && spaceQuotaBean.getQuotaUsageColour().equals(f) || "exceed".equalsIgnoreCase(string) && spaceQuotaBean.getQuotaUsageColour().equals(g);
        h.debug((Object)("Matches usage filter? [" + bl + "]"));
        return bl;
    }

    public SpaceQuotaBean a(@NotNull Space space) {
        boolean bl;
        boolean bl2;
        h.debug((Object)("Get SpaceQuotaBean for space [" + space.getKey() + "]"));
        SpaceInfo spaceInfo = this.l.a(space.getKey());
        if (spaceInfo == null || spaceInfo.getStorageUsed() == -1L) {
            return null;
        }
        String string = this.i.getUnit();
        long l = spaceInfo.getStorageAllocated();
        long l2 = spaceInfo.getStorageUsed();
        boolean bl3 = l2 == -1L;
        String string2 = "";
        String string3 = bl3 ? "" : AttachmentCheckerHelper.a(l2, string, 2);
        String string4 = "";
        boolean bl4 = bl2 = l == -1L;
        if (bl2) {
            l = space.isPersonal() ? this.i.getDefaultPersonalQuotaAllocated() : this.i.getDefaultQuotaAllocated();
        }
        boolean bl5 = bl = l == 0L;
        if (bl) {
            string4 = string2 = this.k.getText("com.akeles.acc.config.common.unlimited");
        } else if (!bl3) {
            string2 = AttachmentCheckerHelper.a(l, string, 2);
            string4 = this.a(string2, string3, l, l2);
            if (string2.equals("0.00") && l > 0L) {
                string2 = string2 + " (" + AttachmentCheckerHelper.a(l, 2) + ")";
            }
        }
        if (string3.equals("0.00") && l2 > 0L) {
            string3 = string3 + " (" + AttachmentCheckerHelper.a(l2, 2) + ")";
        }
        SpaceQuotaBean spaceQuotaBean = new SpaceQuotaBean(space.getKey(), space.getName());
        spaceQuotaBean.setQuota(string, string2, string3, string4, bl2, bl, l2 == 0L);
        if (!bl && !bl3) {
            spaceQuotaBean.setQuotaUsage(l, l2, this.i.getQuotaAlertThreshold());
        }
        spaceQuotaBean.setAttachmentsCount(spaceInfo.getAllVersionsCount(), spaceInfo.getCurrentVersionsCount());
        boolean bl6 = this.n.a(space.getKey());
        String string5 = this.j.a(spaceInfo.getLastUpdated(), "-");
        String string6 = this.j.a(this.i.getQuotaJobNextRunTime(), "-");
        spaceQuotaBean.setSchedule(string5, string6, bl6);
        h.debug((Object)spaceQuotaBean.toString());
        return spaceQuotaBean;
    }

    @NotNull
    private String a(String string, String string2, long l, long l2) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            bigDecimal = new BigDecimal(String.valueOf(d - d2));
        }
        catch (NumberFormatException numberFormatException) {
            h.debug((Object)"Error converting String to double", (Throwable)numberFormatException);
        }
        String string3 = bigDecimal.setScale(2, RoundingMode.HALF_UP).toPlainString();
        long l3 = l - l2;
        if (string3.equals("0.00") && l3 > 0L) {
            string3 = string3 + " (" + AttachmentCheckerHelper.a(l3, 2) + ")";
        }
        return string3;
    }
}

