/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.Tika;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.jetbrains.annotations.NotNull;

public class FileTypeHelper {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.utils.FileTypeHelper");
    private static final MimeTypes b = MimeTypes.getDefaultMimeTypes();
    private static final Tika c = new Tika();

    private FileTypeHelper() {
    }

    public static String a(String string) {
        a.debug((Object)("Get MIME type with extension [" + string + "]"));
        String string2 = null;
        if (string != null) {
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            if ((string2 = c.detect(string)).equalsIgnoreCase("application/octet-stream")) {
                if (".dcm".equalsIgnoreCase(string)) {
                    string2 = "application/dicom";
                } else if (".hwp".equalsIgnoreCase(string)) {
                    string2 = "application/x-hwp-v5";
                } else if (".xd".equalsIgnoreCase(string)) {
                    string2 = "application/vnd.adobe.sparkler.project+dcxucf";
                } else if (".qea".equalsIgnoreCase(string)) {
                    string2 = "application/x-sqlite3";
                }
            }
        }
        a.debug((Object)("MIME type [" + string2 + "]"));
        return string2;
    }

    @NotNull
    public static List<String> b(String string) {
        a.debug((Object)("Get extensions with MIME type [" + string + "]"));
        HashSet<String> hashSet = new HashSet<String>();
        try {
            hashSet = new HashSet(b.forName(string).getExtensions());
            if ("application/x-dosexec".equalsIgnoreCase(string)) {
                hashSet.addAll(b.forName("application/x-msdownload").getExtensions());
            } else if ("application/x-msdownload".equalsIgnoreCase(string)) {
                hashSet.addAll(b.forName("application/x-dosexec").getExtensions());
            } else if ("application/dicom".equalsIgnoreCase(string)) {
                hashSet.add(".dcm");
            } else if ("application/x-hwp-v5".equalsIgnoreCase(string)) {
                hashSet.add(".hwp");
            } else if ("application/vnd.adobe.sparkler.project+dcxucf".equalsIgnoreCase(string)) {
                hashSet.add(".xd");
            } else if ("application/x-sqlite3".equalsIgnoreCase(string)) {
                hashSet.add(".qea");
            } else if ("application/vnd.apple.keynote.13".equalsIgnoreCase(string)) {
                hashSet.add(".key");
            } else if ("application/vnd.ms-spreadsheetml".equalsIgnoreCase(string) || "application/vnd.ms-wordml".equalsIgnoreCase(string)) {
                hashSet.add(".xml");
            }
        }
        catch (MimeTypeException mimeTypeException) {
            a.error((Object)("Error getting MIME type for name [" + string + "]"));
        }
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        arrayList.sort(String.CASE_INSENSITIVE_ORDER);
        a.debug((Object)("Extensions [" + String.join((CharSequence)", ", arrayList) + "]"));
        return arrayList;
    }

    public static boolean c(String string) {
        return string != null && string.matches(".+\\.7z\\.\\d\\d\\d$");
    }

    public static String a(String string, InputStream inputStream) {
        String string2 = null;
        TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)inputStream);
        Metadata metadata = new Metadata();
        if (FileTypeHelper.c(string)) {
            metadata.add("resourceName", string + ".7z");
        } else {
            metadata.add("resourceName", string);
        }
        try {
            string2 = c.detect((InputStream)tikaInputStream, metadata);
            a.debug((Object)("MIME type [" + string2 + "]"));
            string2 = MediaType.parse((String)string2).getBaseType().toString();
            a.debug((Object)("Base MIME type [" + string2 + "]"));
            tikaInputStream.close();
        }
        catch (IOException iOException) {
            a.error((Object)"IOException detecting MIME type", (Throwable)iOException);
        }
        return string2;
    }

    public static String d(String string) {
        int n;
        a.debug((Object)("Get extension from file name [" + string + "]"));
        String string2 = null;
        if (string != null && (n = string.lastIndexOf(46)) >= 0 && n < string.length() - 1) {
            string2 = string.substring(n).toLowerCase();
        }
        a.debug((Object)("Extension [" + string2 + "]"));
        return string2;
    }

    public static String e(String string) {
        String string2 = string;
        if (string != null && string.startsWith(".kal_")) {
            string2 = ".kal";
        }
        return string2;
    }

    public static boolean a(String string, String string2, InputStream inputStream) {
        a.debug((Object)"Checking if file is encrypted");
        boolean bl = "application/x-tika-ole-drm-encrypted".equalsIgnoreCase(string2);
        if ("application/x-tika-msoffice".equalsIgnoreCase(string2)) {
            if (".QBB".equalsIgnoreCase(string) || ".RPT".equalsIgnoreCase(string)) {
                bl = true;
            } else {
                try (POIFSFileSystem pOIFSFileSystem = new POIFSFileSystem(inputStream);){
                    for (Entry entry : pOIFSFileSystem.getRoot()) {
                        if (!"EncryptedPackage".equals(entry.getName())) continue;
                        bl = true;
                        break;
                    }
                }
                catch (IOException iOException) {
                    a.error((Object)"Error while trying to create POIFSFileSystem from input stream", (Throwable)iOException);
                }
            }
        }
        a.debug((Object)("Is encrypted? [" + bl + "]"));
        return bl;
    }
}

