/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.servlet;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.rest.beans.SpaceQuotaBean;
import com.akelesconsulting.confluence.plugins.utils.QuotaHelper;
import com.atlassian.confluence.core.ListBuilder;
import com.atlassian.confluence.plugin.services.VelocityHelperService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

public class QuotaSummaryServlet
extends HttpServlet {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.servlet.QuotaSummaryServlet");
    private final AttachmentCheckerConfig b;
    private final I18nResolver c;
    private final LoginUriProvider d;
    private final PermissionManager e;
    private final QuotaHelper f;
    private final SpaceManager g;
    private final VelocityHelperService h;

    public QuotaSummaryServlet(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PermissionManager permissionManager, QuotaHelper quotaHelper, @ComponentImport SpaceManager spaceManager, @ComponentImport VelocityHelperService velocityHelperService) {
        this.b = attachmentCheckerConfig;
        this.c = i18nResolver;
        this.d = loginUriProvider;
        this.e = permissionManager;
        this.f = quotaHelper;
        this.g = spaceManager;
        this.h = velocityHelperService;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        a.debug((Object)"Download quota summary");
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser == null) {
            a.debug((Object)"User is not logged in");
            this.a(httpServletRequest, httpServletResponse);
            return;
        }
        if (!this.e.isSystemAdministrator((User)confluenceUser)) {
            a.debug((Object)("User does not have sysadmin permission to download quota summary [" + confluenceUser + "]"));
            this.a(httpServletResponse);
            return;
        }
        try (XSSFWorkbook xSSFWorkbook = new XSSFWorkbook();
             ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            String string = this.a(httpServletRequest, "query").toLowerCase();
            String string2 = this.a(httpServletRequest, "allocation");
            String string3 = this.a(httpServletRequest, "usage");
            String string4 = this.a(httpServletRequest, "spaceType");
            a.debug((Object)("Query [" + string + "] allocation [" + string2 + "] usage [" + string3 + "] space type [" + string4 + "]"));
            this.a(xSSFWorkbook, string, string2, string3, string4);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String string5 = new SimpleDateFormat("yyyyMMdd-HHmmss").format(timestamp);
            a.debug((Object)("Quota summary generated on [" + string5 + "]"));
            a.debug((Object)"Writing to response output stream");
            httpServletResponse.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            httpServletResponse.setHeader("Pragma", "private");
            httpServletResponse.setHeader("Cache-Control", "cache, must-revalidate");
            httpServletResponse.setHeader("Content-Disposition", "attachment; filename=quotasummary-" + string5 + ".xlsx");
            xSSFWorkbook.write((OutputStream)servletOutputStream);
            servletOutputStream.flush();
        }
        catch (IOException iOException) {
            a.error((Object)"Error downloading quota summary", (Throwable)iOException);
        }
    }

    private void a(@NotNull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            StringBuilder stringBuilder = new StringBuilder(httpServletRequest.getRequestURL().toString());
            if (httpServletRequest.getQueryString() != null) {
                stringBuilder.append("?");
                stringBuilder.append(httpServletRequest.getQueryString());
            }
            URI uRI = URI.create(stringBuilder.toString());
            httpServletResponse.sendRedirect(this.d.getLoginUri(uRI).toString());
        }
        catch (IOException iOException) {
            a.error((Object)"Error redirecting to login", (Throwable)iOException);
        }
    }

    private void a(@NotNull HttpServletResponse httpServletResponse) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pageTitle", this.c.getText("com.akeles.acc.quota.summary.title"));
            hashMap.put("errorTitle", this.c.getText("errors.occurred"));
            hashMap.put("errorMessage", this.c.getText("com.akeles.acc.quota.summary.export.sysadmin.required"));
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.write(this.h.getRenderedTemplate("templates/errorMessage.vm", hashMap));
            printWriter.close();
        }
        catch (IOException iOException) {
            a.error((Object)"Error writing response", (Throwable)iOException);
        }
    }

    @NotNull
    private String a(@NotNull HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public void a(@NotNull XSSFWorkbook xSSFWorkbook, String string, String string2, String string3, String string4) {
        a.debug((Object)"Adding data");
        String string5 = this.b.getUnit();
        XSSFSheet xSSFSheet = xSSFWorkbook.createSheet(this.c.getText("com.akeles.acc.quota.summary.title"));
        XSSFRow xSSFRow = xSSFSheet.createRow(0);
        xSSFRow.createCell(0).setCellValue(this.c.getText("space-key"));
        xSSFRow.createCell(1).setCellValue(this.c.getText("space-name"));
        xSSFRow.createCell(2).setCellValue(this.c.getText("com.akeles.acc.quota.allocated") + " (" + string5 + ")");
        xSSFRow.createCell(3).setCellValue(this.c.getText("com.akeles.acc.quota.used") + " (" + string5 + ")");
        xSSFRow.createCell(4).setCellValue(this.c.getText("com.akeles.acc.quota.available") + " (" + string5 + ")");
        XSSFDataFormat xSSFDataFormat = xSSFWorkbook.createDataFormat();
        XSSFCellStyle xSSFCellStyle = xSSFWorkbook.createCellStyle();
        xSSFCellStyle.setDataFormat(xSSFDataFormat.getFormat("0.00"));
        ListBuilder listBuilder = this.g.getSpaces(SpacesQuery.newQuery().sortBy("key").build());
        List list = listBuilder.getRange(0, listBuilder.getAvailableSize() - 1);
        int n = 0;
        for (Space space : list) {
            SpaceQuotaBean spaceQuotaBean;
            String string6 = space.getKey();
            String string7 = space.getName();
            if (!this.f.a(space, string) || !this.f.b(space, string4) || (spaceQuotaBean = this.f.a(space)) == null || !this.f.a(spaceQuotaBean, string2) || !this.f.b(spaceQuotaBean, string3)) continue;
            a.debug((Object)("Creating row for space key [" + string6 + "]"));
            XSSFRow xSSFRow2 = xSSFSheet.createRow(++n);
            xSSFRow2.createCell(0).setCellValue(string6);
            xSSFRow2.createCell(1).setCellValue(string7);
            XSSFCell xSSFCell = xSSFRow2.createCell(2);
            XSSFCell xSSFCell2 = xSSFRow2.createCell(3);
            XSSFCell xSSFCell3 = xSSFRow2.createCell(4);
            xSSFCell2.setCellValue(spaceQuotaBean.getQuotaUsed());
            xSSFCell2.setCellStyle((CellStyle)xSSFCellStyle);
            xSSFCell.setCellValue(spaceQuotaBean.getQuotaAllocated());
            xSSFCell.setCellStyle((CellStyle)xSSFCellStyle);
            xSSFCell3.setCellValue(spaceQuotaBean.getQuotaAvailable());
            xSSFCell3.setCellStyle((CellStyle)xSSFCellStyle);
        }
        xSSFSheet.autoSizeColumn(0);
        xSSFSheet.autoSizeColumn(1);
        xSSFSheet.autoSizeColumn(2);
        xSSFSheet.autoSizeColumn(3);
        xSSFSheet.autoSizeColumn(4);
        a.debug((Object)("Added [" + n + "] data row(s)"));
    }
}

