/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.ao.service.VirusScanErrorService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.notification.MailService;
import com.akelesconsulting.confluence.plugins.rest.beans.VirusScanErrorBean;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.AttachmentHelper;
import com.akelesconsulting.confluence.plugins.utils.StreamGobbler;
import com.akelesconsulting.confluence.plugins.utils.VirusScanningJobHelper;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.VirusScanningJobRunner");
    public static final JobRunnerKey a = JobRunnerKey.of((String)VirusScanningJobRunner.class.getName());
    public static final JobId b = JobId.of((String)VirusScanningJobRunner.class.getName());
    public static final long c = 60000L;
    private final AccessModeCompatService e;
    private final AssignedNodeService f;
    private final AttachmentCheckerConfig g;
    private final AttachmentHelper h;
    private final AttachmentToScanService i;
    private final ClusterManager j;
    private final MailService k;
    private final VirusScanErrorService l;
    private final VirusScanningJobHelper m;

    @Inject
    public VirusScanningJobRunner(AccessModeCompatService accessModeCompatService, AssignedNodeService assignedNodeService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentHelper attachmentHelper, AttachmentToScanService attachmentToScanService, @ComponentImport ClusterManager clusterManager, MailService mailService, VirusScanErrorService virusScanErrorService, VirusScanningJobHelper virusScanningJobHelper) {
        this.e = accessModeCompatService;
        this.f = assignedNodeService;
        this.g = attachmentCheckerConfig;
        this.h = attachmentHelper;
        this.i = attachmentToScanService;
        this.j = clusterManager;
        this.k = mailService;
        this.l = virusScanErrorService;
        this.m = virusScanningJobHelper;
        d.setLevel(Level.INFO);
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        long l;
        long l2;
        AttachmentToScan[] attachmentToScanArray;
        if (!this.g.f() && !this.g.g()) {
            d.debug((Object)"Missing File Check and Virus Scanning disabled!");
            return JobRunnerResponse.success();
        }
        d.info((Object)"Running scheduled job: VirusScanningJob");
        if (this.e.isReadOnlyAccessModeEnabled()) {
            d.info((Object)"Read-only access mode enabled! Abort virus scanning job!");
            return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled!");
        }
        String string = null;
        if (this.j.isClustered() && (attachmentToScanArray = this.j.getThisNodeInformation()) != null) {
            string = attachmentToScanArray.getAnonymizedNodeIdentifier();
        }
        d.debug((Object)("Node id [" + string + "]"));
        if (this.f.b(string)) {
            return JobRunnerResponse.aborted((String)("Virus scanning is paused in current node [" + string + "]"));
        }
        d.debug((Object)"Checking queue...");
        attachmentToScanArray = this.a(string);
        long l3 = System.nanoTime();
        if (attachmentToScanArray.length > 0) {
            this.a(attachmentToScanArray, string);
        }
        if ((l2 = TimeUnit.NANOSECONDS.toMillis(l = System.nanoTime()) - TimeUnit.NANOSECONDS.toMillis(l3)) < 30000L) {
            long l4 = 10000L - l2;
            if (l4 > 0L) {
                this.a(l4);
            }
            d.debug((Object)"Checking queue again...");
            attachmentToScanArray = this.a(string);
            if (attachmentToScanArray.length > 0) {
                this.a(attachmentToScanArray, string);
            }
        }
        d.info((Object)"End of scheduled job: VirusScanningJob");
        return JobRunnerResponse.success();
    }

    private void a(long l) {
        try {
            d.debug((Object)("Sleep " + l));
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            d.error((Object)"Interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
    }

    private AttachmentToScan @NotNull [] a(String string) {
        AttachmentToScan[] attachmentToScanArray;
        if (string == null) {
            attachmentToScanArray = this.i.getAttachmentToScan();
            d.info((Object)("Total AttachmentToScan count [" + this.i.getAttachmentToScanCount() + "]"));
            d.info((Object)("Retrieved AttachmentToScan count [" + attachmentToScanArray.length + "]"));
        } else {
            attachmentToScanArray = this.i.b(string);
            d.info((Object)("[" + string + "] Total AttachmentToScan count [" + this.i.a(string) + "]"));
            d.info((Object)("[" + string + "] Retrieved AttachmentToScan count [" + attachmentToScanArray.length + "]"));
        }
        return attachmentToScanArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(AttachmentToScan[] attachmentToScanArray, String string) {
        boolean bl = this.g.f();
        boolean bl2 = this.g.g();
        String string2 = this.g.getScannerPath();
        String string3 = this.g.getScannerOption();
        for (AttachmentToScan attachmentToScan : attachmentToScanArray) {
            long l = attachmentToScan.getAttachmentId();
            int n = attachmentToScan.getVersion();
            long l2 = attachmentToScan.getAttachedToId();
            Date date = attachmentToScan.getCreationDate();
            d.info((Object)("Attachment id [" + l + "] version [" + n + "] attached to id [" + l2 + "] with entity id [" + attachmentToScan.getID() + "]"));
            Attachment attachment = this.h.a(l, n, date);
            d.debug((Object)("Retrieved attachment [" + attachment + "]"));
            if (attachment != null) {
                File file;
                block6: {
                    d.debug((Object)"Retrieved attachment is not null!");
                    file = null;
                    try {
                        file = this.m.a(attachment);
                        if (!bl2) break block6;
                        this.a(attachment, attachmentToScan, file, string2, string3, string);
                    }
                    catch (NullPointerException nullPointerException) {
                        block7: {
                            try {
                                d.error((Object)"NPE while getting attachment data", (Throwable)nullPointerException);
                                if (!bl) break block7;
                                this.a(attachment, attachmentToScan);
                            }
                            catch (Throwable throwable) {
                                AttachmentCheckerHelper.a(file);
                                throw throwable;
                            }
                        }
                        AttachmentCheckerHelper.a(file);
                    }
                }
                AttachmentCheckerHelper.a(file);
            }
            this.i.a(attachmentToScan);
            if (this.b(string)) break;
        }
    }

    private void a(Attachment attachment, @NotNull AttachmentToScan attachmentToScan) {
        boolean bl = this.g.h();
        boolean bl2 = this.g.j();
        boolean bl3 = this.g.k();
        boolean bl4 = this.h.a(bl, attachmentToScan.getAttachmentId(), attachmentToScan.getVersion(), attachmentToScan.getCreationDate());
        if (this.g.a()) {
            String string = this.m.a(attachment.getFileName(), attachment.getCreator(), true, bl, bl2, bl3, bl4);
            this.m.a(string, attachmentToScan.getAttachedToId(), this.g.getVirusAlertActorUser());
        }
    }

    private boolean b(String string) {
        boolean bl = false;
        if (this.f.b(string)) {
            d.info((Object)("Virus scanning is paused in current node [" + string + "]. Stopping job..."));
            bl = true;
        } else if (this.e.isReadOnlyAccessModeEnabled()) {
            d.info((Object)"Read-only access mode is enabled. Stopping job...");
            bl = true;
        }
        return bl;
    }

    private void a(@NotNull Attachment attachment, AttachmentToScan attachmentToScan, File file, String string, String string2, String string3) {
        if (file == null) {
            d.debug((Object)"Temp file is null!");
            return;
        }
        String string4 = attachment.getFileName();
        d.info((Object)("Scanning [" + string4 + "]"));
        ConfluenceUser confluenceUser = attachment.getCreator();
        long l = attachment.getId();
        Date date = new Date();
        boolean bl = false;
        try {
            String string5 = file.getCanonicalPath();
            Object[] objectArray = this.a(string, string2, string5, attachment);
            d.info((Object)("Executing [" + Arrays.toString(objectArray) + "]"));
            ProcessBuilder processBuilder = new ProcessBuilder((String[])objectArray).redirectErrorStream(true);
            Process process = processBuilder.start();
            StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), "OUTPUT", true);
            streamGobbler.start();
            int n = process.waitFor();
            d.info((Object)("Exit status code [" + n + "]"));
            if (attachment.getCreationDate() == null) {
                d.debug((Object)"Attachment creation date is null!");
                String string6 = this.m.a(string4, attachmentToScan.getVersion(), confluenceUser);
                this.m.a(string6, attachmentToScan.getAttachedToId(), this.g.getVirusAlertActorUser());
            }
            if (n != 0) {
                String string7;
                boolean bl2;
                boolean bl3;
                boolean bl4 = this.g.a(n, string);
                boolean bl5 = this.g.h();
                boolean bl6 = this.g.j();
                if (bl4) {
                    d.debug((Object)("Infected attachment [" + string4 + "] id [" + l + "] found"));
                    bl3 = bl5;
                    bl2 = this.g.i();
                    d.debug((Object)("Delete if infected? [" + bl3 + "]"));
                    d.debug((Object)("Email if infected? [" + bl2 + "]"));
                } else {
                    d.debug((Object)"Exit code is not virus code!");
                    bl3 = bl6;
                    bl2 = this.g.k();
                    d.debug((Object)("Delete if error? [" + bl3 + "]"));
                    d.debug((Object)("Email if error? [" + bl2 + "]"));
                }
                this.a(streamGobbler);
                VirusScanErrorBean virusScanErrorBean = new VirusScanErrorBean(string3, n, bl4, streamGobbler.getOutput());
                Integer n2 = this.l.a(attachment, attachmentToScan, virusScanErrorBean, date);
                bl = this.f.a(string3, n2);
                boolean bl7 = this.h.a(bl3, attachmentToScan.getAttachmentId(), attachmentToScan.getVersion(), attachmentToScan.getCreationDate());
                if (bl2) {
                    string7 = this.a(string, string2, attachment, attachmentToScan);
                    d.debug((Object)("Manual scan command [" + string7 + "]"));
                    this.k.a(bl4, bl7, n, string4, string7, attachmentToScan.getAttachedToId(), attachment);
                }
                if (this.g.a()) {
                    string7 = this.m.a(string4, confluenceUser, bl4, bl5, bl6, bl2, bl7);
                    this.m.a(string7, attachmentToScan.getAttachedToId(), this.g.getVirusAlertActorUser());
                }
            }
        }
        catch (IOException iOException) {
            d.error((Object)"Error executing process", (Throwable)iOException);
            VirusScanErrorBean virusScanErrorBean = new VirusScanErrorBean(string3, -1, false, iOException.getMessage());
            Integer n = this.l.a(attachment, attachmentToScan, virusScanErrorBean, date);
            bl = this.f.a(string3, n);
        }
        catch (InterruptedException interruptedException) {
            d.error((Object)"Process interrupted", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
        }
        if (bl) {
            this.k.a(string3);
        }
    }

    private void a(StreamGobbler streamGobbler) {
        for (int i = 0; i < 5 && streamGobbler.isAlive(); ++i) {
            this.a(1000L);
        }
    }

    private String[] a(String string, String string2, String string3, Attachment attachment) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (!string2.equals("")) {
            string2 = this.a(string2, attachment);
            String[] stringArray = string2.split(" ");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        arrayList.add(string3);
        return arrayList.toArray(new String[0]);
    }

    @NotNull
    private String a(String string, @NotNull String string2, @NotNull Attachment attachment, @NotNull AttachmentToScan attachmentToScan) {
        d.debug((Object)"Get manual scan command");
        long l = attachmentToScan.getAttachedToId();
        long l2 = attachmentToScan.getAttachmentId();
        int n = attachment.getVersion();
        String string3 = this.h.a(attachment, l2, n, l);
        return string + " " + (string2.isEmpty() ? "" : this.a(string2, attachment) + " ") + string3;
    }

    @NotNull
    private String a(@NotNull String string, @NotNull Attachment attachment) {
        string = string.replace("${attachment.id}", attachment.getIdAsString());
        ConfluenceUser confluenceUser = attachment.getCreator();
        string = string.replace("${attachment.creator.name}", confluenceUser == null ? "Anonymous" : confluenceUser.getName());
        return string;
    }
}

