/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.notification.MailService;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class VirusScanningEmailJobRunner
implements JobRunner {
    private static final Logger e = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.VirusScanningEmailJobRunner");
    public static final String a = "com.akeles.plugins.acc.scheduler.job.VirusScanningEmailJobRunner.lock";
    public static final JobRunnerKey b = JobRunnerKey.of((String)VirusScanningEmailJobRunner.class.getName());
    public static final JobId c = JobId.of((String)VirusScanningEmailJobRunner.class.getName());
    public static final String d = "0 0 9 * * ?";
    private final AssignedNodeService f;
    private final AttachmentCheckerConfig g;
    private final ClusterLockService h;
    private final ClusterManager i;
    private final MailService j;

    public VirusScanningEmailJobRunner(AssignedNodeService assignedNodeService, AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport ClusterLockService clusterLockService, @ComponentImport ClusterManager clusterManager, MailService mailService) {
        this.f = assignedNodeService;
        this.g = attachmentCheckerConfig;
        this.h = clusterLockService;
        this.i = clusterManager;
        this.j = mailService;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        e.debug((Object)"Running scheduled job: VirusScanningEmailJob");
        if (this.g.a()) {
            e.debug((Object)"Virus scanning comment is enabled. No email required.");
        } else if (!this.f.a()) {
            e.debug((Object)"No errors for all nodes. No email required.");
        } else if (this.a()) {
            try {
                this.j.a();
            }
            finally {
                this.g.setIsVirusScanningEmailJobRunning(false);
                this.g.setVirusScanningEmailJobNodeId("");
            }
        }
        e.debug((Object)"End of scheduled job: VirusScanningEmailJob");
        return JobRunnerResponse.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a() {
        boolean bl;
        block11: {
            bl = false;
            if (this.i.isClustered()) {
                e.debug((Object)"Instance is clustered!");
                ClusterLock clusterLock = this.h.getLockForName(a);
                try {
                    e.debug((Object)"Getting cluster lock...");
                    if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                        e.debug((Object)"Cluster lock acquired!");
                        try {
                            String string = null;
                            ClusterNodeInformation clusterNodeInformation = this.i.getThisNodeInformation();
                            if (clusterNodeInformation != null) {
                                string = clusterNodeInformation.getAnonymizedNodeIdentifier();
                            }
                            String string2 = this.g.getVirusScanningEmailJobNodeId();
                            e.debug((Object)("Current node ID [" + string + "]"));
                            e.debug((Object)("VirusScanningEmailJob node ID [" + string2 + "]"));
                            if (!this.g.b() || string2.isEmpty() || string2.equals(string) || !this.a(string2)) {
                                this.g.setIsVirusScanningEmailJobRunning(true);
                                this.g.setVirusScanningEmailJobNodeId(string);
                                bl = true;
                            } else {
                                e.debug((Object)("VirusScanningEmailJob is running on another node [" + string2 + "]"));
                            }
                            break block11;
                        }
                        finally {
                            clusterLock.unlock();
                            e.debug((Object)"Cluster lock released!");
                        }
                    }
                    e.debug((Object)"Unable to get cluster lock!");
                }
                catch (InterruptedException interruptedException) {
                    e.error((Object)"Interrupted when getting cluster lock", (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            } else {
                e.debug((Object)"Instance is not clustered!");
                bl = true;
            }
        }
        e.debug((Object)("Run VirusScanningEmailJob on current node? [" + bl + "]"));
        return bl;
    }

    private boolean a(String string) {
        boolean bl = this.i.getAllNodesInformation().stream().anyMatch(clusterNodeInformation -> clusterNodeInformation.getAnonymizedNodeIdentifier().equals(string));
        e.debug((Object)("Is node ID [" + string + "] alive? [" + bl + "]"));
        return bl;
    }
}

