/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.SpaceToUpdate;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceInfoService;
import com.akelesconsulting.confluence.plugins.ao.service.SpaceToUpdateService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.DateHelper;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.compat.api.service.accessmode.AccessModeCompatService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CalculateAttachmentJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.CalculateAttachmentJobRunner");
    private static final String e = CalculateAttachmentJobRunner.class.getName() + ".lock";
    public static final JobRunnerKey a = JobRunnerKey.of((String)CalculateAttachmentJobRunner.class.getName());
    public static final JobId b = JobId.of((String)CalculateAttachmentJobRunner.class.getName());
    public static final long c = 86400000L;
    private final AccessModeCompatService f;
    private final AttachmentCheckerConfig g;
    private final ClusterLockService h;
    private final SpaceInfoService i;
    private final SpaceToUpdateService j;
    private final TransactionTemplate k;

    @Autowired
    public CalculateAttachmentJobRunner(AccessModeCompatService accessModeCompatService, AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport ClusterLockService clusterLockService, SpaceInfoService spaceInfoService, SpaceToUpdateService spaceToUpdateService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.f = accessModeCompatService;
        this.g = attachmentCheckerConfig;
        this.h = clusterLockService;
        this.i = spaceInfoService;
        this.j = spaceToUpdateService;
        this.k = transactionTemplate;
        d.setLevel(Level.INFO);
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        block7: {
            if (this.f.isReadOnlyAccessModeEnabled()) {
                d.info((Object)"Read-only access mode enabled! Abort calculate attachment job!");
                return JobRunnerResponse.aborted((String)"Job aborted because read-only access mode is enabled!");
            }
            ClusterLock clusterLock = this.h.getLockForName(e);
            try {
                if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                    try {
                        d.info((Object)"--- Running CalculateAttachmentJob...");
                        this.a();
                        d.info((Object)"--- CalculateAttachmentJob completed!");
                        break block7;
                    }
                    finally {
                        clusterLock.unlock();
                    }
                }
                d.info((Object)"CalculateAttachmentJob is running on another instance!");
            }
            catch (InterruptedException interruptedException) {
                d.error((Object)"Interrupted while acquiring lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        return JobRunnerResponse.success();
    }

    private void a() {
        this.k.execute(() -> {
            this.g.setIsJobRunning(true);
            return null;
        });
        int n = (Integer)this.k.execute(this.i::getSpaceCount);
        int n2 = (Integer)this.k.execute(this.i::getSpaceInfoCalculatedCount);
        d.info((Object)("Space count [" + n + "]"));
        d.info((Object)("SpaceInfo (calculated) count [" + n2 + "]"));
        Calendar calendar = Calendar.getInstance();
        boolean bl = !this.g.getJobEndHour().equals("0");
        d.debug((Object)("Is end time set? [" + bl + "]"));
        Date date = this.a(bl, calendar);
        try {
            if ((Integer)this.k.execute(this.i::getSpaceInfoCount) > 0) {
                d.info((Object)"Deleting SpaceInfo if corresponding Space not found...");
                n2 = (Integer)this.k.execute(() -> {
                    this.i.b();
                    return this.i.getSpaceInfoCalculatedCount();
                });
                d.info((Object)("SpaceInfo (calculated) count after delete [" + n2 + "]"));
            }
            if (this.a(calendar, n, n2)) {
                d.info((Object)"Update all SpaceInfo status to pending recalculation...");
                this.k.execute(() -> {
                    this.i.a();
                    return null;
                });
                n2 = (Integer)this.k.execute(this.i::getSpaceInfoCalculatedCount);
            }
            if (n2 != n) {
                if (n2 == 0) {
                    this.k.execute(() -> {
                        this.g.setQuotaCalculationStartTime(new Date().getTime());
                        this.g.setQuotaCalculationEndTime(0L);
                        return null;
                    });
                }
                this.b(date);
                n2 = (Integer)this.k.execute(this.i::getSpaceInfoCalculatedCount);
                d.debug((Object)("SpaceInfo (calculated) count [" + n2 + "]"));
            }
        }
        catch (Exception exception) {
            d.error((Object)"Exception while calculating attachments", (Throwable)exception);
        }
        try {
            if (!this.a(date)) {
                this.c(date);
            }
        }
        catch (Exception exception) {
            d.error((Object)"Error updating attachments count in SpaceToUpdate queue", (Throwable)exception);
        }
        if (n2 == n) {
            this.b();
        }
        this.k.execute(() -> {
            this.g.setIsJobRunning(false);
            return null;
        });
    }

    private boolean a(@NotNull Calendar calendar, int n, int n2) {
        d.info((Object)("Now [" + calendar.getTime() + "]"));
        boolean bl = false;
        boolean bl2 = this.g.s();
        boolean bl3 = n2 == n;
        d.info((Object)("Is quota setup completed? [" + bl2 + "]"));
        d.info((Object)("Is quota calculation completed? [" + bl3 + "]"));
        if (bl2 && bl3) {
            Long l = this.g.getQuotaCalculationEndTime();
            d.info((Object)("Last calculation end time [" + l + "]"));
            if (l == null || l == 0L) {
                bl = true;
            } else {
                int n3 = this.g.getMonthsInterval();
                d.info((Object)("Months interval [" + n3 + "]"));
                Calendar calendar2 = DateHelper.a(l, n3, DateHelper.a(this.g.getJobStartHour(), this.g.getJobStartAmPm()), DateHelper.a(this.g.getJobStartMinute()));
                bl = calendar.equals(calendar2) || calendar.after(calendar2);
            }
        }
        d.info((Object)("Recalculate quota usage? [" + bl + "]"));
        return bl;
    }

    private void b() {
        this.k.execute(() -> {
            if (this.g.getQuotaCalculationEndTime() == 0L) {
                this.g.setQuotaCalculationEndTime(new Date().getTime());
            }
            if (!this.g.s()) {
                this.g.setIsQuotaSetupCompleted(true);
                if (!this.g.m() && this.g.q()) {
                    this.g.setQuotaCheck("on");
                }
            }
            return null;
        });
    }

    private boolean a(Date date) {
        boolean bl = false;
        if (this.f.isReadOnlyAccessModeEnabled()) {
            d.debug((Object)"Read-only access mode is enabled!");
            bl = true;
        } else if (date != null) {
            Date date2 = new Date();
            bl = !date2.before(date);
            d.debug((Object)("Is now [" + date2 + "] >= end time [" + date + "]? [" + bl + "]"));
        }
        d.debug((Object)("Stop job? [" + bl + "]"));
        return bl;
    }

    private Date a(boolean bl, Calendar calendar) {
        Date date = null;
        if (bl) {
            date = DateHelper.a(calendar.getTime(), this.g.getJobEndHour(), this.g.getJobEndMinute(), this.g.getJobEndAmPm());
            d.debug((Object)("Job will stop by [" + date + "] (approx.)"));
        }
        return date;
    }

    private void b(Date date) {
        d.info((Object)"Calculate attachments in spaces");
        List list = (List)this.k.execute(this.i::getSpaceList);
        d.info((Object)("Space count [" + list.size() + "]"));
        for (Space space : list) {
            this.k.execute(() -> {
                String string = space.getKey();
                d.info((Object)("Calculate attachments in space [" + string + "]"));
                this.i.a(space);
                return null;
            });
            if (!this.a(date)) continue;
            break;
        }
    }

    private void c(Date date) {
        d.info((Object)"Update attachments count in spaces");
        List list = (List)this.k.execute(this.j::getSpaceToUpdateList);
        d.info((Object)("SpaceToUpdate count [" + list.size() + "]"));
        for (SpaceToUpdate spaceToUpdate : list) {
            this.k.execute(() -> {
                String string = spaceToUpdate.getSpaceKey();
                d.info((Object)("Update attachments count in space [" + string + "]"));
                this.i.c(string);
                this.j.a(spaceToUpdate);
                return null;
            });
            if (!this.a(date)) continue;
            break;
        }
    }
}

