/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.scheduler.job;

import com.akelesconsulting.confluence.plugins.ao.entity.AssignedNode;
import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.service.AssignedNodeService;
import com.akelesconsulting.confluence.plugins.ao.service.AttachmentToScanService;
import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class AttachmentAssignmentJobRunner
implements JobRunner {
    private static final Logger d = Logger.getLogger((String)"com.akeles.plugins.acc.scheduler.AttachmentAssignmentJobRunner");
    private static final String e = "com.akeles.plugins.acc.scheduler.job.AttachmentAssignmentJobRunner.lock";
    public static final JobRunnerKey a = JobRunnerKey.of((String)AttachmentAssignmentJobRunner.class.getName());
    public static final JobId b = JobId.of((String)AttachmentAssignmentJobRunner.class.getName());
    public static final long c = 60000L;
    private final AssignedNodeService f;
    private final AttachmentCheckerConfig g;
    private final AttachmentToScanService h;
    private final ClusterLockService i;
    private final ClusterManager j;

    @Inject
    public AttachmentAssignmentJobRunner(AssignedNodeService assignedNodeService, AttachmentCheckerConfig attachmentCheckerConfig, AttachmentToScanService attachmentToScanService, @ComponentImport ClusterLockService clusterLockService, @ComponentImport ClusterManager clusterManager) {
        this.f = assignedNodeService;
        this.g = attachmentCheckerConfig;
        this.h = attachmentToScanService;
        this.i = clusterLockService;
        this.j = clusterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest jobRunnerRequest) {
        d.debug((Object)"Running scheduled job: AttachmentAssignmentJobRunner");
        if (this.a()) {
            try {
                List<AttachmentToScan> list;
                List<String> list2 = this.j.getAllNodesInformation().stream().map(ClusterNodeInformation::getAnonymizedNodeIdentifier).collect(Collectors.toList());
                d.debug((Object)("Active nodes count [" + list2.size() + "]"));
                List<String> list3 = this.f.getAllAssignedNodes().stream().map(AssignedNode::getNodeId).filter(string -> !list2.contains(string)).collect(Collectors.toList());
                d.debug((Object)("Inactive nodes count [" + list3.size() + "]"));
                List<AssignedNodeBean> list4 = this.a(list2);
                list4 = list4.stream().filter(assignedNodeBean -> {
                    if (((AssignedNodeBean)assignedNodeBean).g) {
                        d.debug((Object)("Virus scanning paused in node ID [" + ((AssignedNodeBean)assignedNodeBean).b + "]"));
                        list3.add(((AssignedNodeBean)assignedNodeBean).b);
                    }
                    return !((AssignedNodeBean)assignedNodeBean).g;
                }).collect(Collectors.toList());
                boolean bl = list4.stream().allMatch(assignedNodeBean -> ((AssignedNodeBean)assignedNodeBean).f);
                d.debug((Object)("Is all queue full now? [" + bl + "]"));
                if (!list3.isEmpty()) {
                    list = this.h.a(list3);
                    d.debug((Object)("Has attachments to reassign? [" + !list.isEmpty() + "]"));
                    while (!list.isEmpty() && !bl) {
                        d.debug((Object)("Retrieved [" + list.size() + "] attachments to reassign"));
                        this.a(list4, list);
                        list = this.h.a(list3);
                        bl = list4.stream().allMatch(assignedNodeBean -> ((AssignedNodeBean)assignedNodeBean).f);
                    }
                }
                list = this.h.getAttachmentsToAssign();
                d.debug((Object)("Has attachments to assign? [" + !list.isEmpty() + "]"));
                while (!list.isEmpty() && !bl) {
                    d.debug((Object)("Retrieved [" + list.size() + "] attachments to assign"));
                    this.a(list4, list);
                    list = this.h.getAttachmentsToAssign();
                    bl = list4.stream().allMatch(assignedNodeBean -> ((AssignedNodeBean)assignedNodeBean).f);
                }
                for (AssignedNodeBean assignedNodeBean2 : list4) {
                    this.f.a(assignedNodeBean2.a, assignedNodeBean2.d + assignedNodeBean2.e);
                }
            }
            finally {
                this.g.setIsAttachmentAssignmentJobRunning(false);
                this.g.setAttachmentAssignmentJobNodeId("");
            }
        }
        d.debug((Object)"End of scheduled job: AttachmentAssignmentJobRunner");
        return JobRunnerResponse.success();
    }

    @NotNull
    private List<AssignedNodeBean> a(@NotNull List<String> list) {
        ArrayList<AssignedNode> arrayList = new ArrayList<AssignedNode>();
        ArrayList<AssignedNodeBean> arrayList2 = new ArrayList<AssignedNodeBean>();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        for (String string : list) {
            AssignedNode assignedNode = this.f.a(string);
            if (assignedNode == null) {
                d.debug((Object)("AssignedNode is null for node id [" + string + "]"));
                continue;
            }
            int n = assignedNode.getBucketSize();
            int n2 = assignedNode.getLastQueueCount();
            int n3 = this.h.a(string);
            arrayList2.add(new AssignedNodeBean(assignedNode, n3, assignedNode.getIsPaused()));
            arrayList.add(assignedNode);
            d.debug((Object)("Node id [" + string + "]"));
            d.debug((Object)("Bucket size [" + n + "]"));
            d.debug((Object)("Last queue count [" + n2 + "]"));
            d.debug((Object)("Current queue count [" + n3 + "]"));
            if (n2 < n) {
                bl = false;
            }
            if (n3 > 0) {
                bl2 = false;
            }
            if (n3 > 10) continue;
            bl3 = false;
        }
        d.debug((Object)("Is all queue full previously? [" + bl + "]"));
        d.debug((Object)("Is all queue empty now? [" + bl2 + "]"));
        d.debug((Object)("Is all queue > 10 now? [" + bl3 + "]"));
        if (bl && bl2) {
            this.f.a(arrayList);
        } else if (bl3) {
            this.f.b(arrayList);
        }
        return arrayList2;
    }

    private void a(@NotNull List<AssignedNodeBean> list, @NotNull List<AttachmentToScan> list2) {
        ListIterator<AttachmentToScan> listIterator = new ArrayList<AttachmentToScan>(list2).listIterator();
        for (AssignedNodeBean assignedNodeBean : list) {
            String string = assignedNodeBean.b;
            int n = 0;
            int n2 = assignedNodeBean.c - assignedNodeBean.d;
            if (n2 > 0) {
                while (listIterator.hasNext()) {
                    AttachmentToScan attachmentToScan = listIterator.next();
                    this.h.a(attachmentToScan, string);
                    d.debug((Object)("AttachmentToScan id [" + attachmentToScan.getID() + "] assigned to node [" + string + "]"));
                    listIterator.remove();
                    if (++n != n2) continue;
                    assignedNodeBean.setIsQueueFull(true);
                    break;
                }
            }
            assignedNodeBean.a(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a() {
        boolean bl;
        block10: {
            if (!this.j.isClustered()) {
                d.debug((Object)"Instance is not clustered, assignment not required!");
                return false;
            }
            bl = false;
            d.debug((Object)"Instance is clustered!");
            ClusterLock clusterLock = this.i.getLockForName(e);
            try {
                d.debug((Object)"Getting cluster lock...");
                if (clusterLock.tryLock(3L, TimeUnit.SECONDS)) {
                    d.debug((Object)"Cluster lock acquired!");
                    try {
                        String string = null;
                        ClusterNodeInformation clusterNodeInformation = this.j.getThisNodeInformation();
                        if (clusterNodeInformation != null) {
                            string = clusterNodeInformation.getAnonymizedNodeIdentifier();
                        }
                        String string2 = this.g.getAttachmentAssignmentJobNodeId();
                        d.debug((Object)("Current node id [" + string + "]"));
                        d.debug((Object)("Job node id [" + string2 + "]"));
                        if (!this.g.l() || !this.a(string2) || string2.equals(string)) {
                            this.g.setIsAttachmentAssignmentJobRunning(true);
                            this.g.setAttachmentAssignmentJobNodeId(string);
                            bl = true;
                        } else {
                            d.debug((Object)("Assignment job is running on another node [" + string2 + "]"));
                        }
                        break block10;
                    }
                    finally {
                        clusterLock.unlock();
                        d.debug((Object)"Cluster lock released!");
                    }
                }
                d.debug((Object)"Unable to get cluster lock!");
            }
            catch (InterruptedException interruptedException) {
                d.error((Object)"Interrupted when getting cluster lock", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        d.debug((Object)("Run assignment job on current node? [" + bl + "]"));
        return bl;
    }

    private boolean a(String string) {
        boolean bl = false;
        for (ClusterNodeInformation clusterNodeInformation : this.j.getAllNodesInformation()) {
            if (!clusterNodeInformation.getAnonymizedNodeIdentifier().equals(string)) continue;
            bl = true;
            break;
        }
        d.debug((Object)("Is node id [" + string + "] alive? [" + bl + "]"));
        return bl;
    }

    private static class AssignedNodeBean
    implements Serializable {
        private final int a;
        private final String b;
        private final int c;
        private final int d;
        private int e;
        private boolean f;
        private final boolean g;

        public AssignedNodeBean(@NotNull AssignedNode assignedNode, int n, boolean bl) {
            this.a = assignedNode.getID();
            this.b = assignedNode.getNodeId();
            this.c = assignedNode.getBucketSize();
            this.d = n;
            this.e = 0;
            this.f = n >= assignedNode.getBucketSize();
            this.g = bl;
        }

        public void a(int n) {
            this.e += n;
        }

        public void setIsQueueFull(boolean bl) {
            this.f = bl;
        }
    }
}

