/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.filter;

import com.akelesconsulting.confluence.plugins.config.AttachmentCheckerConfig;
import com.akelesconsulting.confluence.plugins.utils.AttachmentCheckerHelper;
import com.akelesconsulting.confluence.plugins.utils.FileTypeHelper;
import com.akelesconsulting.confluence.plugins.utils.SmartRequestWrapper;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.web.util.HtmlUtils;

@AnonymousSiteAccess
public class AttachmentCheckerFilter
implements Filter {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.filter.AttachmentCheckerFilter");
    private static final String b = "/pages/doattachfile.action";
    private static final String c = "/pages/plugins/attachments/doattachfile.action";
    private static final int d = 0;
    private static final int e = -1;
    private static final int f = -2;
    private static final int g = -3;
    private final AttachmentCheckerConfig h;
    private final Gson i;
    private final I18nResolver j;
    private final SpaceManager k;

    public AttachmentCheckerFilter(AttachmentCheckerConfig attachmentCheckerConfig, @ComponentImport I18nResolver i18nResolver, @ComponentImport SpaceManager spaceManager) {
        this.h = attachmentCheckerConfig;
        this.i = new Gson();
        this.j = i18nResolver;
        this.k = spaceManager;
    }

    public void init(FilterConfig filterConfig) {
        a.debug((Object)"Initializing AttachmentCheckerFilter...");
    }

    public void destroy() {
        a.debug((Object)"Stopping AttachmentCheckerFilter...");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        a.debug((Object)"*** START OF REQUEST ***");
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
            String string = httpServletRequest.getRequestURI();
            a.debug((Object)("Request uri [" + string + "]"));
            if (httpServletRequest.getMethod().equals("POST")) {
                this.a(httpServletRequest, httpServletResponse, filterChain);
            } else {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        a.debug((Object)"*** END OF REQUEST ***");
    }

    private void a(@NotNull HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        Object object;
        int n;
        SmartRequestWrapper smartRequestWrapper;
        String string = httpServletRequest.getRequestURL().toString().toLowerCase();
        a.debug((Object)("Request url [" + string + "]"));
        SmartRequestWrapper smartRequestWrapper2 = smartRequestWrapper = new SmartRequestWrapper(httpServletRequest);
        boolean bl = string.contains(b);
        boolean bl2 = string.contains("confiforms");
        boolean bl3 = string.contains("/rest/api");
        boolean bl4 = ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest);
        a.debug((Object)("Is ConfiForms? [" + bl2 + "]"));
        a.debug((Object)("Is rest api? [" + bl3 + "]"));
        a.debug((Object)("Is multipart? [" + bl4 + "]"));
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Map<String, String>> arrayList2 = new ArrayList<Map<String, String>>();
        if (bl3) {
            n = this.a(smartRequestWrapper, bl, bl2, (List<Map<String, String>>)arrayList2, (List<String>)arrayList);
        } else if (bl4) {
            try {
                object = new ServletActionContextCompatManager(ClassLoaderUtils.loadClass((String)"org.apache.struts2.ServletActionContext", this.getClass()).getClassLoader());
                smartRequestWrapper2 = (HttpServletRequestWrapper)object.getRequest();
                n = this.a((HttpServletRequestWrapper)smartRequestWrapper2, bl, bl2, arrayList2, arrayList);
            }
            catch (ClassNotFoundException classNotFoundException) {
                n = this.a(smartRequestWrapper, bl, bl2, (List<Map<String, String>>)arrayList2, (List<String>)arrayList);
            }
        } else {
            n = this.a(smartRequestWrapper, arrayList);
        }
        if (n == 0) {
            a.debug((Object)"Continuing request...");
            filterChain.doFilter((ServletRequest)smartRequestWrapper2, (ServletResponse)httpServletResponse);
            smartRequestWrapper.a();
        } else {
            a.debug((Object)"Intercepting request...");
            smartRequestWrapper.a();
            if (bl) {
                object = httpServletRequest.getContextPath() + "/plugins/servlet/upload-failure";
                a.debug((Object)("Redirecting to [" + (String)object + "]"));
                httpServletRequest.getSession().setAttribute("errorList", arrayList);
                httpServletRequest.getSession().setAttribute("attachmentList", (Object)this.i.toJson(arrayList2));
                httpServletResponse.sendRedirect((String)object);
            } else if (string.contains(c)) {
                object = "<div class=\"aui-message aui-message-error\"><p>" + (String)arrayList.get(0) + "</p></div>";
                this.a(httpServletResponse, (String)object);
            } else {
                httpServletResponse.setStatus(bl2 ? Response.Status.OK.getStatusCode() : Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
                object = this.a(arrayList, bl2);
                this.a(httpServletResponse, (JSONObject)object);
            }
        }
    }

    private int a(@NotNull HttpServletRequestWrapper httpServletRequestWrapper, boolean bl, boolean bl2, List<Map<String, String>> list, List<String> list2) {
        String string;
        a.debug((Object)"Checking Struts multipart request");
        int n = 0;
        long l = 0L;
        String string2 = this.a(httpServletRequestWrapper);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        MultiPartRequestWrapper multiPartRequestWrapper = (MultiPartRequestWrapper)httpServletRequestWrapper;
        Enumeration enumeration = multiPartRequestWrapper.getFileParameterNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            a.debug((Object)("File param name [" + string + "]"));
            UploadedFile[] uploadedFileArray = multiPartRequestWrapper.getFiles(string);
            String[] stringArray = multiPartRequestWrapper.getFileNames(string);
            for (int i = 0; i < uploadedFileArray.length; ++i) {
                Object object;
                Object object2;
                UploadedFile uploadedFile = uploadedFileArray[i];
                String string3 = stringArray[i];
                String string4 = FileTypeHelper.d(string3);
                a.debug((Object)("[" + string + "] file name [" + string3 + "]"));
                boolean bl3 = this.h.a(string4, false);
                boolean bl4 = false;
                File file = (File)uploadedFile.getContent();
                long l2 = 0L;
                try {
                    object2 = FileUtils.openInputStream((File)file);
                    object = FileTypeHelper.a(string3, (InputStream)object2);
                    a.debug((Object)("[" + string + "] mime type [" + (String)object + "]"));
                    bl4 = this.h.a(string4, (String)object, (InputStream)object2, false);
                    if (!bl3 || !bl4) {
                        n = -1;
                        list2.add(this.a(n, string3, bl2));
                    }
                    l2 = Files.size(file.toPath());
                    a.debug((Object)("[" + string + "] file size [" + l2 + "]"));
                    if (this.h.e() && this.h.a((String)object, l2, confluenceUser)) {
                        n = -3;
                        list2.add(this.a(n, string3, bl2));
                    }
                    l += l2;
                }
                catch (IOException iOException) {
                    a.error((Object)"IOException getting file input stream", (Throwable)iOException);
                }
                object2 = this.a(l2);
                object = new HashMap();
                object.put("name", string3);
                object.put("size", object2);
                object.put("isValid", Boolean.toString(bl3 && bl4));
                list.add((Map<String, String>)object);
            }
        }
        string = this.a(string2);
        n = this.a(n, string, l, bl, false, list2);
        a.debug((Object)("Status code [" + n + "]"));
        return n;
    }

    private int a(@NotNull SmartRequestWrapper smartRequestWrapper, boolean bl, boolean bl2, List<Map<String, String>> list, List<String> list2) {
        a.debug((Object)"Checking multipart request");
        int n = 0;
        long l = 0L;
        String string = this.a((HttpServletRequestWrapper)smartRequestWrapper);
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        List<FileItem> list3 = this.a(smartRequestWrapper);
        boolean bl3 = false;
        String string2 = this.a(list3);
        a.debug((Object)("Comment [" + string2 + "]"));
        for (FileItem fileItem : list3) {
            String string3 = fileItem.getName();
            String string4 = fileItem.getFieldName();
            if (!fileItem.isFormField() && !string3.isEmpty()) {
                String string5 = FilenameUtils.getName((String)string3);
                String string6 = FileTypeHelper.d(string5);
                a.debug((Object)("File name [" + string5 + "]"));
                a.debug((Object)("File ext. [" + string6 + "]"));
                InputStream inputStream = this.a(fileItem);
                String string7 = FileTypeHelper.a(string5, inputStream);
                a.debug((Object)("MIME type [" + string7 + "]"));
                bl3 = this.h.c(string6, string7, string2);
                boolean bl4 = this.h.a(string6, bl3);
                boolean bl5 = this.h.a(string6, string7, (InputStream)smartRequestWrapper.getInputStream(), bl3);
                if (!bl4 || !bl5) {
                    n = -1;
                    list2.add(this.a(n, string5, bl2));
                }
                long l2 = fileItem.getSize();
                a.debug((Object)("File size [" + l2 + "]"));
                if (!bl3 && this.h.e() && this.h.a(string7, l2, confluenceUser)) {
                    n = -3;
                    list2.add(this.a(n, string5, bl2));
                }
                l += l2;
                String string8 = this.a(fileItem.getSize());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("name", string5);
                hashMap.put("size", string8);
                hashMap.put("isValid", Boolean.toString(bl4 && bl5));
                list.add(hashMap);
                continue;
            }
            if (!string4.equalsIgnoreCase("contentId") && !string4.equalsIgnoreCase("pageId")) continue;
            string = fileItem.getString();
        }
        String string9 = this.a(string);
        n = this.a(n, string9, l, bl, bl3, list2);
        a.debug((Object)("Status code [" + n + "]"));
        return n;
    }

    private String a(@NotNull List<FileItem> list) {
        FileItem fileItem2 = list.stream().filter(fileItem -> "comment".equalsIgnoreCase(fileItem.getFieldName())).findFirst().orElse(null);
        return fileItem2 == null ? "" : fileItem2.getString();
    }

    private String a(@NotNull HttpServletRequestWrapper httpServletRequestWrapper) {
        String string;
        String string2 = httpServletRequestWrapper.getParameter("pageId");
        if (string2 == null) {
            string2 = httpServletRequestWrapper.getParameter("contentId");
        }
        if (string2 == null && (string = httpServletRequestWrapper.getRequestURI()).startsWith("/rest/api/content/")) {
            string2 = string.substring(18, string.indexOf("/child/attachment"));
        }
        a.debug((Object)("Page id [" + string2 + "]"));
        return string2;
    }

    private List<FileItem> a(SmartRequestWrapper smartRequestWrapper) {
        List<Object> list = new ArrayList<FileItem>();
        try {
            list = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest((HttpServletRequest)smartRequestWrapper);
        }
        catch (FileUploadException fileUploadException) {
            a.debug((Object)fileUploadException.getMessage());
        }
        return list;
    }

    private InputStream a(@NotNull FileItem fileItem) {
        InputStream inputStream = null;
        try {
            inputStream = fileItem.getInputStream();
        }
        catch (IOException iOException) {
            a.debug((Object)iOException.getMessage());
        }
        return inputStream;
    }

    private String a(String string) {
        a.debug((Object)("Get space key with page id [" + string + "]"));
        String string2 = null;
        if (string != null) {
            try {
                long l = Long.parseLong(string);
                string2 = this.k.getSpaceFromPageId(l);
            }
            catch (NumberFormatException numberFormatException) {
                a.debug((Object)numberFormatException.getMessage());
            }
        }
        a.debug((Object)("Space key [" + string2 + "]"));
        return string2;
    }

    private int a(int n, String string, long l, boolean bl, boolean bl2, List<String> list) {
        Space space = this.k.getSpace(string);
        if (this.h.m() && space != null && !bl2 && this.h.f(string)) {
            a.debug((Object)("Checking quota for space key [" + string + "]"));
            a.debug((Object)("Total file size [" + l + "]"));
            Map<String, String> map = this.h.a(space, l);
            if (!Boolean.parseBoolean(map.get("isSufficient"))) {
                n = -2;
                String string2 = this.a(map, bl, l);
                list.add(string2);
            }
        }
        return n;
    }

    private int a(@NotNull SmartRequestWrapper smartRequestWrapper, List<String> list) {
        String string;
        a.debug((Object)"Checking non-multipart request");
        int n = 0;
        String string2 = smartRequestWrapper.getParameter("spaceKey");
        long l = Long.parseLong(smartRequestWrapper.getParameter("size"));
        String string3 = smartRequestWrapper.getParameter("filename");
        String string4 = FileTypeHelper.d(string3);
        a.debug((Object)("File name [" + string3 + "]"));
        a.debug((Object)("File ext. [" + string4 + "]"));
        if (!this.h.a(string4, false)) {
            n = -1;
        } else {
            string = FileTypeHelper.a(string3, (InputStream)smartRequestWrapper.getInputStream());
            a.debug((Object)("Mime type [" + string + "]"));
            if (!this.h.a(string4, string, (InputStream)smartRequestWrapper.getInputStream(), false)) {
                n = -1;
            } else if (this.h.e() && this.h.a(string, l, AuthenticatedUserThreadLocal.get())) {
                n = -3;
            }
        }
        string = this.k.getSpace(string2);
        if (n != 0) {
            list.add(this.a(n, string3, false));
        } else if (this.h.m() && string != null && this.h.f(string2)) {
            a.debug((Object)("Space key [" + string2 + "]"));
            a.debug((Object)("File size [" + l + "]"));
            Map<String, String> map = this.h.a((Space)string, l);
            if (!Boolean.parseBoolean(map.get("isSufficient"))) {
                n = -2;
                String string5 = this.a(map, false, l);
                list.add(string5);
            }
        }
        return n;
    }

    private String a(int n, String string, boolean bl) {
        String string2;
        switch (n) {
            case -1: {
                string2 = this.h.getFileTypeErrorMessage();
                break;
            }
            case -2: {
                string2 = this.h.getQuotaErrorMessage();
                break;
            }
            case -3: {
                string2 = this.h.getFileSizeErrorMessage();
                break;
            }
            default: {
                string2 = "";
            }
        }
        if (bl) {
            string2 = string2 + " (" + string + ")";
        }
        return HtmlUtils.htmlEscape((String)string2);
    }

    @NotNull
    private String a(@NotNull Map<String, String> map, boolean bl, long l) {
        String string = this.a(-2, null, false);
        String string2 = this.j.getText("com.akeles.acc.quota.used");
        String string3 = this.j.getText("com.akeles.acc.quota.available");
        String string4 = this.j.getText("com.akeles.acc.quota.usage.details", new Serializable[]{(Serializable)((Object)map.get("used")), (Serializable)((Object)map.get("allocated"))});
        string = bl ? string + "<br><br><span style=\"display:inline-block;width:80px;\"><strong>" + string2 + "</strong></span>" + string4 + "<br><span style=\"display:inline-block;width:80px;\"><strong>" + string3 + "</strong></span>" + map.get("available") : string + "\n\n" + string2 + " \t " + string4 + "\n" + string3 + " \t " + map.get("available") + "\n" + this.j.getText("com.akeles.acc.quota.fileSize") + " \t " + this.a(l);
        return string;
    }

    @NotNull
    private String a(long l) {
        String string = this.h.getUnit();
        String string2 = AttachmentCheckerHelper.a(l, string, 2);
        string2 = string2.equals("0.00") ? AttachmentCheckerHelper.a(l, "KB", 2) + " " + "KB" : string2 + " " + string;
        return string2;
    }

    @NotNull
    private JSONObject a(@NotNull List<String> list, boolean bl) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (bl) {
                jSONObject.put("errors", (Object)list.toArray());
            } else {
                jSONObject.put("actionErrors", (Object)new String[]{list.get(0)});
            }
        }
        catch (JSONException jSONException) {
            a.debug((Object)jSONException);
        }
        return jSONObject;
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, @NotNull JSONObject jSONObject) throws IOException {
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding("UTF-8");
        a.debug((Object)"Returning JSON response...");
        String string = jSONObject.toString();
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
        a.debug((Object)("Response [" + string + "]"));
    }

    private void a(@NotNull HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        a.debug((Object)"Returning HTML response...");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.write(string);
        printWriter.flush();
        printWriter.close();
    }
}

