/*
 * Decompiled with CFR 0.152.
 */
package com.akelesconsulting.confluence.plugins.ao.service;

import com.akelesconsulting.confluence.plugins.ao.entity.AttachmentToScan;
import com.akelesconsulting.confluence.plugins.ao.entity.VirusScanError;
import com.akelesconsulting.confluence.plugins.rest.beans.VirusScanErrorBean;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Functions;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class VirusScanErrorService {
    private static final Logger a = Logger.getLogger((String)"com.akeles.plugins.acc.service.VirusScanErrorService");
    private final ActiveObjects b;
    private final TransactionTemplate c;

    @Inject
    public VirusScanErrorService(@ComponentImport ActiveObjects activeObjects, @ComponentImport TransactionTemplate transactionTemplate) {
        this.b = activeObjects;
        this.c = transactionTemplate;
    }

    public List<VirusScanError> getVirusScanErrorList() {
        return (List)this.c.execute(() -> Arrays.asList(this.b.find(VirusScanError.class, Query.select().order("ID DESC").limit(50))));
    }

    public List<VirusScanError> a(@NotNull List<Integer> list) {
        a.debug((Object)"Get list of VirusScanError");
        String string = list.stream().map(Functions.constant((Object)"?")).collect(Collectors.joining(", "));
        Object[] objectArray = list.toArray();
        a.debug((Object)("VirusScanError ID array [" + Arrays.toString(objectArray) + "]"));
        return (List)this.c.execute(() -> Arrays.asList(this.b.find(VirusScanError.class, Query.select().where("ID IN (" + string + ")", objectArray).order("ID DESC"))));
    }

    public Integer a(Attachment attachment, AttachmentToScan attachmentToScan, VirusScanErrorBean virusScanErrorBean, Date date) {
        Integer n = null;
        try {
            n = (Integer)this.c.execute(() -> {
                String string = attachment.getFileName();
                long l = attachment.getFileSize();
                ConfluenceUser confluenceUser = attachment.getCreator();
                String string2 = confluenceUser == null ? "" : confluenceUser.getKey().getStringValue();
                VirusScanError virusScanError = (VirusScanError)this.b.create(VirusScanError.class, new DBParam[]{new DBParam("ATTACHMENT_ID", (Object)attachmentToScan.getAttachmentId()), new DBParam("VERSION", (Object)attachmentToScan.getVersion()), new DBParam("FILE_NAME", (Object)string), new DBParam("FILE_SIZE", (Object)l), new DBParam("CREATION_DATE", (Object)attachmentToScan.getCreationDate()), new DBParam("USER_KEY", (Object)string2), new DBParam("ATTACHED_TO_ID", (Object)attachmentToScan.getAttachedToId()), new DBParam("NODE_ID", (Object)virusScanErrorBean.getNodeId()), new DBParam("EXIT_CODE", (Object)virusScanErrorBean.getExitCode()), new DBParam("IS_INFECTION", (Object)virusScanErrorBean.isInfection()), new DBParam("OUTPUT", (Object)virusScanErrorBean.getOutput()), new DBParam("EXEC_DATE", (Object)date)});
                a.debug((Object)("Created VirusScanError ID [" + virusScanError.getID() + "]"));
                return virusScanError.getID();
            });
        }
        catch (Exception exception) {
            a.error((Object)"Error creating VirusScanError", (Throwable)exception);
        }
        return n;
    }
}

